/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.util.ConfigApiLoggerInfo;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandModelProvider;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.common.util.admin.ParamTokenizer;
import org.glassfish.config.support.CrudResolver;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.Self;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.GenerateServiceFromMethod;
import org.jvnet.hk2.config.InjectionManager;
import org.jvnet.hk2.config.InjectionResolver;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.tiger_types.Types;

public abstract class GenericCrudCommand
implements CommandModelProvider,
PostConstruct,
AdminCommandSecurity.Preauthorization {
    private InjectionResolver<Param> injector;
    @Inject
    @Self
    private ActiveDescriptor<?> myself;
    protected static final Logger LOGGER = ConfigApiLoggerInfo.getLogger();
    protected static final LocalStringManagerImpl LOCAL_STRINGS = new LocalStringManagerImpl(GenericCrudCommand.class);
    protected String commandName;
    protected Class parentType = null;
    protected Class targetType = null;
    protected Method targetMethod;
    protected static final Level level = Level.FINE;
    @Inject
    ServiceLocator habitat;
    InjectionManager manager;
    CrudResolver resolver;
    InjectionResolver paramResolver;
    Class<? extends CrudResolver> resolverType;

    void prepareInjection(AdminCommandContext ctx) {
        this.manager = new InjectionManager();
        this.resolver = (CrudResolver)this.habitat.getService(this.resolverType, new Annotation[0]);
        this.paramResolver = this.getInjectionResolver();
        this.manager.inject((Object)this.resolver, new InjectionResolver[]{this.paramResolver});
    }

    public boolean preAuthorization(AdminCommandContext adminCommandContext) {
        this.prepareInjection(adminCommandContext);
        return true;
    }

    private static String getOne(String key, Map<String, List<String>> metadata) {
        if (key == null || metadata == null) {
            return null;
        }
        List<String> findInMe = metadata.get(key);
        if (findInMe == null) {
            return null;
        }
        return findInMe.get(0);
    }

    public void postConstruct() {
        this.commandName = this.myself.getName();
        String parentTypeName = GenericCrudCommand.getOne("ParentConfigured", this.myself.getMetadata());
        LOGGER.log(level, "Generic method parent targeted type is {0}", parentTypeName);
        try {
            this.parentType = this.loadClass(parentTypeName);
        }
        catch (ClassNotFoundException e) {
            String msg = LOCAL_STRINGS.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.configbean_not_found", "The Config Bean {0} cannot be loaded by the generic command implementation : {1}", new Object[]{parentTypeName, e.getMessage()});
            LogHelper.log((Logger)LOGGER, (Level)Level.SEVERE, (String)"NCLS-CFGAPI-00126", (Throwable)e, (Object[])new Object[]{parentTypeName});
            throw new RuntimeException(msg, e);
        }
        String methodName = GenericCrudCommand.getOne("MethodName", this.myself.getMetadata());
        this.targetMethod = null;
        this.targetMethod = this.getMethodFromAnnotation(methodName);
        if (this.targetMethod == null) {
            String msg = LOCAL_STRINGS.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.configbean_not_found", "The Config Bean {0} cannot be loaded by the generic command implementation : {1}", new Object[]{parentTypeName, methodName});
            LOGGER.log(Level.SEVERE, "NCLS-CFGAPI-00126", parentTypeName);
            throw new RuntimeException(msg);
        }
        String targetTypeName = GenericCrudCommand.getOne("MethodListActual", this.myself.getMetadata());
        try {
            this.targetType = this.loadClass(targetTypeName);
        }
        catch (ClassNotFoundException e) {
            String msg = LOCAL_STRINGS.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.configbean_not_found", "The Config Bean {0} cannot be loaded by the generic command implementation : {1}", new Object[]{targetTypeName, e.getMessage()});
            LogHelper.log((Logger)LOGGER, (Level)Level.SEVERE, (String)"NCLS-CFGAPI-00126", (Throwable)e, (Object[])new Object[]{targetTypeName});
            throw new RuntimeException(msg, e);
        }
    }

    protected <T extends Annotation> T getAnnotation(Method target, Class<T> type) {
        T annotation = this.targetMethod.getAnnotation(type);
        if (annotation == null) {
            String msg = LOCAL_STRINGS.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.annotation_not_found", "Cannot find annotation {0} with value {1} on method {2}", new Object[]{type.getName(), this.commandName, this.targetMethod.toString()});
            throw new RuntimeException(msg);
        }
        return annotation;
    }

    public void setInjectionResolver(InjectionResolver<Param> injector) {
        this.injector = injector;
    }

    public InjectionResolver<Param> getInjectionResolver() {
        final InjectionResolver<Param> delegate = this.injector;
        return new InjectionResolver<Param>(Param.class){

            public <V> V getValue(Object component, AnnotatedElement annotated, Type genericType, Class<V> type) throws MultiException {
                if (type.isAssignableFrom(List.class)) {
                    BeanInfo beanInfo;
                    List values;
                    block20: {
                        try {
                            if (annotated instanceof Method) {
                                values = (List)((Method)annotated).invoke(component, new Object[0]);
                                break block20;
                            }
                            if (annotated instanceof Field) {
                                values = (List)((Field)annotated).get(component);
                                break block20;
                            }
                            String msg = LOCAL_STRINGS.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.invalid_type", "Invalid annotated type {0} passed to InjectionResolver:getValue()", new Object[]{annotated.getClass().toString()});
                            LOGGER.log(Level.SEVERE, "NCLS-CFGAPI-00127", annotated.getClass().toString());
                            throw new MultiException((Throwable)new IllegalArgumentException(msg));
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            String msg = LOCAL_STRINGS.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.invocation_failure", "Failure {0} while getting List<?> values from component", new Object[]{e.getMessage()});
                            LOGGER.log(Level.SEVERE, "NCLS-CFGAPI-00128");
                            throw new MultiException((Throwable)new IllegalStateException(msg, e));
                        }
                    }
                    Object value = delegate.getValue(component, annotated, genericType, type);
                    if (value == null) {
                        LOGGER.log(level, "Value of {0} is null", annotated);
                        return null;
                    }
                    Type genericReturnType = null;
                    if (annotated instanceof Method) {
                        genericReturnType = ((Method)annotated).getGenericReturnType();
                    } else if (annotated instanceof Field) {
                        genericReturnType = ((Field)annotated).getGenericType();
                    }
                    if (genericReturnType == null) {
                        throw new MultiException((Throwable)new IllegalArgumentException("Cannot determine parametized type from " + annotated));
                    }
                    Class itemType = Types.erasure((Type)Types.getTypeArgument((Type)genericReturnType, (int)0));
                    if (LOGGER.isLoggable(level)) {
                        LOGGER.log(level, "Found that List<?> really is a List<{0}>", itemType);
                    }
                    if (itemType == null) {
                        String msg = LOCAL_STRINGS.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.nongeneric_type", "The List type returned by {0} must be a generic type", new Object[]{annotated.toString()});
                        LOGGER.log(Level.SEVERE, "NCLS-CFGAPI-00129", annotated.toString());
                        throw new MultiException((Throwable)new IllegalArgumentException(msg));
                    }
                    if (!ConfigBeanProxy.class.isAssignableFrom(itemType)) {
                        String msg = LOCAL_STRINGS.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.wrong_type", "The generic type {0} is not supported, only List<? extends ConfigBeanProxy> is", new Object[]{annotated.toString()});
                        LOGGER.log(Level.SEVERE, "NCLS-CFGAPI-00130", annotated.toString());
                        throw new MultiException((Throwable)new IllegalArgumentException(msg));
                    }
                    Properties props = GenericCrudCommand.convertStringToProperties(value.toString(), ':');
                    if (LOGGER.isLoggable(level)) {
                        for (Map.Entry<Object, Object> entry : props.entrySet()) {
                            LOGGER.log(level, "Subtype {0} key:{1} value:{2}", new Object[]{itemType, entry.getKey(), entry.getValue()});
                        }
                    }
                    try {
                        beanInfo = Introspector.getBeanInfo(itemType);
                    }
                    catch (IntrospectionException e) {
                        String msg = LOCAL_STRINGS.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.introspection_failure", "Failure {0} while instrospecting {1} to find all getters and setters", new Object[]{e.getMessage(), itemType.getName()});
                        LogHelper.log((Logger)LOGGER, (Level)Level.SEVERE, (String)"NCLS-CFGAPI-00131", (Throwable)e, (Object[])new Object[]{itemType.getName()});
                        throw new MultiException((Throwable)new IllegalStateException(msg, e));
                    }
                    for (final Map.Entry<Object, Object> entry : props.entrySet()) {
                        ConfigBeanProxy child = (ConfigBeanProxy)component;
                        try {
                            ConfigBeanProxy cc = child.createChild(itemType);
                            new InjectionManager().inject((Object)cc, itemType, new InjectionResolver[]{new InjectionResolver<Attribute>(Attribute.class){

                                public boolean isOptional(AnnotatedElement annotated, Attribute annotation) {
                                    return true;
                                }

                                public Method getSetterMethod(Method annotated, Attribute annotation) {
                                    for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                                        if (!pd.getReadMethod().equals(annotated)) continue;
                                        return pd.getWriteMethod();
                                    }
                                    return annotated;
                                }

                                public <V> V getValue(Object component, AnnotatedElement annotated, Type genericType, Class<V> type) throws MultiException {
                                    String name = annotated.getAnnotation(Attribute.class).value();
                                    if ((name == null || name.length() == 0) && annotated instanceof Method) {
                                        name = ((Method)annotated).getName().substring(3);
                                        if (name.equalsIgnoreCase("name") || name.equalsIgnoreCase("key")) {
                                            return type.cast(entry.getKey());
                                        }
                                        if (name.equalsIgnoreCase("value")) {
                                            return type.cast(entry.getValue());
                                        }
                                    }
                                    return null;
                                }
                            }});
                            values.add(cc);
                        }
                        catch (TransactionFailure transactionFailure) {
                            String msg = LOCAL_STRINGS.getLocalString(GenericCrudCommand.class, "GenericCrudCommand.transactionException", "Transaction exception {0} while injecting {1}", new Object[]{transactionFailure.getMessage(), itemType});
                            LogHelper.log((Logger)LOGGER, (Level)Level.SEVERE, (String)"NCLS-CFGAPI-00132", (Throwable)transactionFailure, (Object[])new Object[]{itemType});
                            throw new MultiException((Throwable)new IllegalStateException(msg, transactionFailure));
                        }
                    }
                    return null;
                }
                return (V)delegate.getValue(component, annotated, genericType, type);
            }

            public boolean isOptional(AnnotatedElement annotated, Param annotation) {
                return annotation.optional();
            }
        };
    }

    protected Class<?> loadClass(String type) throws ClassNotFoundException {
        HK2Loader loader = this.myself.getLoader();
        if (loader == null) {
            return this.getClass().getClassLoader().loadClass(type);
        }
        try {
            return loader.loadClass(type);
        }
        catch (MultiException me) {
            for (Throwable th : me.getErrors()) {
                if (!(th instanceof ClassNotFoundException)) continue;
                throw (ClassNotFoundException)th;
            }
            throw new ClassNotFoundException(me.getMessage());
        }
    }

    public static Properties convertStringToProperties(String propsString, char sep) {
        Properties properties = new Properties();
        if (propsString != null && !propsString.equals("[]")) {
            String unbracedString = propsString.substring(propsString.indexOf(91) + 1);
            ParamTokenizer stoken = new ParamTokenizer(unbracedString, sep);
            while (stoken.hasMoreTokens()) {
                String token = stoken.nextTokenKeepEscapes();
                ParamTokenizer nameTok = new ParamTokenizer(token, '=');
                String name = null;
                String value = null;
                if (nameTok.hasMoreTokens()) {
                    name = nameTok.nextToken();
                }
                if (nameTok.hasMoreTokens()) {
                    value = nameTok.nextToken();
                }
                if (nameTok.hasMoreTokens() || name == null || value == null) {
                    throw new IllegalArgumentException("TODO : i18n : Invalid property syntax." + propsString);
                }
                int index = value.indexOf(93);
                String unbracedValue = index > 0 ? value.substring(0, index) : value;
                properties.setProperty(name, unbracedValue);
            }
        }
        return properties;
    }

    public static String elementName(DomDocument document, Class<?> parent, Class<?> child) throws ClassNotFoundException {
        ConfigModel cm = document.buildModel(parent);
        for (String elementName : cm.getElementNames()) {
            ConfigModel.Property prop = cm.getElement(elementName);
            if (!(prop instanceof ConfigModel.Node)) continue;
            ConfigModel childCM = ((ConfigModel.Node)prop).getModel();
            String childTypeName = childCM.targetTypeName;
            if (childTypeName.equals(child.getName())) {
                return childCM.getTagName();
            }
            List subChildrenModels = document.getAllModelsImplementing(childCM.classLoaderHolder.loadClass(childTypeName));
            if (subChildrenModels == null) continue;
            for (ConfigModel subChildModel : subChildrenModels) {
                if (!subChildModel.targetTypeName.equals(child.getName())) continue;
                return subChildModel.getTagName();
            }
        }
        return null;
    }

    private Method getMethodFromAnnotation(String methodName) {
        for (Method method : this.parentType.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            for (Annotation annotation : method.getAnnotations()) {
                if (annotation.annotationType().getAnnotation(GenerateServiceFromMethod.class) == null) continue;
                return method;
            }
        }
        return null;
    }

    public abstract Class getDecoratorClass();
}

