/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.realm.config;

import fish.payara.nucleus.microprofile.config.spi.ConfigValueResolver;
import fish.payara.security.annotations.PamIdentityStoreDefinition;
import fish.payara.security.realm.RealmUtil;
import fish.payara.security.realm.config.RealmConfiguration;
import java.util.Arrays;
import java.util.List;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class PamRealmIdentityStoreConfiguration
implements RealmConfiguration {
    private final String name;
    private final List<String> assignGroups;
    private final String jaasContext;

    private PamRealmIdentityStoreConfiguration(PamIdentityStoreDefinition definition) {
        Config config = ConfigProvider.getConfig();
        this.name = definition.value();
        this.assignGroups = config.getValue("payara.security.pam.assignGroups", ConfigValueResolver.class).asList(String.class, Arrays.asList(definition.assignGroups()));
        this.jaasContext = RealmUtil.getConfiguredValue(String.class, definition.jaasContext(), config, "payara.security.pam.jaasContext");
    }

    public static PamRealmIdentityStoreConfiguration from(PamIdentityStoreDefinition definition) {
        return new PamRealmIdentityStoreConfiguration(definition);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getAssignGroups() {
        return this.assignGroups;
    }

    public String getJaasContext() {
        return this.jaasContext;
    }
}

