/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.realm.identitystores;

import com.sun.enterprise.security.auth.WebAndEjbToJaasBridge;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.auth.login.common.LoginException;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.security.common.AppservAccessController;
import fish.payara.security.annotations.RealmIdentityStoreDefinition;
import fish.payara.security.api.CertificateCredential;
import fish.payara.security.realm.config.RealmIdentityStoreConfiguration;
import fish.payara.security.realm.identitystores.CertificateRealmIdentityStore;
import jakarta.enterprise.inject.Typed;
import jakarta.security.enterprise.CallerPrincipal;
import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.credential.UsernamePasswordCredential;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.IdentityStore;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.glassfish.security.common.Group;

@Typed(value={RealmIdentityStore.class})
public class RealmIdentityStore
implements IdentityStore {
    private RealmIdentityStoreConfiguration configuration;

    public void setConfiguration(RealmIdentityStoreDefinition definition) {
        this.configuration = RealmIdentityStoreConfiguration.from(definition);
    }

    public CredentialValidationResult validate(Credential credential) {
        if (credential instanceof UsernamePasswordCredential) {
            return this.validate((UsernamePasswordCredential)credential, this.configuration.getName());
        }
        if (credential instanceof CertificateCredential) {
            return CertificateRealmIdentityStore.validate((CertificateCredential)credential, this.configuration.getName());
        }
        return CredentialValidationResult.NOT_VALIDATED_RESULT;
    }

    protected CredentialValidationResult validate(UsernamePasswordCredential credential, String realmName) {
        try {
            Subject subject = this.login(credential, realmName);
            Set groups = subject.getPrincipals(Group.class).stream().map(g -> g.getName()).collect(Collectors.toSet());
            if (!groups.isEmpty()) {
                return new CredentialValidationResult(new CallerPrincipal(credential.getCaller()), groups);
            }
        }
        catch (LoginException ex) {
            return CredentialValidationResult.INVALID_RESULT;
        }
        return CredentialValidationResult.INVALID_RESULT;
    }

    protected Subject login(UsernamePasswordCredential credential, String realmName) {
        String username = credential.getCaller();
        char[] password = credential.getPassword().getValue();
        Subject subject = new Subject();
        AppservAccessController.privileged(() -> subject.getPrivateCredentials().add(new PasswordCredential(username, password, LoginContextDriver.getValidRealm((String)realmName))));
        WebAndEjbToJaasBridge.login((Subject)subject, PasswordCredential.class);
        return subject;
    }
}

