/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.factory;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.apf.AnnotationHandler;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessor;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.apf.factory.Factory;
import org.glassfish.apf.impl.AnnotationProcessorImpl;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class SJSASFactory
extends Factory {
    @Inject
    private ServiceLocator locator;
    private final Set<String> annotationClassNames = new HashSet<String>();
    private final Set<String> annotationClassNamesMetaDataComplete = new HashSet<String>();
    private AnnotationProcessorImpl systemProcessor = null;
    private AnnotationProcessorImpl systemProcessorMetaDataComplete = null;

    public AnnotationProcessor getAnnotationProcessor(boolean isMetaDataComplete) {
        AnnotationProcessorImpl processor = Factory.getDefaultAnnotationProcessor();
        if (!isMetaDataComplete) {
            processor.setDelegate(this.systemProcessor);
        } else {
            processor.setDelegate(this.systemProcessorMetaDataComplete);
        }
        return processor;
    }

    public Set<String> getAnnotations(boolean isMetaDataComplete) {
        if (!isMetaDataComplete) {
            return (Set)((HashSet)this.annotationClassNames).clone();
        }
        return (Set)((HashSet)this.annotationClassNamesMetaDataComplete).clone();
    }

    private static String getAnnotationHandlerForStringValue(ActiveDescriptor<AnnotationHandler> onMe) {
        Map metadata = onMe.getMetadata();
        List answers = (List)metadata.get("AnnotationHandlerFor");
        if (answers == null || answers.isEmpty()) {
            return null;
        }
        return (String)answers.get(0);
    }

    @PostConstruct
    private void postConstruct() {
        if (this.systemProcessor != null && this.systemProcessorMetaDataComplete != null) {
            return;
        }
        this.systemProcessor = new AnnotationProcessorImpl();
        this.systemProcessorMetaDataComplete = new AnnotationProcessorImpl();
        for (ActiveDescriptor i : this.locator.getDescriptors((Filter)BuilderHelper.createContractFilter((String)AnnotationHandler.class.getName()))) {
            ActiveDescriptor descriptor = i;
            String annotationTypeName = SJSASFactory.getAnnotationHandlerForStringValue((ActiveDescriptor<AnnotationHandler>)descriptor);
            if (annotationTypeName == null) continue;
            this.systemProcessor.pushAnnotationHandler(annotationTypeName, (AnnotationHandler)new LazyAnnotationHandler((ActiveDescriptor<AnnotationHandler>)descriptor));
            this.annotationClassNames.add("L" + annotationTypeName.replace('.', '/') + ";");
            if (!annotationTypeName.equals("jakarta.annotation.ManagedBean")) continue;
            this.systemProcessorMetaDataComplete.pushAnnotationHandler(annotationTypeName, (AnnotationHandler)new LazyAnnotationHandler((ActiveDescriptor<AnnotationHandler>)descriptor));
            this.annotationClassNamesMetaDataComplete.add("L" + annotationTypeName.replace('.', '/') + ";");
        }
    }

    private class LazyAnnotationHandler
    implements AnnotationHandler {
        private final ActiveDescriptor<AnnotationHandler> descriptor;
        private AnnotationHandler handler;

        private LazyAnnotationHandler(ActiveDescriptor<AnnotationHandler> descriptor) {
            this.descriptor = descriptor;
        }

        private AnnotationHandler getHandler() {
            if (this.handler != null) {
                return this.handler;
            }
            this.handler = (AnnotationHandler)SJSASFactory.this.locator.getServiceHandle(this.descriptor).getService();
            return this.handler;
        }

        public Class<? extends Annotation> getAnnotationType() {
            return this.getHandler().getAnnotationType();
        }

        public HandlerProcessingResult processAnnotation(AnnotationInfo element) throws AnnotationProcessorException {
            return this.getHandler().processAnnotation(element);
        }

        public Class<? extends Annotation>[] getTypeDependencies() {
            return this.getHandler().getTypeDependencies();
        }
    }
}

