/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.opentracing.span;

import fish.payara.notification.requesttracing.RequestTraceSpan;
import fish.payara.notification.requesttracing.RequestTraceSpanLog;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tag;
import java.lang.annotation.Annotation;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;

@Deprecated
public class Span
extends RequestTraceSpan
implements io.opentracing.Span {
    private final String applicationName;

    public Span(String operationName, String applicationName) {
        super(operationName);
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public SpanContext context() {
        return this.getSpanContext();
    }

    public io.opentracing.Span setTag(String tagName, String tagValue) {
        this.addSpanTag(tagName, tagValue);
        return this;
    }

    public io.opentracing.Span setTag(String tagName, boolean tagValue) {
        this.addSpanTag(tagName, Boolean.toString(tagValue));
        return this;
    }

    public io.opentracing.Span setTag(String tagName, Number tagValue) {
        this.addSpanTag(tagName, String.valueOf(tagValue));
        return this;
    }

    public <T> io.opentracing.Span setTag(Tag<T> tag, T tagValue) {
        this.addSpanTag(tag, String.valueOf(tagValue));
        return this;
    }

    public io.opentracing.Span log(Map<String, ?> map) {
        RequestTraceSpanLog spanLog = new RequestTraceSpanLog();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            spanLog.addLogEntry(entry.getKey(), String.valueOf(entry.getValue()));
        }
        this.addSpanLog(spanLog);
        return this;
    }

    public io.opentracing.Span log(long timestampMicroseconds, Map<String, ?> map) {
        RequestTraceSpanLog spanLog = new RequestTraceSpanLog(this.convertTimestampMicrosToTimestampMillis(timestampMicroseconds));
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            spanLog.addLogEntry(entry.getKey(), String.valueOf(entry.getValue()));
        }
        this.addSpanLog(spanLog);
        return this;
    }

    public io.opentracing.Span log(String logEvent) {
        RequestTraceSpanLog spanLog = new RequestTraceSpanLog(logEvent);
        this.addSpanLog(spanLog);
        return this;
    }

    public io.opentracing.Span log(long timestampMicroseconds, String logEvent) {
        RequestTraceSpanLog spanLog = new RequestTraceSpanLog(this.convertTimestampMicrosToTimestampMillis(timestampMicroseconds), logEvent);
        this.addSpanLog(spanLog);
        return this;
    }

    public io.opentracing.Span setBaggageItem(String key, String value) {
        this.getSpanContext().addBaggageItem(key, value);
        return this;
    }

    public String getBaggageItem(String key) {
        return (String)this.getSpanContext().getBaggageItems().get(key);
    }

    public io.opentracing.Span setOperationName(String operationName) {
        this.setEventName(operationName);
        return this;
    }

    public void finish() {
        RequestTracingService requestTracingService = this.getRequestTracingService();
        if (requestTracingService != null) {
            requestTracingService.traceSpan(this);
        }
    }

    public void finish(long finishMicros) {
        long finishMillis = this.convertTimestampMicrosToTimestampMillis(finishMicros);
        RequestTracingService requestTracingService = this.getRequestTracingService();
        if (requestTracingService != null) {
            requestTracingService.traceSpan(this, finishMillis);
        }
    }

    public void setStartTime(long startTimeMicros) {
        super.setStartInstant(Instant.ofEpochMilli(this.convertTimestampMicrosToTimestampMillis(startTimeMicros)));
    }

    private long convertTimestampMicrosToTimestampMillis(long timestampMicroseconds) {
        return TimeUnit.MILLISECONDS.convert(timestampMicroseconds, TimeUnit.MICROSECONDS);
    }

    private RequestTracingService getRequestTracingService() {
        ServiceHandle serviceHandle;
        RequestTracingService requestTracingService = null;
        ServiceLocator serviceLocator = Globals.getDefaultBaseServiceLocator();
        if (serviceLocator != null && (serviceHandle = serviceLocator.getServiceHandle(RequestTracingService.class, new Annotation[0])) != null && serviceHandle.isActive()) {
            requestTracingService = (RequestTracingService)serviceHandle.getService();
        }
        return requestTracingService;
    }
}

