/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.notification;

import com.sun.enterprise.config.serverbeans.Config;
import fish.payara.internal.notification.NotifierManager;
import fish.payara.internal.notification.NotifierUtils;
import fish.payara.internal.notification.PayaraConfiguredNotifier;
import fish.payara.internal.notification.PayaraNotification;
import fish.payara.internal.notification.PayaraNotifier;
import fish.payara.internal.notification.PayaraNotifierConfiguration;
import fish.payara.internal.notification.admin.NotificationServiceConfiguration;
import fish.payara.nucleus.notification.NotifierHandler;
import fish.payara.nucleus.notification.log.LogNotifierConfiguration;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.messaging.MessageReceiver;
import org.glassfish.hk2.api.messaging.SubscribeTo;
import org.glassfish.hk2.extras.ExtrasUtilities;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="notification-service")
@RunLevel(value=10)
@MessageReceiver
public class NotificationService
implements NotifierManager,
EventListener,
ConfigListener {
    private static final Logger logger = Logger.getLogger(NotificationService.class.getName());
    @Inject
    @Named(value="default-instance-name")
    @Optional
    private NotificationServiceConfiguration configuration;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private Events events;
    @Inject
    private Transactions transactions;
    private final Set<NotifierHandler> notifiers = new HashSet<NotifierHandler>();
    private boolean isInstance;
    private boolean enabled;

    public NotificationService() {
        ExtrasUtilities.enableTopicDistribution((ServiceLocator)Globals.getDefaultHabitat());
    }

    @PostConstruct
    void initialize() {
        if (this.configuration == null) {
            this.configuration = (NotificationServiceConfiguration)this.serviceLocator.getService(NotificationServiceConfiguration.class, new Annotation[0]);
        }
        if (this.events != null) {
            this.events.register((EventListener)this);
        }
        ServerEnvironment env = (ServerEnvironment)this.serviceLocator.getService(ServerEnvironment.class, new Annotation[0]);
        this.isInstance = env.isInstance();
        List notifierHandles = this.serviceLocator.getAllServiceHandles(PayaraNotifier.class, new Annotation[0]);
        for (ServiceHandle handle : notifierHandles) {
            NotifierHandler handler;
            boolean isNotifierConfigurable = handle.getActiveDescriptor().getAdvertisedContracts().contains(PayaraConfiguredNotifier.class.getName());
            if (isNotifierConfigurable) {
                PayaraNotifierConfiguration notifierConfig = this.getOrCreateNotifierConfiguration(handle);
                handler = new NotifierHandler((ServiceHandle<PayaraNotifier>)handle, notifierConfig);
            } else {
                handler = new NotifierHandler((ServiceHandle<PayaraNotifier>)handle);
            }
            this.notifiers.add(handler);
        }
    }

    @PreDestroy
    void destroy() {
        this.notifiers.clear();
        if (this.events != null) {
            this.events.unregister((EventListener)this);
        }
    }

    public void event(EventListener.Event<?> event) {
        if (event.is(EventTypes.SERVER_READY)) {
            this.bootstrapNotificationService();
        }
        if (event.is(EventTypes.SERVER_SHUTDOWN)) {
            this.shutdownNotificationService();
        }
        this.transactions.addListenerForType(NotificationServiceConfiguration.class, this);
    }

    public void shutdownNotificationService() {
        this.notifiers.forEach(NotifierHandler::destroy);
    }

    public void bootstrapNotificationService() {
        if (this.configuration != null) {
            boolean wasEnabled = this.enabled;
            this.enabled = Boolean.valueOf(this.configuration.getEnabled());
            if (this.enabled) {
                List<PayaraNotifierConfiguration> notifierConfigurations = this.configuration.getNotifierConfigurationList();
                if (notifierConfigurations != null && notifierConfigurations.isEmpty()) {
                    try {
                        ConfigSupport.apply(new SingleConfigCode<NotificationServiceConfiguration>(){

                            @Override
                            public Object run(NotificationServiceConfiguration configurationProxy) throws PropertyVetoException, TransactionFailure {
                                LogNotifierConfiguration notifierConfiguration = (LogNotifierConfiguration)configurationProxy.createChild(LogNotifierConfiguration.class);
                                notifierConfiguration.enabled(true);
                                configurationProxy.getNotifierConfigurationList().add(notifierConfiguration);
                                return configurationProxy;
                            }
                        }, this.configuration);
                    }
                    catch (TransactionFailure e) {
                        logger.log(Level.SEVERE, "Error occurred while setting initial log notifier configuration", e);
                    }
                }
                this.notifiers.forEach(NotifierHandler::bootstrap);
                logger.info("Payara Notification Service bootstrapped.");
            } else if (wasEnabled) {
                this.shutdownNotificationService();
            }
        }
    }

    public void notify(@SubscribeTo PayaraNotification event) {
        if (this.enabled) {
            List<String> blacklist = event.getNotifierBlacklist();
            List<String> whitelist = event.getNotifierWhitelist();
            for (NotifierHandler handler : this.notifiers) {
                String notifierName = handler.getName();
                if (blacklist != null && blacklist.contains(notifierName) || whitelist != null && !whitelist.contains(notifierName)) continue;
                handler.accept(event);
            }
        }
    }

    @Override
    public void reconfigureNotifier(PayaraNotifierConfiguration configuration) {
        if (!this.enabled || configuration == null) {
            return;
        }
        for (NotifierHandler handler : this.notifiers) {
            PayaraNotifierConfiguration notifierConfig = handler.getConfig();
            if (notifierConfig == null || !notifierConfig.getClass().isAssignableFrom(configuration.getClass())) continue;
            handler.reconfigure();
            return;
        }
    }

    @Override
    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        boolean isCurrentInstanceMatchTarget = false;
        if (this.isInstance) {
            isCurrentInstanceMatchTarget = true;
        } else {
            for (PropertyChangeEvent pe : events) {
                ConfigBeanProxy proxy;
                for (proxy = (ConfigBeanProxy)pe.getSource(); proxy != null && !(proxy instanceof Config); proxy = proxy.getParent()) {
                }
                if (proxy == null || !((Config)proxy).isDas()) continue;
                isCurrentInstanceMatchTarget = true;
                break;
            }
        }
        if (isCurrentInstanceMatchTarget) {
            return ConfigSupport.sortAndDispatch(events, new Changed(){

                @Override
                public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type, Class<T> changedType, T changedInstance) {
                    if (changedType.equals(NotificationServiceConfiguration.class)) {
                        NotificationService.this.configuration = (NotificationServiceConfiguration)((Object)changedInstance);
                    }
                    return null;
                }
            }, logger);
        }
        return null;
    }

    private PayaraNotifierConfiguration getOrCreateNotifierConfiguration(ServiceHandle<?> handle) {
        final Class configClass = NotifierUtils.getConfigurationClass(handle.getActiveDescriptor().getImplementationClass());
        if (this.configuration.getNotifierConfigurationByType(configClass) == null) {
            try {
                ConfigSupport.apply(new SingleConfigCode<NotificationServiceConfiguration>(){

                    @Override
                    public Object run(NotificationServiceConfiguration configurationProxy) throws PropertyVetoException, TransactionFailure {
                        PayaraNotifierConfiguration config = (PayaraNotifierConfiguration)configurationProxy.createChild(configClass);
                        configurationProxy.getNotifierConfigurationList().add(config);
                        return config;
                    }
                }, this.configuration);
            }
            catch (TransactionFailure e) {
                logger.log(Level.SEVERE, "Error occurred while setting initial notifier configuration", e);
            }
        }
        return this.configuration.getNotifierConfigurationByType(configClass);
    }
}

