/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.loader;

import com.sun.enterprise.util.CULoggerInfo;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.logging.Logger;

public class CurrentBeforeParentClassLoader
extends URLClassLoader {
    protected boolean currentBeforeParentEnabled = false;
    private final ClassLoader system = this.getClass().getClassLoader();
    private final ClassLoader _parent = this.getParent();
    private final ClassLoader parent = this._parent != null ? this._parent : this.system;
    private static final Logger logger = CULoggerInfo.getLogger();
    public static final String PARENT_CLASSLOADER_DELEGATE_PROPERTY = "fish.payara.classloading.delegate";

    public CurrentBeforeParentClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public CurrentBeforeParentClassLoader(URL[] urls) {
        super(urls);
    }

    public CurrentBeforeParentClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(urls, parent, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        boolean isWhitelisted;
        boolean bl = isWhitelisted = this.isWhitelistEnabled() && this.isWhiteListed(name);
        if (!this.currentBeforeParentEnabled && (!this.isWhitelistEnabled() || isWhitelisted) || this.isAlwaysDelegate(name)) {
            return super.loadClass(name, resolve);
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            try {
                c = this.findClass(name);
                logger.finest(String.format("Found Locally: %s - %s", name, c.getName()));
            }
            catch (ClassNotFoundException e) {
                if (!this.isWhitelistEnabled() || isWhitelisted) {
                    logger.finest(String.format("Not Found Locally - Looking in Parent: %s", name));
                    return this.parent.loadClass(name);
                }
                throw new ClassNotFoundException(String.format("Whitelist enabled, but class [%s] is not whitelisted", name), e);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    protected boolean isWhiteListed(String className) {
        return false;
    }

    protected boolean isWhitelistEnabled() {
        return false;
    }

    public final void enableCurrentBeforeParent() {
        String parentClassLoaderDelegateStr = System.getProperty(PARENT_CLASSLOADER_DELEGATE_PROPERTY, "true");
        if (!Boolean.parseBoolean(parentClassLoaderDelegateStr)) {
            this.currentBeforeParentEnabled = true;
        }
    }

    public final void enableCurrentBeforeParentUnconditional() {
        this.currentBeforeParentEnabled = true;
    }

    public final void disableCurrentBeforeParent() {
        this.currentBeforeParentEnabled = false;
    }

    private boolean isAlwaysDelegate(String name) {
        return name.startsWith("sun") || name.startsWith("javax") || name.startsWith("jakarta");
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }
}

