/*
 * Decompiled with CFR 0.152.
 */
package com.sun.logging;

import com.sun.logging.LogDomainsLogger;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LogDomains {
    public static final String DOMAIN_ROOT = "javax.";
    public static final String UPGRADE_LOGGER = "upgradeLogger";
    public static final String PACKAGE_ROOT = "com.sun.logging.";
    public static final String RESOURCE_BUNDLE = "LogStrings";
    public static final String RESOURCE_BUNDLE_MESSAGES = "LogMessages";
    public static final String STD_LOGGER = "javax.enterprise.system.std";
    public static final String TOOLS_LOGGER = "javax.enterprise.system.tools";
    public static final String EJB_LOGGER = "javax.enterprise.system.container.ejb";
    public static final String JAVAMAIL_LOGGER = "javax.enterprise.resource.javamail";
    public static final String JMS_LOGGER = "javax.enterprise.resource.jms";
    public static final String WEB_LOGGER = "javax.enterprise.system.container.web";
    public static final String CMP_LOGGER = "javax.enterprise.system.container.cmp";
    public static final String JDO_LOGGER = "javax.enterprise.resource.jdo";
    public static final String ACC_LOGGER = "javax.enterprise.system.container.appclient";
    public static final String MDB_LOGGER = "javax.enterprise.system.container.ejb.mdb";
    public static final String SECURITY_LOGGER = "javax.enterprise.system.core.security";
    public static final String SECURITY_SSL_LOGGER = "javax.enterprise.system.ssl.security";
    public static final String TRANSACTION_LOGGER = "javax.enterprise.system.core.transaction";
    public static final String CORBA_LOGGER = "javax.enterprise.resource.corba";
    public static final String UTIL_LOGGER = "javax.enterprise.system.util";
    public static final String NAMING_LOGGER = "javax.enterprise.system.core.naming";
    public static final String JNDI_LOGGER = "javax.enterprise.system.core.naming";
    public static final String ACTIVATION_LOGGER = "javax.enterprise.system.activation";
    public static final String JTA_LOGGER = "javax.enterprise.resource.jta";
    public static final String RSR_LOGGER = "javax.enterprise.resource.resourceadapter";
    public static final String DPL_LOGGER = "javax.enterprise.system.tools.deployment";
    public static final String DPLAUDIT_LOGGER = "javax.enterprise.system.tools.deployment.audit";
    public static final String DIAGNOSTICS_LOGGER = "javax.enterprise.system.tools.diagnostics";
    public static final String JAXRPC_LOGGER = "javax.enterprise.system.webservices.rpc";
    public static final String JAXR_LOGGER = "javax.enterprise.system.webservices.registry";
    public static final String SAAJ_LOGGER = "javax.enterprise.system.webservices.saaj";
    public static final String SELF_MANAGEMENT_LOGGER = "javax.enterprise.system.core.selfmanagement";
    public static final String SQL_TRACE_LOGGER = "javax.enterprise.resource.sqltrace";
    public static final String ADMIN_LOGGER = "javax.enterprise.system.tools.admin";
    public static final String SERVER_LOGGER = "javax.enterprise.system";
    public static final String CORE_LOGGER = "javax.enterprise.system.core";
    public static final String LOADER_LOGGER = "javax.enterprise.system.core.classloading";
    public static final String CONFIG_LOGGER = "javax.enterprise.system.core.config";
    public static final String PROCESS_LAUNCHER_LOGGER = "javax.enterprise.tools.launcher";
    public static final String GMS_LOGGER = "javax.org.glassfish.gms";
    public static final String AMX_LOGGER = "javax.enterprise.system.amx";
    public static final String JMX_LOGGER = "javax.enterprise.system.jmx";
    public static final String SERVICES_LOGGER = "javax.enterprise.system.core.services";
    public static final String WEBSERVICES_LOGGER = "javax.enterprise.webservices";
    public static final String MONITORING_LOGGER = "javax.enterprise.system.tools.monitor";
    public static final String PERSISTENCE_LOGGER = "javax.org.glassfish.persistence";
    public static final String VIRTUALIZATION_LOGGER = "javax.org.glassfish.virtualization";
    public static final String PAAS_LOGGER = "javax.org.glassfish.paas";

    private LogDomains() {
    }

    public static Logger getLogger(Class clazz, String namePrefix) {
        return LogDomains.getLogger(clazz, namePrefix, true);
    }

    public static Logger getLogger(Class clazz, String namePrefix, boolean resourceBundleLookup) {
        ClassLoader contextClassLoader = resourceBundleLookup ? clazz.getClassLoader() : null;
        return LogDomains.getLogger(clazz, namePrefix, contextClassLoader);
    }

    public static Logger getLogger(Class clazz, String namePrefix, ClassLoader resourceBundleLoader) {
        String loggerName = LogDomains.getLoggerName(clazz, namePrefix);
        LogManager logManager = LogManager.getLogManager();
        Logger cachedLogger = logManager.getLogger(loggerName);
        if (cachedLogger != null) {
            return cachedLogger;
        }
        String rbName = LogDomains.getResourceBundleNameForDomainRoot(namePrefix);
        ResourceBundle resourceBundle = resourceBundleLoader == null ? null : LogDomains.getResourceBundle(rbName, clazz, resourceBundleLoader);
        LogDomainsLogger cLogger = new LogDomainsLogger(loggerName, resourceBundle);
        boolean added = logManager.addLogger(cLogger);
        if (added) {
            return cLogger;
        }
        return logManager.getLogger(cLogger.getName());
    }

    private static ResourceBundle getResourceBundle(String name, Class<?> clazz, ClassLoader resourceBundleLoader) {
        ResourceBundle classBundle = LogDomains.findResourceBundle(name, clazz, resourceBundleLoader);
        if (classBundle == null) {
            classBundle = LogDomains.findResourceBundle(name, clazz, resourceBundleLoader, RESOURCE_BUNDLE_MESSAGES);
        }
        if (classBundle != null) {
            return classBundle;
        }
        Logger.getAnonymousLogger().log(Level.INFO, "Cannot find the resource bundle for the name {0} for {1} using {2}", new Object[]{name, clazz, resourceBundleLoader});
        return null;
    }

    private static ResourceBundle findResourceBundle(String name, Class<?> clazz, ClassLoader classLoader) {
        return LogDomains.findResourceBundle(name, clazz, classLoader, RESOURCE_BUNDLE);
    }

    private static ResourceBundle findResourceBundle(String name, Class<?> clazz, ClassLoader classLoader, String fileSuffix) {
        ResourceBundle packageRootBundle = LogDomains.tryToFindResourceBundle(name, classLoader, fileSuffix);
        if (packageRootBundle != null) {
            return packageRootBundle;
        }
        StringBuilder rbPackage = new StringBuilder(clazz.getPackage().getName());
        while (true) {
            ResourceBundle subPkgBundle;
            if ((subPkgBundle = LogDomains.tryToFindResourceBundle(rbPackage.toString(), classLoader, fileSuffix)) != null) {
                return subPkgBundle;
            }
            int lastDotIndex = rbPackage.lastIndexOf(".");
            if (lastDotIndex == -1) break;
            rbPackage.delete(lastDotIndex, rbPackage.length());
        }
        return null;
    }

    private static String getLoggerName(Class clazz, String logDomainsConstantName) {
        String pkgName = clazz.getPackage().getName();
        String loggerName = logDomainsConstantName + "." + pkgName;
        return loggerName;
    }

    private static ResourceBundle tryToFindResourceBundle(String name, ClassLoader classLoader, String fileSuffix) {
        try {
            return ResourceBundle.getBundle(name + "." + fileSuffix, Locale.getDefault(), classLoader);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private static String getResourceBundleNameForDomainRoot(String loggerNamePrefix) {
        if (loggerNamePrefix.startsWith(DOMAIN_ROOT)) {
            return loggerNamePrefix.replaceFirst(DOMAIN_ROOT, PACKAGE_ROOT);
        }
        return loggerNamePrefix;
    }
}

