/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.NativeRemoteCommandsBase;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.io.FileListerRelative;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipFileException;
import com.sun.enterprise.util.zip.ZipWriter;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
abstract class InstallNodeBaseCommand
extends NativeRemoteCommandsBase {
    @Param(name="archive", optional=true)
    private String archive;
    @Param(name="installdir", optional=true, defaultValue="${com.sun.aas.productRoot}")
    private String installDir;
    @Param(optional=true, defaultValue="false")
    private boolean create;
    @Param(optional=true, defaultValue="false")
    private boolean save;
    @Param(name="force", optional=true, defaultValue="false")
    private boolean force;
    @Inject
    private ServiceLocator habitat;
    private String archiveName;
    private boolean delete = true;

    InstallNodeBaseCommand() {
    }

    abstract void copyToHosts(File var1, ArrayList<String> var2) throws CommandException;

    abstract void precopy() throws CommandException;

    @Override
    protected void validate() throws CommandException {
        super.validate();
        Globals.setDefaultHabitat((ServiceLocator)this.habitat);
        this.installDir = this.resolver.resolve(this.installDir);
        if (InstallNodeBaseCommand.ok((String)this.archive)) {
            this.archive = SmartFile.sanitize((String)this.archive);
        }
    }

    protected int executeCommand() throws CommandException {
        File zipFile = null;
        try {
            ArrayList<String> binDirFiles = new ArrayList<String>();
            this.precopy();
            zipFile = this.createZipFileIfNeeded(binDirFiles);
            this.copyToHosts(zipFile, binDirFiles);
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandException((Throwable)e);
        }
        finally {
            if (!this.save && this.delete && zipFile != null && !zipFile.delete()) {
                FileUtils.deleteOnExit((File)zipFile);
            }
        }
        return 0;
    }

    final String getInstallDir() {
        return this.installDir;
    }

    final String getArchiveName() {
        return this.archiveName;
    }

    final boolean getForce() {
        return this.force;
    }

    private File createZipFileIfNeeded(ArrayList<String> binDirFiles) throws IOException, ZipFileException {
        File glassFishZipFile;
        File zipFileLocation;
        String baseRootValue = this.getSystemProperty("com.sun.aas.productRoot");
        File installRoot = new File(baseRootValue);
        if (this.archive != null) {
            this.archive = this.archive.replace('\\', '/');
            this.archiveName = this.archive.substring(this.archive.lastIndexOf(47) + 1, this.archive.length());
            zipFileLocation = new File(this.archive.substring(0, this.archive.lastIndexOf(47)));
            glassFishZipFile = new File(this.archive);
            if (glassFishZipFile.exists() && !this.create) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Found {0}", this.archive);
                }
                this.delete = false;
                return glassFishZipFile;
            }
            if (!zipFileLocation.canWrite()) {
                throw new IOException("Cannot write to " + this.archive);
            }
        } else {
            zipFileLocation = new File(".");
            if (!zipFileLocation.canWrite()) {
                zipFileLocation = new File(System.getProperty("java.io.tmpdir"));
            }
            glassFishZipFile = File.createTempFile("glassfish", ".zip", zipFileLocation);
            String filePath = glassFishZipFile.getCanonicalPath();
            filePath = filePath.replaceAll("\\\\", "/");
            this.archiveName = filePath.substring(filePath.lastIndexOf(47) + 1, filePath.length());
        }
        FileListerRelative lister = new FileListerRelative(installRoot);
        lister.keepEmptyDirectories();
        List<String> files = Arrays.asList(lister.getFiles());
        ArrayList<String> resultFiles = new ArrayList<String>();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Number of files to be zipped = " + files.size());
        }
        for (String fileName : files) {
            String fPath = fileName.substring(fileName.lastIndexOf(47) + 1);
            if (fPath.equals(glassFishZipFile.getName())) {
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.finer("Removing file = " + fileName);
                continue;
            }
            if (fileName.contains("domains") || fileName.contains("nodes")) continue;
            resultFiles.add(fileName);
            if (!InstallNodeBaseCommand.isFileWithinBinDirectory(fileName)) continue;
            binDirFiles.add(fileName);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Final number of files to be zipped = " + resultFiles.size());
        }
        String[] filesToZip = new String[resultFiles.size()];
        filesToZip = resultFiles.toArray(filesToZip);
        ZipWriter writer = new ZipWriter(FileUtils.safeGetCanonicalPath((File)glassFishZipFile), installRoot.toString(), filesToZip);
        writer.safeWrite();
        logger.log(Level.INFO, "Created installation zip {0}", FileUtils.safeGetCanonicalPath((File)glassFishZipFile));
        return glassFishZipFile;
    }

    private static boolean isFileWithinBinDirectory(String file) {
        String parent = null;
        String pFile = new File(file).getParent();
        if (pFile != null) {
            parent = new File(pFile).getName();
        }
        return parent != null && parent.equals("bin");
    }

    public static String toString(InputStream ins) throws IOException {
        int n;
        StringWriter sw = new StringWriter();
        InputStreamReader reader = new InputStreamReader(ins);
        char[] buffer = new char[4096];
        while ((n = reader.read(buffer)) >= 0) {
            sw.write(buffer, 0, n);
        }
        return sw.toString();
    }
}

