/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.DomainDirs;
import com.sun.enterprise.util.io.FileUtils;
import com.trilead.ssh2.SFTPv3DirectoryEntry;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.internal.api.RelativePathResolver;

abstract class NativeRemoteCommandsBase
extends CLICommand {
    @Param(optional=false, primary=true, multiple=true)
    String[] hosts;
    String sshpassword;
    String sshkeypassphrase = null;
    boolean promptPass = false;
    TokenResolver resolver = new TokenResolver();
    private String remoteUser;
    private int remotePort;

    NativeRemoteCommandsBase() {
    }

    abstract String getRawRemoteUser();

    abstract int getRawRemotePort();

    abstract String getSshKeyFile();

    protected void validate() throws CommandException {
        this.remoteUser = this.resolver.resolve(this.getRawRemoteUser());
        this.remotePort = this.getRawRemotePort();
    }

    final String getRemoteUser() {
        return this.remoteUser;
    }

    final int getRemotePort() {
        return this.remotePort;
    }

    final void setRemotePort(int newPort) {
        this.remotePort = newPort;
    }

    String getSSHPassword(String node) throws CommandException {
        return this.getRemotePassword(node, "AS_ADMIN_SSHPASSWORD");
    }

    String getWindowsPassword(String node) throws CommandException {
        return this.getRemotePassword(node, "AS_ADMIN_WINDOWSPASSWORD");
    }

    private String getRemotePassword(String node, String key) throws CommandException {
        String alias;
        String password = this.getFromPasswordFile(key);
        if (password != null && (alias = RelativePathResolver.getAlias((String)password)) != null) {
            password = this.expandPasswordAlias(node, alias, true);
        }
        if (password == null) {
            if (this.programOpts.isInteractive()) {
                char[] pArr = this.readPassword(Strings.get("SSHPasswordPrompt", this.getRemoteUser(), node));
                password = pArr != null ? new String(pArr) : null;
            } else {
                throw new CommandException(Strings.get("SSHPasswordNotFound"));
            }
        }
        return password;
    }

    String getSSHPassphrase(boolean verifyConn) throws CommandException {
        String alias;
        String passphrase = this.getFromPasswordFile("AS_ADMIN_SSHKEYPASSPHRASE");
        if (passphrase != null && (alias = RelativePathResolver.getAlias((String)passphrase)) != null) {
            passphrase = this.expandPasswordAlias(null, alias, verifyConn);
        }
        if (passphrase == null) {
            char[] pArr;
            passphrase = this.programOpts.isInteractive() ? ((pArr = this.readPassword(Strings.get("SSHPassphrasePrompt", this.getSshKeyFile()))) != null ? new String(pArr) : null) : "";
        }
        return passphrase;
    }

    String getMasterPassword(String domain) throws CommandException {
        String masterPass = this.getFromPasswordFile("AS_ADMIN_MASTERPASSWORD");
        if (masterPass == null) {
            char[] mpArr;
            masterPass = this.programOpts.isInteractive() ? ((mpArr = this.readPassword(Strings.get("DomainMasterPasswordPrompt", domain))) != null ? new String(mpArr) : null) : "changeit";
        }
        return masterPass;
    }

    private String getFromPasswordFile(String name) {
        return (String)this.passwords.get(name);
    }

    boolean isValidAnswer(String val) {
        return val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("no") || val.equalsIgnoreCase("y") || val.equalsIgnoreCase("n");
    }

    void deleteRemoteFiles(SFTPClient sftpClient, List<String> dasFiles, String dir, boolean force) throws IOException {
        for (SFTPv3DirectoryEntry directoryEntry : sftpClient.ls(dir)) {
            if (directoryEntry.filename.equals(".") || directoryEntry.filename.equals("..") || directoryEntry.filename.equals("nodes")) continue;
            if (directoryEntry.attributes.isDirectory()) {
                String f1 = dir + "/" + directoryEntry.filename;
                this.deleteRemoteFiles(sftpClient, dasFiles, f1, force);
                if (force) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Force removing directory " + f1);
                    }
                    if (!this.isRemoteDirectoryEmpty(sftpClient, f1)) continue;
                    sftpClient.rmdir(f1);
                    continue;
                }
                if (!dasFiles.contains(f1) || !this.isRemoteDirectoryEmpty(sftpClient, f1)) continue;
                sftpClient.rmdir(f1);
                continue;
            }
            String f2 = dir + "/" + directoryEntry.filename;
            if (force) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Force removing file " + f2);
                }
                sftpClient.rm(f2);
                continue;
            }
            if (!dasFiles.contains(f2)) continue;
            sftpClient.rm(f2);
        }
    }

    boolean isRemoteDirectoryEmpty(SFTPClient sftp, String file) throws IOException {
        Vector l = sftp.ls(file);
        return l.size() <= 2;
    }

    String removeTrailingSlash(String s) {
        if (!StringUtils.ok((String)s)) {
            return s;
        }
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    String expandPasswordAlias(String host, String alias, boolean verifyConn) {
        String expandedPassword;
        block13: {
            expandedPassword = null;
            boolean connStatus = false;
            try {
                File[] files;
                File domainsDirFile = DomainDirs.getDefaultDomainsDir();
                for (File f : files = domainsDirFile.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory();
                    }
                })) {
                    block12: {
                        System.setProperty("com.sun.aas.instanceRoot", f.getAbsolutePath());
                        try {
                            PasswordAdapter pa = new PasswordAdapter(null);
                            boolean exists = pa.aliasExists(alias);
                            if (!exists) break block12;
                            String mPass = this.getMasterPassword(f.getName());
                            expandedPassword = new PasswordAdapter(mPass.toCharArray()).getPasswordForAlias(alias);
                        }
                        catch (Exception e) {
                            if (logger.isLoggable(Level.FINER)) {
                                logger.finer(StringUtils.cat((String)": ", (String[])new String[]{alias, e.getMessage()}));
                            }
                            logger.warning(Strings.get("GetPasswordFailure", f.getName()));
                            continue;
                        }
                    }
                    if (expandedPassword == null) continue;
                    SSHLauncher sshL = new SSHLauncher();
                    if (host != null) {
                        this.sshpassword = expandedPassword;
                        sshL.init(this.getRemoteUser(), host, this.getRemotePort(), this.sshpassword, null, null, logger);
                        connStatus = sshL.checkPasswordAuth();
                        if (!connStatus) {
                            logger.warning(Strings.get("PasswordAuthFailure", f.getName()));
                        }
                    } else {
                        this.sshkeypassphrase = expandedPassword;
                        if (verifyConn) {
                            sshL.init(this.getRemoteUser(), this.hosts[0], this.getRemotePort(), this.sshpassword, this.getSshKeyFile(), this.sshkeypassphrase, logger);
                            connStatus = sshL.checkConnection();
                            if (!connStatus) {
                                logger.warning(Strings.get("PasswordAuthFailure", f.getName()));
                            }
                        }
                    }
                    if (!connStatus) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ioe) {
                if (!logger.isLoggable(Level.FINER)) break block13;
                logger.finer(ioe.getMessage());
            }
        }
        return expandedPassword;
    }

    List<String> getListOfInstallFiles(String installDir) throws IOException {
        String ins = this.resolver.resolve("${com.sun.aas.productRoot}");
        Set files = FileUtils.getAllFilesAndDirectoriesUnder((File)new File(ins));
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Total number of files under {0} = {1}", new Object[]{ins, files.size()});
        }
        Object remoteDir = installDir;
        if (!installDir.endsWith("/")) {
            remoteDir = (String)remoteDir + "/";
        }
        ArrayList<String> modList = new ArrayList<String>();
        for (Object f : files) {
            modList.add((String)remoteDir + FileUtils.makeForwardSlashes((String)((File)f).getPath()));
        }
        return modList;
    }

    void validateKey(String file) throws CommandException {
        File f = new File(file);
        if (!f.exists()) {
            throw new CommandException(Strings.get("KeyDoesNotExist", file));
        }
    }
}

