/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.micro.services.asadmin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.appserver.micro.services.PayaraInstanceImpl;
import fish.payara.micro.data.ApplicationDescriptor;
import fish.payara.micro.data.InstanceDescriptor;
import jakarta.inject.Inject;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-hazelcast-cluster-members")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.hazelcast.cluster.members")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-hazelcast-cluster-members", description="List Hazelcast Cluster Members")})
public class ListHazelcastClusterMembersCommand
implements AdminCommand {
    @Inject
    private PayaraInstanceImpl payaraInstance;
    @Param(name="type", optional=true, acceptableValues="micro,server")
    private String type;

    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        if (this.payaraInstance.isClustered()) {
            Set<InstanceDescriptor> instances = this.payaraInstance.getClusteredPayaras();
            String[] headers = new String[]{"Instance Name", "Instance Group", "Instance Type", "Host Name", "HTTP Ports", "HTTPS Ports", "Admin Port", "Hazelcast Port", "Lite Member", "Deployed Applications", "Last Heartbeat"};
            ColumnFormatter columnFormatter = new ColumnFormatter(headers);
            ArrayList members = new ArrayList();
            Properties extraProps = new Properties();
            for (InstanceDescriptor instance : instances) {
                if (this.type != null && this.type.equals("micro")) {
                    if (!instance.isMicroInstance()) continue;
                    this.populateMembers(members, instance, columnFormatter);
                    continue;
                }
                if (this.type != null && this.type.equals("server")) {
                    if (!instance.isPayaraInstance()) continue;
                    this.populateMembers(members, instance, columnFormatter);
                    continue;
                }
                this.populateMembers(members, instance, columnFormatter);
            }
            extraProps.put("members", members);
            actionReport.setExtraProperties(extraProps);
            actionReport.setMessage(columnFormatter.toString());
            actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        } else {
            Properties extraProps = new Properties();
            extraProps.put("members", "Hazelcast is not enabled");
            actionReport.setExtraProperties(extraProps);
            actionReport.setMessage("Hazelcast is not enabled");
        }
    }

    private void populateMembers(List members, InstanceDescriptor instance, ColumnFormatter columnFormatter) {
        Object[] values = new Object[11];
        values[0] = instance.getInstanceName();
        values[1] = instance.getInstanceGroup();
        values[2] = instance.getInstanceType();
        values[3] = instance.getHostName();
        values[4] = instance.getHttpPorts().isEmpty() ? "Disabled" : instance.getHttpPorts().toString().substring(1, instance.getHttpPorts().toString().length() - 1);
        values[5] = instance.getHttpsPorts().isEmpty() ? "Disabled" : instance.getHttpsPorts().toString().substring(1, instance.getHttpsPorts().toString().length() - 1);
        values[6] = instance.getAdminPort();
        values[7] = instance.getHazelcastPort();
        values[8] = instance.isLiteMember();
        ArrayList<String> applications = new ArrayList<String>();
        Collection applicationDescriptors = instance.getDeployedApplications();
        if (applicationDescriptors != null) {
            for (ApplicationDescriptor application : applicationDescriptors) {
                applications.add(application.getName());
            }
            values[9] = Arrays.toString(applications.toArray()).substring(1, Arrays.toString(applications.toArray()).length() - 1);
        } else {
            values[9] = "";
        }
        LocalDateTime heartBeat = LocalDateTime.ofInstant(Instant.ofEpochMilli(instance.getLastHearbeat()), ZoneId.systemDefault());
        values[10] = heartBeat.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        columnFormatter.addRow(values);
        HashMap<String, Object> map = new HashMap<String, Object>(7);
        map.put("instanceName", values[0]);
        map.put("instanceGroup", values[1]);
        map.put("instanceType", values[2]);
        map.put("hostName", values[3]);
        map.put("httpPorts", values[4]);
        map.put("httpsPorts", values[5]);
        map.put("adminPort", values[6]);
        map.put("hazelcastPort", values[7]);
        map.put("liteMember", values[8]);
        map.put("applications", values[9]);
        map.put("heartbeat", values[10]);
        members.add(map);
    }
}

