/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.appclient.server.core.AppClientDeployerHelper;
import org.glassfish.appclient.server.core.jws.JavaWebStartInfo;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class AppClientServerApplication
implements ApplicationContainer<ApplicationClientDescriptor> {
    @Inject
    private ServiceLocator habitat;
    @Inject
    private ProcessEnvironment processEnv;
    private DeploymentContext dc;
    private Logger logger;
    private AppClientDeployerHelper helper;
    private ApplicationClientDescriptor acDesc;
    private Application appDesc;
    private String deployedAppName;
    private JavaWebStartInfo jwsInfo = null;

    public void init(DeploymentContext dc, AppClientDeployerHelper helper) {
        this.dc = dc;
        this.helper = helper;
        this.logger = Logger.getLogger("javax.enterprise.system.container.appclient", "org.glassfish.appclient.server.LogMessages");
        this.acDesc = helper.appClientDesc();
        this.appDesc = this.acDesc.getApplication();
        this.deployedAppName = ((DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class)).name();
    }

    public String deployedAppName() {
        return this.deployedAppName;
    }

    public ApplicationClientDescriptor getDescriptor() {
        return this.acDesc;
    }

    public AppClientDeployerHelper helper() {
        return this.helper;
    }

    public boolean matches(String appName, String moduleName) {
        return appName.equals(this.deployedAppName) && moduleName != null && (moduleName.equals(this.acDesc.getModuleName()) || this.acDesc.getModuleName().equals(moduleName + ".jar"));
    }

    public boolean start(ApplicationContext startupContext) throws Exception {
        return this.start();
    }

    boolean start() {
        if (this.processEnv.getProcessType().isEmbedded()) {
            return true;
        }
        if (this.jwsInfo == null) {
            this.jwsInfo = this.newJavaWebStartInfo();
        }
        this.jwsInfo.start();
        return true;
    }

    private JavaWebStartInfo newJavaWebStartInfo() {
        JavaWebStartInfo info = (JavaWebStartInfo)this.habitat.getService(JavaWebStartInfo.class, new Annotation[0]);
        info.init(this);
        return info;
    }

    public boolean stop(ApplicationContext stopContext) {
        return this.stop();
    }

    boolean stop() {
        if (this.jwsInfo != null) {
            this.jwsInfo.stop();
        }
        return true;
    }

    public boolean suspend() {
        if (this.jwsInfo != null) {
            this.jwsInfo.suspend();
        }
        return true;
    }

    public boolean resume() throws Exception {
        if (this.jwsInfo != null) {
            this.jwsInfo.resume();
        }
        return true;
    }

    public ClassLoader getClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(new URL[0]);
            }
        });
    }

    public DeploymentContext dc() {
        return this.dc;
    }

    public String registrationName() {
        return this.appDesc.getRegistrationName();
    }

    public String moduleExpression() {
        Object moduleExpression = this.appDesc.isVirtual() ? this.appDesc.getRegistrationName() : this.appDesc.getRegistrationName() + "/" + this.acDesc.getModuleName();
        return moduleExpression;
    }
}

