/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.KeystoreManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import org.glassfish.security.common.FileProtectionUtility;

public class MasterPasswordFileManager
extends KeystoreManager {
    private static final String ENCODED_CHARSET = "UTF-8";
    private static final int SALT_SIZE = 8;
    private static final StringManager STRING_MANAGER = StringManager.getManager(MasterPasswordFileManager.class);

    private char[] getMasterPasswordPassword() throws RepositoryException {
        return "master-password".toCharArray();
    }

    protected void deleteMasterPasswordFile(RepositoryConfig config) {
        PEFileLayout layout = this.getFileLayout(config);
        File pwdFile = layout.getMasterPasswordFile();
        FileUtils.deleteFile((File)pwdFile);
    }

    protected void createMasterPasswordFile(RepositoryConfig config, String masterPassword) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File pwdFile = layout.getMasterPasswordFile();
        try {
            PasswordAdapter p = new PasswordAdapter(pwdFile.getAbsolutePath(), this.getMasterPasswordPassword());
            p.setPasswordForAlias("master-password", masterPassword.getBytes());
            FileProtectionUtility.chmod0600((File)pwdFile);
        }
        catch (Exception ex) {
            throw new RepositoryException(STRING_MANAGER.getString("masterPasswordFileNotCreated", (Object)pwdFile), ex);
        }
    }

    public String readMasterPasswordFile(RepositoryConfig config) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File pwdFile = layout.getMasterPasswordFile();
        if (pwdFile.exists()) {
            try {
                PasswordAdapter p = new PasswordAdapter(pwdFile.getAbsolutePath(), this.getMasterPasswordPassword());
                return p.getPasswordForAlias("master-password");
            }
            catch (Exception ex) {
                throw new RepositoryException(STRING_MANAGER.getString("masterPasswordFileNotRead", (Object)pwdFile), ex);
            }
        }
        return null;
    }

    protected void changeMasterPasswordInMasterPasswordFile(RepositoryConfig config, String newPassword, boolean saveMasterPassword) throws RepositoryException {
        this.deleteMasterPasswordFile(config);
        if (saveMasterPassword) {
            this.createMasterPasswordFile(config, newPassword);
        }
    }

    public void changeMasterPasswordInMasterPasswordFile(File pwdFile, String newPassword, boolean saveMasterPassword) throws RepositoryException {
        FileUtils.deleteFile((File)pwdFile);
        if (saveMasterPassword) {
            try {
                PasswordAdapter p = new PasswordAdapter(pwdFile.getAbsolutePath(), this.getMasterPasswordPassword());
                p.setPasswordForAlias("master-password", newPassword.getBytes());
                FileProtectionUtility.chmod0600((File)pwdFile);
            }
            catch (Exception ex) {
                throw new RepositoryException(STRING_MANAGER.getString("masterPasswordFileNotCreated", (Object)pwdFile), ex);
            }
        }
    }
}

