/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployment.annotation.handlers;

import com.sun.enterprise.deployment.ManagedExecutorDefinitionDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import jakarta.enterprise.concurrent.ManagedExecutorDefinition;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=ManagedExecutorDefinition.class)
public class ManagedExecutorDefinitionHandler
extends AbstractResourceHandler {
    private static final Logger logger = Logger.getLogger(ManagedExecutorDefinitionHandler.class.getName());

    protected HandlerProcessingResult processAnnotation(AnnotationInfo annotationInfo, ResourceContainerContext[] resourceContainerContexts) throws AnnotationProcessorException {
        logger.log(Level.INFO, "Entering ManagedExecutorDefinitionHandler.processAnnotation");
        ManagedExecutorDefinition managedExecutorDefinition = (ManagedExecutorDefinition)annotationInfo.getAnnotation();
        return this.processAnnotation(managedExecutorDefinition, resourceContainerContexts);
    }

    protected HandlerProcessingResult processAnnotation(ManagedExecutorDefinition managedExecutorDefinition, ResourceContainerContext[] contexts) {
        logger.log(Level.INFO, "Registering ManagedExecutorService from annotation config");
        for (ResourceContainerContext context : contexts) {
            ManagedExecutorDefinitionDescriptor medes;
            Set resourceDescriptors = context.getResourceDescriptors(JavaEEResourceType.MEDD);
            if (this.descriptorAlreadyPresent(resourceDescriptors, medes = this.createDescriptor(managedExecutorDefinition))) {
                this.merge(resourceDescriptors, managedExecutorDefinition);
                continue;
            }
            resourceDescriptors.add(medes);
        }
        return this.getDefaultProcessedResult();
    }

    public ManagedExecutorDefinitionDescriptor createDescriptor(ManagedExecutorDefinition managedExecutorDefinition) {
        ManagedExecutorDefinitionDescriptor medd = new ManagedExecutorDefinitionDescriptor();
        medd.setName(TranslatedConfigView.expandValue(managedExecutorDefinition.name()));
        medd.setContext(TranslatedConfigView.expandValue(managedExecutorDefinition.context()));
        if (managedExecutorDefinition.hungTaskThreshold() < 0L) {
            medd.setHungAfterSeconds(0L);
        } else {
            medd.setHungAfterSeconds(managedExecutorDefinition.hungTaskThreshold());
        }
        if (managedExecutorDefinition.maxAsync() < 0) {
            medd.setMaximumPoolSize(Integer.MAX_VALUE);
        } else {
            medd.setMaximumPoolSize(managedExecutorDefinition.maxAsync());
        }
        medd.setMetadataSource(MetadataSource.ANNOTATION);
        return medd;
    }

    private boolean descriptorAlreadyPresent(Set<ResourceDescriptor> resourceDescriptors, ManagedExecutorDefinitionDescriptor medd) {
        Optional<ResourceDescriptor> optResourceDescriptor = resourceDescriptors.stream().filter(d -> d.equals(medd)).findAny();
        return optResourceDescriptor.isPresent();
    }

    private void merge(Set<ResourceDescriptor> resourceDescriptors, ManagedExecutorDefinition med) {
        for (ResourceDescriptor resource : resourceDescriptors) {
            ManagedExecutorDefinitionDescriptor descriptor = (ManagedExecutorDefinitionDescriptor)resource;
            if (!descriptor.getName().equals(med.name())) continue;
            if (descriptor.getHungAfterSeconds() == -1L && med.hungTaskThreshold() != -1L) {
                descriptor.setHungAfterSeconds(med.hungTaskThreshold());
            }
            if (descriptor.getMaximumPoolSize() == -1L && med.maxAsync() != -1) {
                descriptor.setMaximumPoolSize(med.maxAsync());
            }
            if (descriptor.getContext() != null || med.context() == null || med.context().isBlank()) continue;
            descriptor.setContext(TranslatedConfigView.expandValue(med.context()));
        }
    }
}

