/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.source.extension;

import com.sun.enterprise.config.serverbeans.Config;
import fish.payara.nucleus.microprofile.config.source.extension.ConfigSourceExtensions;
import fish.payara.nucleus.microprofile.config.source.extension.ExtensionConfigSourceService;
import fish.payara.nucleus.microprofile.config.spi.ConfigSourceConfiguration;
import fish.payara.nucleus.microprofile.config.spi.MicroprofileConfigConfiguration;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

public abstract class BaseSetConfigSourceConfigurationCommand<C extends ConfigSourceConfiguration>
implements AdminCommand {
    @Inject
    protected Target targetUtil;
    @Inject
    protected ServerEnvironment server;
    @Inject
    private ExtensionConfigSourceService extensionService;
    @Inject
    protected Logger logger;
    @Param(name="target", optional=true, defaultValue="server")
    protected String target;
    @Param(name="dynamic", optional=true, defaultValue="false")
    protected Boolean dynamic;
    @Param(name="enabled")
    protected Boolean enabled;

    public void execute(AdminCommandContext context) {
        final ActionReport report = context.getActionReport();
        Config targetConfig = this.targetUtil.getConfig(this.target);
        if (targetConfig == null) {
            report.setMessage("No such config named: " + this.target);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        Properties extraProperties = report.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            report.setExtraProperties(extraProperties);
        }
        MicroprofileConfigConfiguration mpConfigConfiguration = (MicroprofileConfigConfiguration)targetConfig.getExtensionByType(MicroprofileConfigConfiguration.class);
        final Class configSourceConfigClass = ConfigSourceExtensions.getConfigurationClass(this.getClass());
        Object c = mpConfigConfiguration.getConfigSourceConfigurationByType(configSourceConfigClass);
        try {
            if (c == null) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<MicroprofileConfigConfiguration>(){

                    public Object run(MicroprofileConfigConfiguration configurationProxy) throws PropertyVetoException, TransactionFailure {
                        ConfigSourceConfiguration c = (ConfigSourceConfiguration)configurationProxy.createChild(configSourceConfigClass);
                        BaseSetConfigSourceConfigurationCommand.this.applyValues(report, c);
                        if (report.getActionExitCode() != ActionReport.ExitCode.FAILURE) {
                            configurationProxy.getConfigSourceConfigurationList().add(c);
                        } else {
                            c = null;
                        }
                        return c;
                    }
                }, (ConfigBeanProxy)mpConfigConfiguration);
                c = mpConfigConfiguration.getConfigSourceConfigurationByType(configSourceConfigClass);
            } else {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<C>(){

                    public Object run(C cProxy) throws PropertyVetoException, TransactionFailure {
                        BaseSetConfigSourceConfigurationCommand.this.applyValues(report, cProxy);
                        return cProxy;
                    }
                }, c);
            }
            if (this.dynamic.booleanValue()) {
                if (this.server.isDas()) {
                    if (this.targetUtil.getConfig(this.target).isDas()) {
                        this.configureDynamically(c);
                    }
                } else {
                    this.configureDynamically(c);
                }
            }
        }
        catch (TransactionFailure ex) {
            this.logger.log(Level.WARNING, "Exception during command ", ex);
            report.setMessage(ex.getCause().getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    protected void applyValues(ActionReport report, C configuration) throws PropertyVetoException {
        if (this.enabled != null) {
            configuration.setEnabled(Boolean.toString(this.enabled));
        }
    }

    protected void configureDynamically(C configuration) {
        this.extensionService.reconfigure((ConfigSourceConfiguration)configuration);
    }
}

