/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.executorservice;

import fish.payara.nucleus.executorservice.PayaraExecutorService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Service;

@Service(name="payara-file-watcher")
@RunLevel(value=10)
public class PayaraFileWatcher
implements EventListener {
    private static final Logger LOGGER = Logger.getLogger(PayaraFileWatcher.class.getName());
    private static final Map<Path, Runnable> LISTENER_MAP = new HashMap<Path, Runnable>();
    private static final Set<Path> PATHS_TO_WATCH = new HashSet<Path>();
    private volatile boolean running;
    private WatchService watcher;
    @Inject
    private Events events;
    @Inject
    private PayaraExecutorService executor;

    @PostConstruct
    protected void postConstruct() {
        if (this.events != null) {
            this.events.register((EventListener)this);
        }
        this.initialise();
    }

    @PreDestroy
    protected void preDestroy() {
        if (this.events != null) {
            this.events.unregister((EventListener)this);
        }
        this.terminate();
    }

    public void event(EventListener.Event<?> event) {
        if (event.is(Deployment.ALL_APPLICATIONS_LOADED)) {
            this.initialise();
        } else if (event.is(EventTypes.SERVER_SHUTDOWN)) {
            this.terminate();
        }
    }

    private void run() {
        this.registerQueuedPaths();
        try {
            WatchKey key = this.watcher.take();
            for (WatchEvent<?> event : key.pollEvents()) {
                Path modifiedPath = ((Path)key.watchable()).resolve((Path)event.context());
                Iterator<Map.Entry<Path, Runnable>> watchIterator = LISTENER_MAP.entrySet().iterator();
                while (watchIterator.hasNext()) {
                    Map.Entry<Path, Runnable> watchEntry = watchIterator.next();
                    if (!modifiedPath.endsWith(watchEntry.getKey()) || event.kind() == StandardWatchEventKinds.OVERFLOW) continue;
                    File modifiedFile = modifiedPath.toFile();
                    if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE && !modifiedFile.exists()) {
                        LOGGER.info(String.format("Watched file %s was deleted; removing the file watcher", modifiedPath));
                        watchIterator.remove();
                        continue;
                    }
                    if (event.kind() != StandardWatchEventKinds.ENTRY_MODIFY || modifiedFile.length() <= 0L) continue;
                    LOGGER.fine(String.format("Watched file %s modified, running the listener", modifiedPath));
                    watchEntry.getValue().run();
                }
            }
            key.reset();
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.WARNING, "The file watcher thread was interrupted", ex);
        }
    }

    private void registerQueuedPaths() {
        if (!PATHS_TO_WATCH.isEmpty()) {
            Iterator<Path> pathIterator = PATHS_TO_WATCH.iterator();
            while (pathIterator.hasNext()) {
                Path path = pathIterator.next();
                if (path.toFile().isFile()) {
                    path = path.getParent();
                }
                try {
                    path.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
                    LOGGER.fine(String.format("Watching path: %s", path));
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, String.format("Failed to register path %s with the watch service", path), ex);
                }
                pathIterator.remove();
            }
        }
    }

    private synchronized void initialise() {
        if (!this.running && !PATHS_TO_WATCH.isEmpty()) {
            try {
                this.watcher = FileSystems.getDefault().newWatchService();
                this.executor.scheduleWithFixedDelay(this::run, 0L, 1L, TimeUnit.SECONDS);
                this.running = true;
                LOGGER.info("Initialised the file watcher service");
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Failed to initialise the watch service", ex);
            }
        }
    }

    private synchronized void terminate() {
        if (this.running) {
            try {
                this.watcher.close();
                this.running = false;
                LOGGER.info("Terminated the file watcher service");
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Failed to terminate the watch service", ex);
            }
        }
    }

    public static void watch(Path path, Runnable runnable) {
        PATHS_TO_WATCH.add(path);
        LISTENER_MAP.put(path, runnable);
    }
}

