/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jdbc;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.Resources;
import fish.payara.monitoring.collect.MonitoringData;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.monitoring.collect.MonitoringWatchCollector;
import fish.payara.monitoring.collect.MonitoringWatchSource;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.glassfish.api.jdbc.SQLTraceRecord;
import org.glassfish.api.jdbc.SQLTraceStore;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class SQLTraceStoreImpl
implements SQLTraceStore,
MonitoringDataSource,
MonitoringWatchSource {
    @Inject
    private Domain domain;
    private final Map<String, JdbcConnectionPool> connectionPoolByName = new ConcurrentHashMap<String, JdbcConnectionPool>();
    private final Map<String, Queue<SQLTraceEntry>> uncollectedTracesByPoolName = new ConcurrentHashMap<String, Queue<SQLTraceEntry>>();

    public void trace(SQLTraceRecord record, String sql) {
        JdbcConnectionPool connectionPool = this.getJdbcConnectionPool(record.getPoolName());
        if (connectionPool == null) {
            return;
        }
        long threshold = SQLTraceStoreImpl.thresholdInMillis(connectionPool);
        Queue queue = this.uncollectedTracesByPoolName.computeIfAbsent(record.getPoolName(), key -> new ConcurrentLinkedQueue());
        if (queue.size() >= 50) {
            queue.poll();
        }
        queue.add(new SQLTraceEntry(threshold, record, sql));
    }

    public void collect(MonitoringWatchCollector collector) {
        for (Map.Entry<String, JdbcConnectionPool> poolEntry : this.connectionPoolByName.entrySet()) {
            JdbcConnectionPool pool = poolEntry.getValue();
            if (pool == null) continue;
            String poolName = poolEntry.getKey();
            long thresholdInMillis = SQLTraceStoreImpl.thresholdInMillis(pool);
            if (thresholdInMillis <= 0L) continue;
            collector.watch((CharSequence)("ns:sql @:" + poolName + " MaxExecutionTime"), poolName + " Slow Query", "ms").red(thresholdInMillis, (Number)0, false, null, null, false);
        }
    }

    @MonitoringData(ns="sql")
    public void collect(MonitoringDataCollector collector) {
        long now = System.currentTimeMillis();
        for (Map.Entry<String, Queue<SQLTraceEntry>> poolEntry : this.uncollectedTracesByPoolName.entrySet()) {
            MonitoringDataCollector poolCollector = collector.group((CharSequence)poolEntry.getKey());
            int count = 0;
            long maxExecutionTime = 0L;
            long sumExecutionTime = 0L;
            Queue<SQLTraceEntry> entries = poolEntry.getValue();
            SQLTraceEntry entry = entries.poll();
            while (entry != null) {
                if (now - entry.trace.getTimeStamp() < 5000L) {
                    ++count;
                    long executionTime = entry.trace.getExecutionTime();
                    maxExecutionTime = Math.max(maxExecutionTime, executionTime);
                    sumExecutionTime += executionTime;
                    if (executionTime > entry.thresholdMillis) {
                        poolCollector.annotate((CharSequence)"MaxExecutionTime", executionTime, new String[]{"Threshold", "" + entry.thresholdMillis, "Timestamp", "" + entry.trace.getTimeStamp(), "SQL", entry.sql});
                    }
                }
                entry = entries.poll();
            }
            poolCollector.collect((CharSequence)"MaxExecutionTime", maxExecutionTime).collect((CharSequence)"AvgExecutionTime", (long)count == 0L ? 0L : sumExecutionTime / (long)count);
        }
    }

    private static long thresholdInMillis(JdbcConnectionPool pool) {
        String thresholdInSeconds = pool.getSlowQueryThresholdInSeconds();
        if (thresholdInSeconds == null || thresholdInSeconds.isEmpty()) {
            return -1L;
        }
        return Math.round(Double.parseDouble(pool.getSlowQueryThresholdInSeconds()) * 1000.0);
    }

    private JdbcConnectionPool getJdbcConnectionPool(String poolName) {
        return this.connectionPoolByName.computeIfAbsent(poolName, name -> {
            ResourcePool pool = (ResourcePool)ConnectorsUtil.getResourceByName((Resources)this.domain.getResources(), ResourcePool.class, (String)poolName);
            return pool instanceof JdbcConnectionPool ? (JdbcConnectionPool)pool : null;
        });
    }

    private static final class SQLTraceEntry {
        final long thresholdMillis;
        final SQLTraceRecord trace;
        final String sql;

        SQLTraceEntry(long thresholdMillis, SQLTraceRecord trace, String sql) {
            this.thresholdMillis = thresholdMillis;
            this.trace = trace;
            this.sql = sql;
        }
    }
}

