/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util;

import java.lang.reflect.Constructor;
import java.util.Set;
import org.glassfish.admin.amx.util.SetUtil;

public final class ThrowableMapper {
    final Throwable mOriginal;
    private static final Set<String> OK_PACKAGES = SetUtil.newUnmodifiableStringSet("java.", "javax.", "jakarta.");

    public ThrowableMapper(Throwable t) {
        this.mOriginal = t;
    }

    private static boolean shouldMap(Throwable t) {
        String tClass = t.getClass().getName();
        boolean shouldMap = true;
        for (String prefix : OK_PACKAGES) {
            if (!tClass.startsWith(prefix)) continue;
            shouldMap = false;
            break;
        }
        return shouldMap;
    }

    public static Throwable map(Throwable t) {
        Throwable result = t;
        if (t != null) {
            Throwable tCause = t.getCause();
            Throwable tCauseMapped = ThrowableMapper.map(tCause);
            if (ThrowableMapper.shouldMap(t)) {
                String msg = t.getMessage();
                result = t instanceof Error ? new Error(msg, tCauseMapped) : (t instanceof RuntimeException ? new RuntimeException(msg, tCauseMapped) : (t instanceof Exception ? new Exception(msg, tCauseMapped) : new Throwable(msg, tCauseMapped)));
                result.setStackTrace(t.getStackTrace());
            } else if (tCauseMapped != tCause) {
                try {
                    Constructor<?> constructor = t.getClass().getConstructor(String.class, Throwable.class);
                    result = (Throwable)constructor.newInstance(t.getMessage(), tCauseMapped);
                }
                catch (Throwable t1) {
                    try {
                        Constructor<?> constructor = t.getClass().getConstructor(String.class);
                        result = (Throwable)constructor.newInstance(t.getMessage());
                        result.initCause(tCauseMapped);
                    }
                    catch (Throwable t2) {
                        result = new Throwable(t.getMessage(), tCauseMapped);
                    }
                }
                result.setStackTrace(tCause.getStackTrace());
            } else {
                result = t;
            }
        }
        return result;
    }

    public Throwable map() {
        return ThrowableMapper.map(this.mOriginal);
    }
}

