/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util.jmx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import org.glassfish.admin.amx.util.ClassUtil;
import org.glassfish.admin.amx.util.jmx.MBeanAttributeInfoComparator;
import org.glassfish.admin.amx.util.jmx.MBeanOperationInfoComparator;
import org.glassfish.admin.amx.util.jmx.stringifier.MBeanNotificationInfoStringifier;
import org.glassfish.admin.amx.util.stringifier.SmartStringifier;

public class MBeanInterfaceGenerator {
    boolean mEmitComments = true;
    Map<String, Integer> mCounts = null;
    private static final String INDENT = "    ";
    private static final String NEWLINE = "\n";
    private static final String PARAM_DELIM = ", ";
    public static final String FINAL_PREFIX = "final ";
    public static final int IMPORT_THRESHOLD = 1;
    private static final String BRACKETS = "[]";

    static String stripBrackets(String name) {
        String result = name;
        while (result.endsWith(BRACKETS)) {
            result = result.substring(0, result.length() - BRACKETS.length());
        }
        return result;
    }

    private static void countType(Map<String, Integer> counts, String typeIn) {
        String type = MBeanInterfaceGenerator.stripBrackets(ClassUtil.getFriendlyClassname(typeIn));
        Integer count = counts.get(type);
        if (count == null) {
            count = 1;
        } else {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        counts.put(type, count);
    }

    public static void countTypes(Map<String, Integer> counts, MBeanAttributeInfo[] infos) {
        for (int i = 0; i < infos.length; ++i) {
            MBeanInterfaceGenerator.countType(counts, infos[i].getType());
        }
    }

    private static void countTypes(Map<String, Integer> counts, MBeanOperationInfo[] infos) {
        for (int i = 0; i < infos.length; ++i) {
            MBeanInterfaceGenerator.countType(counts, infos[i].getReturnType());
            MBeanParameterInfo[] params = infos[i].getSignature();
            for (int p = 0; p < params.length; ++p) {
                MBeanInterfaceGenerator.countType(counts, params[p].getType());
            }
        }
    }

    String getCodeClassname(String classnameIn) {
        String name;
        String base = name = ClassUtil.getFriendlyClassname(classnameIn);
        String extra = "";
        int idx = name.indexOf(91);
        if (idx > 0) {
            base = name.substring(0, idx);
            extra = name.substring(idx);
        }
        if (this.typeMayBeAbbreviated(base)) {
            base = ClassUtil.stripPackagePrefix(base);
        }
        return base + extra;
    }

    private Map<String, Integer> countAllTypes(MBeanInfo info) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        MBeanAttributeInfo[] attrInfos = info.getAttributes();
        MBeanOperationInfo[] operationInfos = info.getOperations();
        if (attrInfos != null) {
            MBeanInterfaceGenerator.countTypes(counts, attrInfos);
        }
        if (operationInfos != null) {
            MBeanInterfaceGenerator.countTypes(counts, operationInfos);
        }
        return counts;
    }

    private String getImportBlock(Map<String, Integer> counts) {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, Integer> me : counts.entrySet()) {
            String key = me.getKey();
            Integer count = me.getValue();
            if (count < 1 || this.isUnqualifiedType(key)) continue;
            buf.append("import ").append(key).append(";\n");
        }
        return buf.toString();
    }

    protected boolean isUnqualifiedType(String type) {
        return type.indexOf(46) < 0;
    }

    protected boolean typeMayBeAbbreviated(String type) {
        Integer count = this.mCounts.get(type);
        if (count == null) {
            return false;
        }
        return count >= 1;
    }

    public String generate(MBeanInfo info, boolean emitComments) {
        this.mEmitComments = emitComments;
        StringBuilder buf = new StringBuilder();
        if (this.mEmitComments) {
            buf.append(this.getHeaderComment(info)).append("\n\n");
        }
        buf.append("package ").append(this.getPackageName(info)).append(";\n");
        this.mCounts = this.countAllTypes(info);
        buf.append(NEWLINE).append(this.getImportBlock(this.mCounts)).append(NEWLINE);
        if (this.mEmitComments) {
            buf.append(this.getInterfaceComment(info)).append(NEWLINE);
        }
        String interfaceName = this.getClassname(info);
        buf.append("public interface ").append(interfaceName).append(" \n{\n");
        MBeanAttributeInfo[] attrInfos = info.getAttributes();
        MBeanOperationInfo[] operationInfos = info.getOperations();
        if (attrInfos != null) {
            Arrays.sort(attrInfos, MBeanAttributeInfoComparator.INSTANCE);
            ArrayList<MBeanAttributeInfo> readOnlyAttrInfos = new ArrayList<MBeanAttributeInfo>();
            ArrayList<MBeanAttributeInfo> writebleAttrInfos = new ArrayList<MBeanAttributeInfo>();
            for (MBeanAttributeInfo ai : attrInfos) {
                if (ai.isWritable()) {
                    writebleAttrInfos.add(ai);
                    continue;
                }
                readOnlyAttrInfos.add(ai);
            }
            buf.append(this.generateAttributes(readOnlyAttrInfos));
            buf.append(this.generateAttributes(writebleAttrInfos));
        }
        if (operationInfos != null && operationInfos.length != 0) {
            Arrays.sort(operationInfos, MBeanOperationInfoComparator.INSTANCE);
            buf.append("\n// -------------------- Operations --------------------\n");
            buf.append(this.generateOperations(operationInfos));
        }
        buf.append("\n}");
        return buf.toString();
    }

    protected String indent(String contents, String prefix) {
        StringBuilder buf = new StringBuilder();
        if (contents.length() != 0) {
            String[] lines = contents.split(NEWLINE);
            for (int i = 0; i < lines.length; ++i) {
                buf.append(prefix).append(lines[i]).append(NEWLINE);
            }
            if (buf.length() != 0) {
                buf.setLength(buf.length() - 1);
            }
        }
        return buf.toString();
    }

    protected String indent(String contents) {
        return this.indent(contents, INDENT);
    }

    protected String makeJavadocComment(String contents) {
        if (contents == null || contents.length() == 0) {
            return "";
        }
        return "/**\n" + this.indent(contents) + "\n*/";
    }

    private String padRight(String s, int fieldWidth) {
        StringBuilder buf = new StringBuilder();
        buf.append(s);
        buf.append(" ");
        for (int i = 0; i < fieldWidth - s.length(); ++i) {
            buf.append(" ");
        }
        return buf.toString();
    }

    protected String formMethod(String returnType, String name, String[] params, String[] names) {
        String begin = "public " + this.padRight(this.getCodeClassname(returnType), 16) + " " + name + "(";
        String paramsString = "";
        if (params != null && params.length != 0) {
            StringBuilder buf = new StringBuilder();
            buf.append(" ");
            for (int i = 0; i < params.length; ++i) {
                buf.append(this.getCodeClassname(params[i]));
                buf.append(" ").append(names[i]);
                buf.append(PARAM_DELIM);
            }
            buf.setLength(buf.length() - PARAM_DELIM.length());
            buf.append(" ");
            paramsString = buf.toString();
        }
        return begin + paramsString + ");";
    }

    protected String getAttributeNameComment(String attributeName, String javaName) {
        Object comment = "";
        if (!attributeName.equals(javaName)) {
            comment = attributeName + " => " + javaName;
        }
        return comment;
    }

    protected String attributeNameToJavaName(String attrName) {
        return attrName;
    }

    protected String generateAttributes(List<MBeanAttributeInfo> infos) {
        StringBuilder buf = new StringBuilder();
        String[] typeTemp = new String[1];
        String[] nameTemp = new String[1];
        MBeanAttributeInfo[] infosArray = new MBeanAttributeInfo[infos.size()];
        infos.toArray(infosArray);
        for (MBeanAttributeInfo info : infos) {
            String attributeName = info.getName();
            String type = info.getType();
            String comment = "";
            String javaName = this.attributeNameToJavaName(attributeName);
            if (info.isReadable() && info.isWritable()) {
                buf.append(NEWLINE);
            }
            if (info.isReadable()) {
                if (this.mEmitComments && (comment = this.getGetterComment(info, javaName)).length() != 0) {
                    buf.append(this.indent(comment)).append(NEWLINE);
                }
                buf.append(this.indent(this.formMethod(type, "get" + javaName, null, null)));
                buf.append(NEWLINE);
            }
            if (!info.isWritable()) continue;
            if (this.mEmitComments && (comment = this.getSetterComment(info, javaName)).length() != 0) {
                buf.append(this.indent(comment)).append(NEWLINE);
            }
            typeTemp[0] = type;
            nameTemp[0] = "value";
            buf.append(this.indent(this.formMethod("void", "set" + javaName, typeTemp, nameTemp)));
            buf.append(NEWLINE);
        }
        return buf.toString();
    }

    protected String generateOperations(MBeanOperationInfo[] infos) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < infos.length; ++i) {
            String comment;
            MBeanOperationInfo info = infos[i];
            String name = info.getName();
            String returnType = info.getReturnType();
            MBeanParameterInfo[] paramInfos = info.getSignature();
            String[] paramTypes = new String[paramInfos.length];
            for (int p = 0; p < paramInfos.length; ++p) {
                paramTypes[p] = paramInfos[p].getType();
            }
            String[] paramNames = this.getParamNames(info);
            if (this.mEmitComments && (comment = this.getOperationComment(info, paramNames)).length() != 0) {
                buf.append(NEWLINE).append(this.indent(comment)).append(NEWLINE);
            }
            String method = this.formMethod(returnType, name, paramTypes, paramNames);
            buf.append(this.indent(method)).append(NEWLINE);
        }
        return buf.toString();
    }

    protected boolean isBoilerplateDescription(String description) {
        if (description == null) {
            return true;
        }
        String trimmed = description.trim();
        return trimmed.length() == 0 || trimmed.contains("Attribute exposed for management") || trimmed.contains("Operation exposed for management") || trimmed.contains("No Description was available") || trimmed.equals("n/a");
    }

    public String[] getParamNames(MBeanOperationInfo info) {
        MBeanParameterInfo[] params = info.getSignature();
        String[] names = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            names[i] = params[i].getName();
        }
        return names;
    }

    public String getGetterComment(MBeanAttributeInfo info, String actualName) {
        String description = info.getDescription();
        if (this.isBoilerplateDescription(description)) {
            description = "";
        }
        String nameComment = this.getAttributeNameComment(info.getName(), actualName);
        Object result = description;
        if (description.length() != 0) {
            result = (String)result + NEWLINE;
        }
        result = (String)result + MBeanInterfaceGenerator.toString(info.getDescriptor());
        if (nameComment.length() != 0) {
            result = (String)result + nameComment;
        }
        result = this.makeJavadocComment((String)result);
        return result;
    }

    public String getSetterComment(MBeanAttributeInfo info, String actualName) {
        return "";
    }

    private static String nvp(String name, Object value) {
        return name + " = " + SmartStringifier.DEFAULT.stringify(value);
    }

    public static String toString(Descriptor d) {
        String NL = NEWLINE;
        StringBuilder buf = new StringBuilder();
        if (d != null && d.getFieldNames().length != 0) {
            for (String fieldName : d.getFieldNames()) {
                buf.append(MBeanInterfaceGenerator.nvp(fieldName, d.getFieldValue(fieldName))).append(NEWLINE);
            }
        }
        return buf.toString();
    }

    public String getOperationComment(MBeanOperationInfo info, String[] paramNames) {
        String description = info.getDescription();
        StringBuilder buf = new StringBuilder();
        if (description != null && description.length() != 0) {
            buf.append(description).append(NEWLINE);
        }
        Descriptor desc = info.getDescriptor();
        buf.append(MBeanInterfaceGenerator.toString(desc));
        MBeanParameterInfo[] signature = info.getSignature();
        for (int i = 0; i < paramNames.length; ++i) {
            String paramDescription = signature[i].getDescription();
            buf.append("@param ").append(paramNames[i]).append(" ").append(paramDescription).append(NEWLINE);
        }
        String returnType = this.getCodeClassname(info.getReturnType());
        if (!returnType.equals("void")) {
            buf.append("@return ").append(returnType).append(NEWLINE);
        }
        return this.makeJavadocComment(buf.toString());
    }

    public String getHeaderComment(MBeanInfo info) {
        return this.makeJavadocComment("");
    }

    public String getInterfaceComment(MBeanInfo info) {
        StringBuilder buf = new StringBuilder();
        buf.append("Implementing class: ").append(info.getClassName()).append(NEWLINE);
        buf.append("\nDescriptor: \n");
        buf.append(MBeanInterfaceGenerator.toString(info.getDescriptor()));
        MBeanNotificationInfo[] notifs = info.getNotifications();
        if (notifs != null && notifs.length != 0) {
            buf.append("\nMBeanNotificationInfo: \n");
            for (MBeanNotificationInfo notifInfo : notifs) {
                buf.append(MBeanNotificationInfoStringifier.toString(notifInfo)).append(NEWLINE);
            }
        }
        String comment = buf.toString();
        return this.makeJavadocComment(comment);
    }

    public String getPackageName(MBeanInfo info) {
        return "mbeans.generated";
    }

    public String getClassname(MBeanInfo info) {
        String name = info.getClassName();
        name = name.replace(".", "_");
        name = name.replace("$", "_");
        return name + "_Proxy";
    }

    public String getExceptions(MBeanOperationInfo info) {
        return "";
    }
}

