/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.stuck;

import fish.payara.internal.notification.EventLevel;
import fish.payara.monitoring.collect.MonitoringData;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.monitoring.collect.MonitoringWatchCollector;
import fish.payara.monitoring.collect.MonitoringWatchSource;
import fish.payara.notification.healthcheck.HealthCheckResultEntry;
import fish.payara.notification.healthcheck.HealthCheckResultStatus;
import fish.payara.nucleus.healthcheck.HealthCheckResult;
import fish.payara.nucleus.healthcheck.HealthCheckStatsProvider;
import fish.payara.nucleus.healthcheck.HealthCheckStuckThreadExecutionOptions;
import fish.payara.nucleus.healthcheck.configuration.StuckThreadsChecker;
import fish.payara.nucleus.healthcheck.preliminary.BaseHealthCheck;
import fish.payara.nucleus.healthcheck.stuck.StuckThreadsStore;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="healthcheck-stuck")
@RunLevel(value=10)
public class StuckThreadsHealthCheck
extends BaseHealthCheck<HealthCheckStuckThreadExecutionOptions, StuckThreadsChecker>
implements MonitoringDataSource,
MonitoringWatchSource,
HealthCheckStatsProvider {
    private final Map<String, Number> stuckThreadResult = new ConcurrentHashMap<String, Number>();
    private static final String STUCK_THREAD_COUNT = "count";
    private static final String STUCK_THREAD_MAX_DURATION = "maxDuration";
    private static final Set<String> VALID_SUB_ATTRIBUTES = Set.of("count", "maxDuration");
    @Inject
    private StuckThreadsStore stuckThreadsStore;
    @Inject
    private StuckThreadsChecker checker;

    @PostConstruct
    void postConstruct() {
        this.postConstruct(this, StuckThreadsChecker.class);
    }

    public Object getValue(Class type, String attributeName, String subAttributeName) {
        if (subAttributeName == null) {
            throw new IllegalArgumentException("sub-attribute name is required");
        }
        if (!VALID_SUB_ATTRIBUTES.contains(subAttributeName)) {
            throw new IllegalArgumentException("Invalid sub-attribute name, supported sub-attributes are " + VALID_SUB_ATTRIBUTES);
        }
        if (!Number.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("sub-attribute type must be number");
        }
        return this.stuckThreadResult.getOrDefault(subAttributeName, 0);
    }

    @Override
    public Set<String> getAttributes() {
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<String> getSubAttributes() {
        return VALID_SUB_ATTRIBUTES;
    }

    @Override
    public boolean isEnabled() {
        return this.getOptions() != null ? ((HealthCheckStuckThreadExecutionOptions)this.getOptions()).isEnabled() : false;
    }

    @Override
    protected HealthCheckResult doCheckInternal() {
        HealthCheckResult result = new HealthCheckResult();
        this.acceptStuckThreads((workStartedTime, timeWorkingInMillis, thresholdInMillis, info) -> result.add(new HealthCheckResultEntry(HealthCheckResultStatus.WARNING, "Stuck Thread: " + info.toString())));
        return result;
    }

    @Override
    protected EventLevel createNotificationEventLevel(HealthCheckResultStatus checkResult) {
        if (checkResult == HealthCheckResultStatus.FINE) {
            return EventLevel.INFO;
        }
        return EventLevel.WARNING;
    }

    @MonitoringData(ns="health", intervalSeconds=4)
    public void collect(MonitoringDataCollector collector) {
        if (this.options == null || !((HealthCheckStuckThreadExecutionOptions)this.options).isEnabled()) {
            return;
        }
        AtomicInteger count = new AtomicInteger(0);
        AtomicLong maxDuration = new AtomicLong(0L);
        this.acceptStuckThreads((workStartedTime, timeWorkingInMillis, thresholdInMillis, info) -> {
            String thread = info.getThreadName();
            if (thread == null || thread.isEmpty()) {
                thread = String.valueOf(info.getThreadId());
            }
            collector.annotate((CharSequence)"StuckThreadDuration", timeWorkingInMillis, true, new String[]{"Thread", thread, "Started", String.valueOf(workStartedTime), "Threshold", String.valueOf(thresholdInMillis), "Locked", Boolean.toString(info.getLockInfo() != null), "Suspended", String.valueOf(info.isSuspended()), "State", StuckThreadsHealthCheck.composeStateText(info)});
            count.incrementAndGet();
            maxDuration.updateAndGet(value -> Math.max(value, timeWorkingInMillis));
        });
        collector.collect((CharSequence)"StuckThreadDuration", (Number)maxDuration);
        collector.collect((CharSequence)"StuckThreadCount", (Number)count);
        this.stuckThreadResult.put(STUCK_THREAD_MAX_DURATION, maxDuration.get());
        this.stuckThreadResult.put(STUCK_THREAD_COUNT, count.get());
    }

    public void collect(MonitoringWatchCollector collector) {
        if (this.options == null || !((HealthCheckStuckThreadExecutionOptions)this.options).isEnabled()) {
            return;
        }
        long thresholdInMillis = this.getThresholdInMillis();
        collector.watch((CharSequence)"ns:health StuckThreadDuration", "Stuck Threads", "ms").red(thresholdInMillis, (Number)-30000L, false, null, null, false).green(-thresholdInMillis, (Number)1, false, null, null, false);
    }

    private static String composeStateText(ThreadInfo info) {
        if (info.getLockInfo() == null) {
            return "Running";
        }
        Thread.State state = info.getThreadState();
        return StuckThreadsHealthCheck.composeActionText(state) + info.getLockInfo().toString();
    }

    private static String composeActionText(Thread.State state) {
        switch (state) {
            case BLOCKED: {
                return "Blocked on ";
            }
            case WAITING: 
            case TIMED_WAITING: {
                return "Waiting on ";
            }
        }
        return "Running ";
    }

    private void acceptStuckThreads(StuckThreadConsumer consumer) {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        long thresholdInMillis = this.getThresholdInMillis();
        long now = System.currentTimeMillis();
        ConcurrentHashMap<Long, Long> threads = this.stuckThreadsStore.getThreads();
        String[] blacklist = this.checker.getBlacklistPatterns().split(",");
        for (Map.Entry<Long, Long> thread : threads.entrySet()) {
            ThreadInfo info;
            Long threadId = thread.getKey();
            long workStartedTime = thread.getValue();
            long timeWorkingInMillis = now - workStartedTime;
            if (timeWorkingInMillis <= thresholdInMillis || (info = bean.getThreadInfo(threadId, Integer.MAX_VALUE)) == null || this.isInBlacklist(info.getThreadName(), blacklist)) continue;
            consumer.accept(workStartedTime, timeWorkingInMillis, thresholdInMillis, info);
        }
    }

    private boolean isInBlacklist(String threadName, String[] blacklistPatterns) {
        return Arrays.stream(blacklistPatterns).anyMatch(threadName::matches);
    }

    private long getThresholdInMillis() {
        return Math.max(1L, TimeUnit.MILLISECONDS.convert(((HealthCheckStuckThreadExecutionOptions)this.options).getTimeStuck(), ((HealthCheckStuckThreadExecutionOptions)this.options).getUnitStuck()));
    }

    @Override
    public HealthCheckStuckThreadExecutionOptions constructOptions(StuckThreadsChecker checker) {
        return new HealthCheckStuckThreadExecutionOptions(Boolean.valueOf(checker.getEnabled()), Long.parseLong(checker.getTime()), this.asTimeUnit(checker.getUnit()), Boolean.valueOf(checker.getAddToMicroProfileHealth()), Long.parseLong(checker.getThreshold()), this.asTimeUnit(checker.getThresholdTimeUnit()), checker.getBlacklistPatterns());
    }

    @Override
    protected String getDescription() {
        return "healthcheck.description.stuckThreads";
    }

    @FunctionalInterface
    private static interface StuckThreadConsumer {
        public void accept(long var1, long var3, long var5, ThreadInfo var7);
    }
}

