/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.healthcheck.mphealth;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import fish.payara.appserver.micro.services.PayaraInstanceImpl;
import fish.payara.healthcheck.mphealth.HealthCheckTimeoutExecutionOptions;
import fish.payara.internal.notification.EventLevel;
import fish.payara.micro.ClusterCommandResult;
import fish.payara.micro.data.InstanceDescriptor;
import fish.payara.microprofile.healthcheck.config.MicroprofileHealthCheckConfiguration;
import fish.payara.monitoring.collect.MonitoringData;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.monitoring.collect.MonitoringWatchCollector;
import fish.payara.monitoring.collect.MonitoringWatchSource;
import fish.payara.notification.healthcheck.HealthCheckResultEntry;
import fish.payara.notification.healthcheck.HealthCheckResultStatus;
import fish.payara.nucleus.executorservice.PayaraExecutorService;
import fish.payara.nucleus.healthcheck.HealthCheckResult;
import fish.payara.nucleus.healthcheck.configuration.MicroProfileHealthCheckerConfiguration;
import fish.payara.nucleus.healthcheck.preliminary.BaseHealthCheck;
import jakarta.inject.Inject;
import jakarta.validation.constraints.Pattern;
import jakarta.ws.rs.ProcessingException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.PropertyResolver;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="healthcheck-mp")
@RunLevel(value=10)
public class MicroProfileHealthChecker
extends BaseHealthCheck<HealthCheckTimeoutExecutionOptions, MicroProfileHealthCheckerConfiguration>
implements PostConstruct,
MonitoringDataSource,
MonitoringWatchSource {
    private static final Logger LOGGER = Logger.getLogger(MicroProfileHealthChecker.class.getPackage().getName());
    private static final String UNABLE_TO_CONNECT = "UNABLE TO CONNECT - ";
    private static final String GET_MP_CONFIG_STRING = "get-microprofile-healthcheck-configuration";
    @Inject
    private PayaraExecutorService payaraExecutorService;
    @Inject
    GrizzlyService grizzlyService;
    @Inject
    Domain domain;
    @Inject
    ServerEnvironment envrionment;
    @Inject
    private PayaraInstanceImpl payaraMicro;
    private volatile Map<String, Future<Integer>> priorCollectionTasks;

    public void postConstruct() {
        this.postConstruct(this, MicroProfileHealthCheckerConfiguration.class);
    }

    protected HealthCheckResult doCheckInternal() {
        HealthCheckResult result = new HealthCheckResult();
        if (!this.envrionment.isDas()) {
            return result;
        }
        long timeoutMillis = ((HealthCheckTimeoutExecutionOptions)this.options).getTimeout();
        for (Future<Integer> task : this.pingAllInstances(timeoutMillis).values()) {
            try {
                int statusCode = task.get(timeoutMillis, TimeUnit.MILLISECONDS);
                if (statusCode < 0) continue;
                result.add(MicroProfileHealthChecker.entryFromHttpStatusCode(statusCode));
            }
            catch (InterruptedException | TimeoutException ex) {
                LOGGER.log(Level.FINE, "Error processing MP Healthcheck checker", ex);
                result.add(new HealthCheckResultEntry(HealthCheckResultStatus.CRITICAL, UNABLE_TO_CONNECT + ex.toString()));
                if (!(ex instanceof InterruptedException)) continue;
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof URISyntaxException) {
                    result.add(new HealthCheckResultEntry(HealthCheckResultStatus.CHECK_ERROR, "INVALID ENDPOINT: " + ((URISyntaxException)cause).getInput()));
                    continue;
                }
                if (cause instanceof ProcessingException) {
                    LOGGER.log(Level.FINE, "Error sending JAX-RS Request", cause);
                    result.add(new HealthCheckResultEntry(HealthCheckResultStatus.CRITICAL, UNABLE_TO_CONNECT + cause.getMessage()));
                    continue;
                }
                LOGGER.log(Level.FINE, "Error processing MP Healthcheck checker", cause);
                result.add(new HealthCheckResultEntry(HealthCheckResultStatus.CRITICAL, UNABLE_TO_CONNECT + cause.toString()));
            }
        }
        return result;
    }

    protected EventLevel createNotificationEventLevel(HealthCheckResultStatus checkResult) {
        if (checkResult == HealthCheckResultStatus.FINE || checkResult == HealthCheckResultStatus.GOOD) {
            return EventLevel.INFO;
        }
        return EventLevel.WARNING;
    }

    public void collect(MonitoringWatchCollector collector) {
        if (!this.envrionment.isDas() || this.options == null || !((HealthCheckTimeoutExecutionOptions)this.options).isEnabled()) {
            return;
        }
        collector.watch((CharSequence)"ns:health LivelinessUp", "Liveliness UP", "percent").red(-60L, null, false, null, null, false).amber(-100L, null, false, null, null, false).green(100L, null, false, null, null, false);
    }

    @MonitoringData(ns="health", intervalSeconds=12)
    public void collect(MonitoringDataCollector collector) {
        if (!this.envrionment.isDas() || this.options == null || !((HealthCheckTimeoutExecutionOptions)this.options).isEnabled()) {
            return;
        }
        Map<String, Future<Integer>> instances = this.priorCollectionTasks;
        if (instances != null) {
            int upCount = 0;
            for (Map.Entry<String, Future<Integer>> instance : instances.entrySet()) {
                try {
                    int statusCode = instance.getValue().get(10L, TimeUnit.MILLISECONDS);
                    if (statusCode != 200) continue;
                    ++upCount;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Failed to ping " + instance.getKey(), ex);
                }
            }
            collector.collect((CharSequence)"LivelinessUp", (long)(100 * upCount / instances.size()));
        }
        this.priorCollectionTasks = this.pingAllInstances(10000L);
    }

    private Map<String, Future<Integer>> pingAllInstances(long timeoutMillis) {
        String instanceName;
        ConcurrentHashMap<String, Future<Integer>> tasks = new ConcurrentHashMap<String, Future<Integer>>();
        Map configs = this.payaraMicro.executeClusteredASAdmin(GET_MP_CONFIG_STRING, new String[0]);
        for (Server server : this.domain.getServers().getServer()) {
            instanceName = server.getName();
            tasks.put(instanceName, this.payaraExecutorService.submit(() -> {
                MicroprofileHealthCheckConfiguration healthCheckConfig = (MicroprofileHealthCheckConfiguration)server.getConfig().getExtensionByType(MicroprofileHealthCheckConfiguration.class);
                if (healthCheckConfig != null && Boolean.valueOf(healthCheckConfig.getEnabled()).booleanValue()) {
                    return MicroProfileHealthChecker.pingHealthEndpoint(this.buildURI(server, healthCheckConfig.getEndpoint()));
                }
                return -1;
            }));
        }
        for (InstanceDescriptor instance : this.payaraMicro.getClusteredPayaras()) {
            instanceName = instance.getInstanceName();
            if (tasks.containsKey(instanceName)) continue;
            tasks.put(instanceName, this.payaraExecutorService.submit(() -> {
                ClusterCommandResult mpHealthConfigResult = (ClusterCommandResult)((Future)configs.get(instance.getMemberUUID())).get(timeoutMillis, TimeUnit.MILLISECONDS);
                String values = mpHealthConfigResult.getOutput().split("\n")[1];
                Boolean enabled = Boolean.parseBoolean(values.split(" ")[0]);
                if (enabled.booleanValue()) {
                    @Pattern(regexp="[A-Za-z0-9_][A-Za-z0-9\\-_\\.;]*", message="{server.invalid.name}", payload={Server.class}) String endpoint = values.split(" ", 2)[1].trim();
                    return MicroProfileHealthChecker.pingHealthEndpoint(MicroProfileHealthChecker.buildURI(instance, endpoint));
                }
                return -1;
            }));
        }
        return tasks;
    }

    public HealthCheckTimeoutExecutionOptions constructOptions(MicroProfileHealthCheckerConfiguration c) {
        return new HealthCheckTimeoutExecutionOptions(Boolean.valueOf(c.getEnabled()), Long.parseLong(c.getTime()), this.asTimeUnit(c.getUnit()), Boolean.valueOf(c.getAddToMicroProfileHealth()), Long.parseLong(c.getTimeout()));
    }

    protected String getDescription() {
        return "healthcheck.description.MPhealthcheck";
    }

    private static URI buildURI(InstanceDescriptor instance, String endpoint) throws URISyntaxException {
        URL usedURL = (URL)instance.getApplicationURLS().get(0);
        return new URI(usedURL.getProtocol(), usedURL.getUserInfo(), usedURL.getHost(), usedURL.getPort(), "/" + endpoint, null, null);
    }

    private URI buildURI(Server server, String endpoint) throws URISyntaxException {
        NetworkListener listener = (NetworkListener)server.getConfig().getNetworkConfig().getNetworkListeners().getNetworkListener().get(0);
        String protocol = Boolean.parseBoolean(listener.findHttpProtocol().getSecurityEnabled()) ? "https" : "http";
        String basePort = listener.getPort();
        Integer truePort = 8080;
        try {
            truePort = Integer.parseInt(basePort);
        }
        catch (NumberFormatException e) {
            PropertyResolver configProps = new PropertyResolver(this.domain, server.getName());
            String sysPropsPort = configProps.getPropertyValue(basePort);
            truePort = Integer.parseInt(sysPropsPort);
        }
        return new URI(protocol, null, TranslatedConfigView.expandValue((String)listener.getAddress()), truePort, "/" + endpoint, null, null);
    }

    private static int pingHealthEndpoint(URI remote) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)remote.toURL().openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "application/json");
        int statusCode = conn.getResponseCode();
        conn.disconnect();
        return statusCode;
    }

    private static HealthCheckResultEntry entryFromHttpStatusCode(int statusCode) {
        switch (statusCode) {
            case 200: {
                return new HealthCheckResultEntry(HealthCheckResultStatus.GOOD, "UP");
            }
            case 503: {
                return new HealthCheckResultEntry(HealthCheckResultStatus.WARNING, "DOWN");
            }
            case 500: {
                return new HealthCheckResultEntry(HealthCheckResultStatus.CRITICAL, "FAILURE");
            }
        }
        return new HealthCheckResultEntry(HealthCheckResultStatus.CHECK_ERROR, "UNKNOWN RESPONSE");
    }
}

