/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction;

import com.sun.enterprise.transaction.JavaEETransactionImpl;
import com.sun.enterprise.util.i18n.StringManager;
import jakarta.inject.Inject;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractsProvided(value={TransactionSynchronizationRegistryImpl.class, TransactionSynchronizationRegistry.class})
public class TransactionSynchronizationRegistryImpl
implements TransactionSynchronizationRegistry {
    @Inject
    private transient TransactionManager transactionManager;
    private static StringManager sm = StringManager.getManager(TransactionSynchronizationRegistryImpl.class);

    public TransactionSynchronizationRegistryImpl() {
    }

    public TransactionSynchronizationRegistryImpl(TransactionManager t) {
        this.transactionManager = t;
    }

    public Object getTransactionKey() {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException ex) {
            return null;
        }
    }

    public void putResource(Object key, Object value) {
        try {
            JavaEETransactionImpl tran = (JavaEETransactionImpl)this.transactionManager.getTransaction();
            if (tran == null) {
                throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
            }
            tran.putUserResource(key, value);
        }
        catch (SystemException ex) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
    }

    public Object getResource(Object key) {
        try {
            JavaEETransactionImpl tran = (JavaEETransactionImpl)this.transactionManager.getTransaction();
            if (tran == null) {
                throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
            }
            return tran.getUserResource(key);
        }
        catch (SystemException ex) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
    }

    public void registerInterposedSynchronization(Synchronization sync) {
        try {
            JavaEETransactionImpl tran = (JavaEETransactionImpl)this.transactionManager.getTransaction();
            if (tran == null) {
                throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
            }
            tran.registerInterposedSynchronization(sync);
        }
        catch (SystemException ex) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
        catch (RollbackException ex) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.mark_rollback"));
        }
    }

    public int getTransactionStatus() {
        try {
            return this.transactionManager.getStatus();
        }
        catch (SystemException ex) {
            return 6;
        }
    }

    public void setRollbackOnly() {
        try {
            this.transactionManager.setRollbackOnly();
        }
        catch (SystemException ex) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
    }

    public boolean getRollbackOnly() {
        int status = this.getTransactionStatus();
        if (status == 6) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
        return status == 1 || status == 9;
    }
}

