/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.commands;

import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.commands.StringBuilderNewLineAppender;
import jakarta.inject.Inject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="generate-heap-dump")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="generate.heap.dump")
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.DEPLOYMENT_GROUP})
@ExecuteOn(value={RuntimeType.INSTANCE}, ifNeverStarted=FailurePolicy.Error)
@AccessRequired(resource={"domain/jvm"}, action={"read"})
public class GenerateHeapDumpCommand
implements AdminCommand {
    private static final Logger LOGGER = Logger.getLogger(GenerateHeapDumpCommand.class.getName());
    @Param(name="target", optional=true)
    private String target;
    @Param(name="outputDir")
    private String outputDir;
    @Param(name="outputFileName", optional=true)
    private String outputFileName;
    @Inject
    private ServerEnvironment serverEnv;

    @Override
    public void execute(AdminCommandContext ctx) {
        ActionReport report = ctx.getActionReport();
        if (!StringUtils.ok((String)this.outputDir)) {
            report.setMessage("Invalid Output Directory");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        StringBuilderNewLineAppender stringBuilderNewLineAppender = new StringBuilderNewLineAppender(new StringBuilder());
        if (!StringUtils.ok((String)this.outputFileName)) {
            String prefix = this.serverEnv.isInstance() ? this.serverEnv.getInstanceName() : "server";
            this.outputFileName = prefix + "-heap-dump-" + DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH-mm-ssX").withZone(ZoneOffset.UTC).format(Instant.now());
        }
        try {
            HashMap<Object, Object> systemPropsMap = new HashMap<Object, Object>(System.getProperties());
            TokenResolver resolver = new TokenResolver(systemPropsMap);
            Object resolvedOutput = resolver.resolve(this.outputDir);
            resolvedOutput = ((String)resolvedOutput).replace('/', File.separatorChar).replace('\\', File.separatorChar);
            if (!((String)resolvedOutput).endsWith(File.separator)) {
                resolvedOutput = (String)resolvedOutput + File.separatorChar;
            }
            stringBuilderNewLineAppender.append("Resolved the following output directory: " + (String)resolvedOutput);
            Path outputDirPath = Paths.get((String)resolvedOutput, new String[0]);
            if (!Files.exists(outputDirPath, new LinkOption[0])) {
                report.setMessage("Output directory does not exist!");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            int pid = ProcessUtils.getPid();
            LOGGER.log(Level.FINE, "Process ID is " + pid);
            Runtime runtime = Runtime.getRuntime();
            String command = String.format("jcmd %s GC.heap_dump %s%s.hprof", pid, resolvedOutput, this.outputFileName);
            LOGGER.log(Level.FINE, "Executing the following command: " + command);
            Process process = runtime.exec(command);
            stringBuilderNewLineAppender.append("Generating Heap Dump");
            boolean success = true;
            try (BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                process.waitFor();
                while ((line = input.readLine()) != null) {
                    if (line.contains("File exists")) {
                        stringBuilderNewLineAppender.append("File already exists");
                        success = false;
                    }
                    if (line.contains("No such file or directory")) {
                        success = false;
                        stringBuilderNewLineAppender.append("Directory does not exist! " + (String)resolvedOutput);
                    }
                    LOGGER.log(Level.FINE, line);
                }
            }
            if (success) {
                stringBuilderNewLineAppender.append("File name is " + this.outputFileName);
                stringBuilderNewLineAppender.append("Heap Dump has been created");
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            } else {
                stringBuilderNewLineAppender.append("Heap Dump could not be created!");
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            report.setMessage(stringBuilderNewLineAppender.toString());
        }
        catch (IOException | InterruptedException e) {
            report.setMessage("Could not generate the heap dump");
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }
}

