/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ejb.opentracing;

import fish.payara.ejb.opentracing.OpenTracingIiopObjectInputStream;
import fish.payara.ejb.opentracing.OpenTracingIiopTextMap;
import fish.payara.opentracing.OpenTracingService;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.logging.Logger;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class OpenTracingIiopServerInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private static final Logger LOGGER = Logger.getLogger(OpenTracingIiopServerInterceptor.class.getName());
    private OpenTracingService openTracingService;
    private Tracer tracer;
    private ThreadLocal<Scope> currentScope = new ThreadLocal();
    private ThreadLocal<Span> currentSpan = new ThreadLocal();

    public OpenTracingIiopServerInterceptor(OpenTracingService openTracingService) {
        this.openTracingService = openTracingService;
        if (openTracingService.isEnabled()) {
            this.tracer = openTracingService.getTracer("__PAYARA_CORBA_RMI");
        }
    }

    public void receive_request_service_contexts(ServerRequestInfo ri) throws ForwardRequest {
    }

    public void receive_request(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        Scope previousScope;
        if (!this.tracerAvailable()) {
            return;
        }
        ServiceContext serviceContext = serverRequestInfo.get_request_service_context(3226428);
        if (serviceContext == null) {
            return;
        }
        OpenTracingIiopTextMap openTracingIiopTextMap = null;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(serviceContext.context_data);
             OpenTracingIiopObjectInputStream in = new OpenTracingIiopObjectInputStream(bis);){
            openTracingIiopTextMap = (OpenTracingIiopTextMap)in.readObject();
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new ForwardRequest(exception.getMessage(), (Object)serverRequestInfo);
        }
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan("rmi").withTag(Tags.COMPONENT.getKey(), "ejb");
        if (openTracingIiopTextMap != null) {
            SpanContext spanContext = this.tracer.extract(Format.Builtin.TEXT_MAP, (java.lang.Object)openTracingIiopTextMap);
            spanBuilder.asChildOf(spanContext);
        }
        if ((previousScope = this.currentScope.get()) != null) {
            LOGGER.warning("Overlapping traced RMI operations identified, please report");
        }
        Span currentSpan = spanBuilder.start();
        this.currentScope.set(this.tracer.activateSpan(currentSpan));
        this.currentSpan.set(currentSpan);
    }

    public void send_reply(ServerRequestInfo serverRequestInfo) {
        this.closeScope();
    }

    public void send_exception(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        this.closeScope();
    }

    public void send_other(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        this.closeScope();
    }

    private void closeScope() {
        Span activeSpan;
        if (this.tracer == null) {
            return;
        }
        Scope scope = this.currentScope.get();
        if (scope != null) {
            scope.close();
            this.currentScope.remove();
        }
        if ((activeSpan = this.currentSpan.get()) != null) {
            activeSpan.finish();
            this.currentSpan.remove();
        }
    }

    private boolean tracerAvailable() {
        if (this.tracer == null) {
            if (!this.openTracingService.isEnabled()) {
                return false;
            }
            this.tracer = this.openTracingService.getTracer("__PAYARA_CORBA_RMI");
            if (this.tracer == null) {
                return false;
            }
        }
        return true;
    }

    public String name() {
        return ((java.lang.Object)((java.lang.Object)this)).getClass().getSimpleName();
    }

    public void destroy() {
    }
}

