/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JMSDestinationDefinitionDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbBundleContext;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import com.sun.enterprise.deployment.annotation.context.EjbInterceptorContext;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.context.WebBundleContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentContext;
import com.sun.enterprise.deployment.annotation.context.WebComponentsContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.AroundTimeout;
import jakarta.interceptor.Interceptors;
import jakarta.jms.JMSDestinationDefinition;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=JMSDestinationDefinition.class)
public class JMSDestinationDefinitionHandler
extends AbstractResourceHandler {
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        JMSDestinationDefinition jmsDestinationDefnAn = (JMSDestinationDefinition)ainfo.getAnnotation();
        return this.processAnnotation(jmsDestinationDefnAn, ainfo, rcContexts);
    }

    protected HandlerProcessingResult processAnnotation(JMSDestinationDefinition jmsDestinationDefnAn, AnnotationInfo aiInfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        Class annotatedClass = (Class)aiInfo.getAnnotatedElement();
        Annotation[] annotations = annotatedClass.getAnnotations();
        boolean warClass = this.isAWebComponentClass(annotations);
        boolean ejbClass = this.isAEjbComponentClass(annotations);
        for (ResourceContainerContext context : rcContexts) {
            JMSDestinationDefinitionDescriptor desc;
            if (!this.canProcessAnnotation(annotatedClass, ejbClass, warClass, context)) {
                return this.getDefaultProcessedResult();
            }
            Set jmsddDescs = context.getResourceDescriptors(JavaEEResourceType.JMSDD);
            if (this.isDefinitionAlreadyPresent(jmsddDescs, desc = this.createDescriptor(jmsDestinationDefnAn))) {
                this.merge(jmsddDescs, jmsDestinationDefnAn);
                continue;
            }
            context.addResourceDescriptor((ResourceDescriptor)desc);
        }
        return this.getDefaultProcessedResult();
    }

    private boolean canProcessAnnotation(Class<?> annotatedClass, boolean ejbClass, boolean warClass, ResourceContainerContext context) {
        if (ejbClass) {
            if (!(context instanceof EjbBundleContext || context instanceof EjbContext || context instanceof EjbInterceptorContext)) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.log(Level.FINEST, "Ignoring @JMSDestinationDefinition annotation processing as the class is an EJB class and context is not one of EJBContext");
                }
                return false;
            }
        } else if (context instanceof EjbBundleContext) {
            EjbBundleContext ejbContext = (EjbBundleContext)context;
            EjbBundleDescriptor ejbBundleDescriptor = ejbContext.getDescriptor();
            EjbDescriptor[] ejbDescriptor = ejbBundleDescriptor.getEjbByClassName(annotatedClass.getName());
            if (ejbDescriptor == null || ejbDescriptor.length == 0) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.log(Level.FINEST, "Ignoring @JMSDestinationDefinition annotation processing as the class [ " + annotatedClass + " ] is not an EJB class and the context is EJBContext");
                }
                return false;
            }
        } else if (warClass) {
            if (!(context instanceof WebBundleContext || context instanceof WebComponentsContext || context instanceof WebComponentContext)) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.log(Level.FINEST, "Ignoring @JMSDestinationDefinition annotation processing as the class is an Web class and context is not one of WebContext");
                }
                return false;
            }
        } else if (context instanceof WebBundleContext) {
            WebBundleContext webBundleContext = (WebBundleContext)context;
            WebBundleDescriptor webBundleDescriptor = webBundleContext.getDescriptor();
            Collection extDesc = webBundleDescriptor.getExtensionsDescriptors();
            for (RootDeploymentDescriptor desc : extDesc) {
                Method[] methods;
                if (!(desc instanceof EjbBundleDescriptor)) continue;
                EjbBundleDescriptor ejbBundleDesc = (EjbBundleDescriptor)desc;
                EjbDescriptor[] ejbDescs = ejbBundleDesc.getEjbByClassName(annotatedClass.getName());
                if (ejbDescs != null && ejbDescs.length > 0) {
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.log(Level.FINEST, "Ignoring @JMSDestinationDefinition annotation processing as the class [ " + annotatedClass + " ] is not an Web class and the context is WebContext");
                    }
                    return false;
                }
                if (ejbBundleDesc.getInterceptorByClassName(annotatedClass.getName()) != null) {
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.log(Level.FINEST, "Ignoring @JMSDestinationDefinition annotation processing as the class [ " + annotatedClass + " ] is not an Web class and the context is WebContext");
                    }
                    return false;
                }
                for (Method method : methods = annotatedClass.getDeclaredMethods()) {
                    Annotation[] annotations;
                    for (Annotation annotation : annotations = method.getAnnotations()) {
                        if (!annotation.annotationType().equals(AroundInvoke.class) && !annotation.annotationType().equals(AroundTimeout.class) && !annotation.annotationType().equals(Interceptors.class)) continue;
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.log(Level.FINEST, "Ignoring @JMSDestinationDefinition annotation processing as the class [ " + annotatedClass + " ] is not an Web class, an interceptor and the context is WebContext");
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean isDefinitionAlreadyPresent(Set<ResourceDescriptor> jmsddDescs, JMSDestinationDefinitionDescriptor desc) {
        for (ResourceDescriptor descriptor : jmsddDescs) {
            if (!descriptor.equals(desc)) continue;
            return true;
        }
        return false;
    }

    private void merge(Set<ResourceDescriptor> jmsddDescs, JMSDestinationDefinition defn) {
        for (ResourceDescriptor descriptor : jmsddDescs) {
            JMSDestinationDefinitionDescriptor desc;
            if (!(descriptor instanceof JMSDestinationDefinitionDescriptor) || !(desc = (JMSDestinationDefinitionDescriptor)descriptor).getName().equals(defn.name())) continue;
            if (desc.getInterfaceName() == null) {
                desc.setInterfaceName(defn.interfaceName());
            }
            if (desc.getClassName() == null && this.isValid(defn.className())) {
                desc.setClassName(defn.className());
            }
            if (desc.getDescription() == null && this.isValid(defn.description())) {
                desc.setDescription(defn.description());
            }
            if (desc.getResourceAdapter() == null && this.isValid(defn.resourceAdapter())) {
                desc.setResourceAdapter(defn.resourceAdapter());
            }
            if (desc.getDestinationName() == null && this.isValid(defn.destinationName())) {
                desc.setDestinationName(defn.destinationName());
            }
            Properties properties = desc.getProperties();
            String[] defnProperties = defn.properties();
            if (defnProperties.length <= 0) break;
            for (String property : defnProperties) {
                int index = property.indexOf(61);
                if (index <= 0 || index >= property.length() - 1) continue;
                String name = property.substring(0, index).trim();
                String value = property.substring(index + 1).trim();
                if (properties.get(name) != null) continue;
                properties.put(name, value);
            }
        }
    }

    private JMSDestinationDefinitionDescriptor createDescriptor(JMSDestinationDefinition defn) {
        JMSDestinationDefinitionDescriptor desc = new JMSDestinationDefinitionDescriptor();
        desc.setMetadataSource(MetadataSource.ANNOTATION);
        desc.setName(defn.name());
        desc.setInterfaceName(defn.interfaceName());
        if (this.isValid(defn.className())) {
            desc.setClassName(defn.className());
        }
        if (this.isValid(defn.description())) {
            desc.setDescription(defn.description());
        }
        if (this.isValid(defn.resourceAdapter())) {
            desc.setResourceAdapter(defn.resourceAdapter());
        }
        if (this.isValid(defn.destinationName())) {
            desc.setDestinationName(defn.destinationName());
        }
        if (defn.properties() != null) {
            Properties properties = desc.getProperties();
            String[] defnProperties = defn.properties();
            if (defnProperties.length > 0) {
                for (String property : defnProperties) {
                    int index = property.indexOf(61);
                    if (index <= 0 || index >= property.length() - 1) continue;
                    String name = property.substring(0, index).trim();
                    String value = property.substring(index + 1).trim();
                    properties.put(name, value);
                }
            }
        }
        return desc;
    }

    private boolean isValid(String s) {
        return s != null && !s.equals("");
    }
}

