/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.opentracing.cdi;

import fish.payara.microprofile.opentracing.cdi.OpenTracingCdiUtils;
import fish.payara.opentracing.OpenTracingService;
import fish.payara.requesttracing.jaxrs.client.PayaraTracingServices;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import java.io.Serializable;
import java.util.logging.Logger;
import org.eclipse.microprofile.opentracing.Traced;
import org.glassfish.api.invocation.InvocationManager;

@Interceptor
@Traced
@Priority(value=4000)
public class TracedInterceptor
implements Serializable {
    private static final long serialVersionUID = -7772038254542420659L;
    private static final Logger LOG = Logger.getLogger(TracedInterceptor.class.getName());
    private static final Class[] HTTP_METHODS = new Class[]{GET.class, POST.class, DELETE.class, PUT.class, HEAD.class, PATCH.class, OPTIONS.class};
    @Inject
    private BeanManager beanManager;

    /*
     * Loose catch block
     */
    @AroundInvoke
    public Object traceCdiCall(InvocationContext invocationContext) throws Exception {
        LOG.fine(() -> "traceCdiCall(" + invocationContext + ")");
        PayaraTracingServices payaraTracingServices = new PayaraTracingServices();
        OpenTracingService openTracing = payaraTracingServices.getOpenTracingService();
        InvocationManager invocationManager = payaraTracingServices.getInvocationManager();
        if (openTracing == null || !openTracing.isEnabled() || this.isJaxRsMethod(invocationContext) || this.isWebServiceMethod(invocationContext, invocationManager)) {
            LOG.finest("The call is already monitored by some different component, proceeding the invocation.");
            return invocationContext.proceed();
        }
        Traced traced = OpenTracingCdiUtils.getAnnotation(this.beanManager, Traced.class, invocationContext);
        boolean tracingEnabled = OpenTracingCdiUtils.getConfigOverrideValue(Traced.class, "value", invocationContext, Boolean.TYPE).orElse(traced.value());
        if (!tracingEnabled) {
            LOG.finest("Tracing is not enabled, nothing to do.");
            return invocationContext.proceed();
        }
        String applicationName = openTracing.getApplicationName(invocationManager, invocationContext);
        Tracer tracer = openTracing.getTracer(applicationName);
        String operationName = this.getOperationName(invocationContext, traced);
        Span parentSpan = tracer.activeSpan();
        Span span = tracer.buildSpan(operationName).asChildOf(parentSpan).start();
        try {
            try (Scope scope = tracer.scopeManager().activate(span);){
                Object object = invocationContext.proceed();
                return object;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            span.finish();
        }
    }

    private boolean isJaxRsMethod(InvocationContext invocationContext) {
        for (Class httpMethod : HTTP_METHODS) {
            if (OpenTracingCdiUtils.getAnnotation(this.beanManager, httpMethod, invocationContext) == null) continue;
            return true;
        }
        return false;
    }

    private boolean isWebServiceMethod(InvocationContext invocationContext, InvocationManager invocationManager) {
        return invocationContext.getMethod().equals(invocationManager.peekWebServiceMethod());
    }

    private String getOperationName(InvocationContext invocationContext, Traced traced) {
        String operationName = OpenTracingCdiUtils.getConfigOverrideValue(Traced.class, "operationName", invocationContext, String.class).orElse(traced.operationName());
        if (operationName.isEmpty()) {
            return invocationContext.getMethod().getDeclaringClass().getCanonicalName() + "." + invocationContext.getMethod().getName();
        }
        return operationName;
    }
}

