/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.cache;

import com.sun.appserv.web.cache.CacheHelper;
import com.sun.appserv.web.cache.CacheKeyGenerator;
import com.sun.appserv.web.cache.CacheManager;
import com.sun.appserv.web.cache.mapping.CacheMapping;
import com.sun.appserv.web.cache.mapping.ConstraintField;
import com.sun.appserv.web.cache.mapping.Field;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.web.LogFacade;

public class DefaultCacheHelper
implements CacheHelper {
    private static final String[] KEY_PREFIXES = new String[]{"", "ca.", "rh.", "rp.", "rc.", "ra.", "sa.", "si."};
    public static final String ATTR_CACHING_FILTER_NAME = "com.sun.ias.web.cachingFilterName";
    public static final String PROP_KEY_GENERATOR_ATTR_NAME = "cacheKeyGeneratorAttrName";
    private static final Logger LOGGER = LogFacade.getLogger();
    private ServletContext context;
    private CacheManager manager;
    private String attrKeyGenerator = null;
    private boolean isKeyGeneratorChecked = false;
    private CacheKeyGenerator keyGenerator;

    public void setCacheManager(CacheManager manager) {
        this.manager = manager;
    }

    @Override
    public void init(ServletContext context, Map<String, String> props) {
        this.context = context;
        this.attrKeyGenerator = props.get(PROP_KEY_GENERATOR_ATTR_NAME);
    }

    private Optional<CacheMapping> lookupCacheMapping(HttpServletRequest request) {
        String name = (String)request.getAttribute(ATTR_CACHING_FILTER_NAME);
        return this.manager != null ? Optional.ofNullable(this.manager.getCacheMapping(name)) : Optional.empty();
    }

    @Override
    public String getCacheKey(HttpServletRequest request) {
        String key;
        if (!this.isKeyGeneratorChecked && this.attrKeyGenerator != null) {
            try {
                this.keyGenerator = (CacheKeyGenerator)this.context.getAttribute(this.attrKeyGenerator);
            }
            catch (ClassCastException cce) {
                LOGGER.log(Level.WARNING, "AS-WEB-GLUE-00003", cce);
            }
            this.isKeyGeneratorChecked = true;
        }
        if (this.keyGenerator != null && (key = this.keyGenerator.getCacheKey(this.context, request)) != null) {
            return key;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append(request.getServletPath());
        Optional<CacheMapping> mapping = this.lookupCacheMapping(request);
        if (mapping.isPresent()) {
            Field[] keys;
            for (Field key2 : keys = mapping.get().getKeyFields()) {
                Object value = key2.getValue(this.context, request);
                if (value == null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "AS-WEB-GLUE-00004", request.getServletPath());
                    }
                    return null;
                }
                sb.append(";");
                sb.append(KEY_PREFIXES[key2.getScope()]);
                sb.append(key2.getName());
                sb.append("=");
                sb.append(value);
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isCacheable(HttpServletRequest request) {
        boolean result = false;
        Optional<CacheMapping> mapping = this.lookupCacheMapping(request);
        if (mapping.isPresent() && mapping.get().findMethod(request.getMethod())) {
            ConstraintField[] fields;
            result = true;
            for (ConstraintField field : fields = mapping.get().getConstraintFields()) {
                if (field.applyConstraints(this.context, request)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    @Override
    public boolean isRefreshNeeded(HttpServletRequest request) {
        Object value;
        Field field;
        boolean result = false;
        Optional<CacheMapping> mapping = this.lookupCacheMapping(request);
        if (mapping.isPresent() && (field = mapping.get().getRefreshField()) != null && (value = field.getValue(this.context, request)) != null && "true".equals(value.toString())) {
            result = true;
        }
        return result;
    }

    @Override
    public int getTimeout(HttpServletRequest request) {
        int result = -2;
        Optional<CacheMapping> mapping = this.lookupCacheMapping(request);
        if (mapping.isPresent()) {
            Object value;
            result = mapping.get().getTimeout();
            Field field = mapping.get().getTimeoutField();
            if (field != null && (value = field.getValue(this.context, request)) != null) {
                try {
                    result = Integer.valueOf(value.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    @Override
    public void destroy() throws Exception {
    }
}

