/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.accesslog;

import com.sun.enterprise.web.accesslog.CommonAccessLogFormatterImpl;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.CharBuffer;
import org.apache.catalina.Request;
import org.apache.catalina.Response;

public class CombinedAccessLogFormatterImpl
extends CommonAccessLogFormatterImpl {
    @Override
    public void appendLogEntry(Request request, Response response, CharBuffer charBuffer) {
        super.appendLogEntry(request, response, charBuffer);
        ServletRequest req = request.getRequest();
        HttpServletRequest hreq = (HttpServletRequest)req;
        this.appendReferer(charBuffer, hreq);
        charBuffer.put(" ");
        this.appendUserAgent(charBuffer, hreq);
    }

    private void appendReferer(CharBuffer cb, HttpServletRequest hreq) {
        cb.put("\"");
        String referer = hreq.getHeader("referer");
        if (referer == null) {
            referer = "-";
        }
        cb.put(referer);
        cb.put("\"");
    }

    private void appendUserAgent(CharBuffer cb, HttpServletRequest hreq) {
        cb.put("\"");
        String ua = hreq.getHeader("user-agent");
        if (ua == null) {
            ua = "-";
        }
        cb.put(ua);
        cb.put("\"");
    }
}

