/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.callback;

import com.sun.xml.wss.impl.callback.ValidatorExtension;
import com.sun.xml.wss.impl.callback.XWSSCallback;
import javax.security.auth.callback.Callback;

public class TimestampValidationCallback
extends XWSSCallback
implements Callback {
    private Request request;
    private TimestampValidator validator;

    public TimestampValidationCallback(Request request) {
        this.request = request;
    }

    public void getResult() throws TimestampValidationException {
        if (this.validator == null) {
            throw new TimestampValidationException("A Required TimestampValidator object was not set by the CallbackHandler");
        }
        this.validator.validate(this.request);
    }

    public void setValidator(TimestampValidator validator) {
        this.validator = validator;
        if (this.validator instanceof ValidatorExtension) {
            ((ValidatorExtension)((Object)this.validator)).setRuntimeProperties(this.getRuntimeProperties());
        }
    }

    public static interface TimestampValidator {
        public void validate(Request var1) throws TimestampValidationException;
    }

    public static class TimestampValidationException
    extends Exception {
        private static final long serialVersionUID = 5390126265884591759L;

        public TimestampValidationException(String message) {
            super(message);
        }

        public TimestampValidationException(String message, Throwable cause) {
            super(message, cause);
        }

        public TimestampValidationException(Throwable cause) {
            super(cause);
        }
    }

    public static class UTCTimestampRequest
    implements Request {
        private String created;
        private String expired;
        private long maxClockSkew = 0L;
        private long timestampFreshnessLimit = 0L;
        private boolean isUsernameToken = false;

        public void isUsernameToken(boolean isUsernameToken) {
            this.isUsernameToken = true;
        }

        public boolean isUsernameToken() {
            return this.isUsernameToken;
        }

        public UTCTimestampRequest(String created, String expired, long maxClockSkew, long timestampFreshnessLimit) {
            this.created = created;
            this.expired = expired;
            this.maxClockSkew = maxClockSkew;
            this.timestampFreshnessLimit = timestampFreshnessLimit;
        }

        public String getCreated() {
            return this.created;
        }

        public String getExpired() {
            return this.expired;
        }

        public long getMaxClockSkew() {
            return this.maxClockSkew;
        }

        public long getTimestampFreshnessLimit() {
            return this.timestampFreshnessLimit;
        }
    }

    public static interface Request {
    }
}

