/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.customvalidators;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.customvalidators.JDBCRealmPropertyCheck;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jvnet.hk2.config.types.Property;

public class JDBCRealmPropertyCheckValidator
implements ConstraintValidator<JDBCRealmPropertyCheck, AuthRealm> {
    private static final String JDBC_REALM = "com.sun.enterprise.security.auth.realm.jdbc.JDBCRealm";

    public void initialize(JDBCRealmPropertyCheck fqcn) {
    }

    public boolean isValid(AuthRealm realm, ConstraintValidatorContext constraintValidatorContext) {
        if (realm.getClassname().equals(JDBC_REALM)) {
            String algoName;
            Property jaasContext = realm.getProperty("jaas-context");
            Property dsJndi = realm.getProperty("datasource-jndi");
            Property userTable = realm.getProperty("user-table");
            Property groupTable = realm.getProperty("group-table");
            Property userNameCol = realm.getProperty("user-name-column");
            Property passwdCol = realm.getProperty("password-column");
            Property grpNameCol = realm.getProperty("group-name-column");
            Property digestAlgo = realm.getProperty("digest-algorithm");
            if (jaasContext == null || dsJndi == null || userTable == null || groupTable == null || userNameCol == null || passwdCol == null || grpNameCol == null) {
                return false;
            }
            if (digestAlgo != null && !"none".equalsIgnoreCase(algoName = digestAlgo.getValue())) {
                try {
                    MessageDigest.getInstance(algoName);
                }
                catch (NoSuchAlgorithmException e) {
                    return false;
                }
            }
        }
        return true;
    }
}

