/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLIContainer;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.StringEditDistance;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.InvalidCommandException;

public class CLIUtil {
    private static final int MAX_COMMANDS_TO_DISPLAY = 75;
    private static final LocalStringsImpl strings = new LocalStringsImpl(CLIUtil.class);
    protected static final Logger LOGGER = Logger.getLogger(CLIUtil.class.getPackage().getName());

    public static Map<String, String> readPasswordFileOptions(String passwordFileName, boolean withPrefix) throws CommandException {
        HashMap<String, String> passwordOptions = new HashMap<String, String>();
        boolean readStdin = passwordFileName.equals("-");
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(readStdin ? System.in : new FileInputStream(passwordFileName));
            Properties prop = new Properties();
            prop.load(is);
            for (Object key : prop.keySet()) {
                String entry = (String)key;
                if (!entry.startsWith(Environment.getPrefix())) continue;
                String optionName = withPrefix ? entry : entry.substring(Environment.getPrefix().length()).toLowerCase(Locale.ENGLISH);
                String optionValue = prop.getProperty(entry);
                passwordOptions.put(optionName, optionValue);
            }
        }
        catch (Exception e) {
            throw new CommandException((Throwable)e);
        }
        finally {
            try {
                if (!readStdin && is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception exception) {}
        }
        return passwordOptions;
    }

    public static void displayClosestMatch(String commandName, String[] commands, String msg, Logger logger) throws InvalidCommandException {
        try {
            String trimmedCommandName;
            int beginIndex = 0;
            int endIndex = commandName.length();
            if (commandName.startsWith("*")) {
                beginIndex = 1;
            }
            if (commandName.endsWith("*")) {
                endIndex = commandName.length() - 1;
            }
            if (!(trimmedCommandName = commandName.substring(beginIndex, endIndex)).startsWith("_")) {
                ArrayList<String> ncl = new ArrayList<String>();
                for (String cmd : Arrays.asList(commands)) {
                    if (cmd.startsWith("_")) continue;
                    ncl.add(cmd);
                }
                commands = ncl.toArray(new String[ncl.size()]);
            }
            Arrays.sort(commands);
            String[] matchedCommands = CLIUtil.getMatchedCommands(trimmedCommandName, commands);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            if (matchedCommands.length > 0 && matchedCommands.length < 75) {
                if (msg != null) {
                    pw.println(msg);
                } else {
                    pw.println(strings.get("ClosestMatchedCommands"));
                }
                for (String eachCommand : matchedCommands) {
                    pw.println("    " + eachCommand);
                }
            } else {
                String nearestString = StringEditDistance.findNearest(trimmedCommandName, commands);
                if (StringEditDistance.editDistance(trimmedCommandName, nearestString) < 5) {
                    if (msg != null) {
                        pw.println(msg);
                    } else {
                        pw.println(strings.get("ClosestMatchedCommands"));
                    }
                    pw.println("    " + nearestString);
                } else {
                    throw new InvalidCommandException(commandName);
                }
            }
            pw.flush();
            logger.log(Level.SEVERE, sw.toString());
        }
        catch (Exception e) {
            throw new InvalidCommandException(commandName);
        }
    }

    private static String[] getMatchedCommands(String pattern, String[] commands) {
        ArrayList<String> matchedCommands = new ArrayList<String>();
        for (String command : commands) {
            if (!command.contains(pattern)) continue;
            matchedCommands.add(command);
        }
        return matchedCommands.toArray(new String[matchedCommands.size()]);
    }

    public static String[] getAllCommands(CLIContainer container, ProgramOptions options, Environment env) {
        String[] remoteCommands;
        try {
            remoteCommands = CLIUtil.getRemoteCommands(container, options, env);
        }
        catch (CommandException ex) {
            LOGGER.severe("Remote commands not fetched");
            LOGGER.finest(ex.getMessage());
            remoteCommands = new String[]{};
        }
        String[] localCommands = CLIUtil.getLocalCommands(container);
        Object[] allCommands = new String[localCommands.length + remoteCommands.length];
        System.arraycopy(localCommands, 0, allCommands, 0, localCommands.length);
        System.arraycopy(remoteCommands, 0, allCommands, localCommands.length, remoteCommands.length);
        Arrays.sort(allCommands);
        return allCommands;
    }

    public static String[] getLocalCommands(CLIContainer container) {
        Set<String> names = container.getLocalCommandsNames();
        Object[] localCommands = names.toArray(new String[names.size()]);
        Arrays.sort(localCommands);
        return localCommands;
    }

    public static String[] getRemoteCommands(CLIContainer container, ProgramOptions po, Environment env) throws CommandException, CommandValidationException {
        Set<String> localnames = container.getLocalCommandsNames();
        po.removeDetach();
        RemoteCLICommand cmd = new RemoteCLICommand("list-commands", po, env);
        ActionReport report = cmd.executeAndReturnActionReport("list-commands");
        List children = report.getTopMessagePart().getChildren();
        ArrayList<String> rcmds = new ArrayList<String>(children.size());
        for (ActionReport.MessagePart msg : children) {
            if (localnames.contains(msg.getMessage())) continue;
            rcmds.add(msg.getMessage());
        }
        Collections.sort(rcmds);
        Object[] remoteCommands = rcmds.toArray(new String[rcmds.size()]);
        Arrays.sort(remoteCommands);
        return remoteCommands;
    }

    public static void writeCommandToDebugLog(String cname, Environment env, String[] args, int exit) {
        File log = env.getDebugLogfile();
        if (log == null) {
            return;
        }
        try (BufferedWriter out = new BufferedWriter(new FileWriter(log, true));){
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            Date date = new Date();
            out.write(dateFormat.format(date));
            out.write(" EXIT: " + exit);
            out.write(" " + cname + " ");
            if (args != null) {
                int maxPath = 22;
                for (int i = 0; i < args.length; ++i) {
                    String arg = args[i];
                    if (i > 0 && arg.length() > 22 && "--passwordfile".equals(args[i - 1])) {
                        arg = CLIUtil.truncate(arg, 22);
                    }
                    out.write(arg + " ");
                }
            }
            out.write("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String truncate(String arg, int max) {
        int len = arg.length();
        if (len < 20) {
            return arg;
        }
        return "....." + arg.substring(len - max);
    }
}

