/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.jwtauth.activation;

import fish.payara.microprofile.connector.MicroProfileDeployer;
import fish.payara.microprofile.jwtauth.RolesDeclarationInitializer;
import fish.payara.microprofile.jwtauth.activation.JwtAuthApplicationContainer;
import fish.payara.microprofile.jwtauth.activation.JwtAuthContainer;
import fish.payara.microprofile.jwtauth.cdi.JwtAuthCdiExtension;
import java.util.Collection;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.web.deployment.descriptor.AppListenerDescriptorImpl;
import org.glassfish.web.deployment.descriptor.WebBundleDescriptorImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class JwtAuthDeployer
extends MicroProfileDeployer<JwtAuthContainer, JwtAuthApplicationContainer> {
    private static final Logger LOGGER = Logger.getLogger(JwtAuthDeployer.class.getName());

    public JwtAuthApplicationContainer load(JwtAuthContainer container, DeploymentContext deploymentContext) {
        WebBundleDescriptorImpl descriptor = (WebBundleDescriptorImpl)deploymentContext.getModuleMetaData(WebBundleDescriptorImpl.class);
        if (descriptor != null) {
            descriptor.addAppListenerDescriptor(new AppListenerDescriptorImpl(RolesDeclarationInitializer.class.getName()));
            Enumeration securityConstraintEnumeration = descriptor.getSecurityConstraints();
            if (securityConstraintEnumeration.hasMoreElements()) {
                LOGGER.warning("Invalid web.xml - security-constraints cannot be defined while using the @LoginConfig annotation");
            }
        } else {
            LOGGER.warning("Failed to find WebBundleDescriptorImpl. JWT Auth roles will not be declared");
        }
        Collection snifferExtensions = (Collection)deploymentContext.getTransientAppMetaData("org.glassfish.weld.sniffers", Collection.class);
        if (snifferExtensions != null) {
            snifferExtensions.add(JwtAuthCdiExtension::new);
        }
        return new JwtAuthApplicationContainer(deploymentContext);
    }

    public void unload(JwtAuthApplicationContainer applicationContainer, DeploymentContext ctx) {
    }
}

