/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model;

import com.sun.jdo.api.persistence.model.ClassLoaderStrategy;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.common.util.StringHelper;
import org.glassfish.persistence.common.I18NHelper;
import org.netbeans.modules.dbschema.SchemaElement;

public class RuntimeModel
extends Model {
    private static final String CLASS_EXTENSION = "class";
    private static final String JAVA_PACKAGE = "java.";
    private static final String SERIALIZABLE = "java.io.Serializable";
    private HashMap classLoaders = new HashMap();

    protected RuntimeModel() {
    }

    @Override
    public boolean isInterface(String className) {
        Class classElement = (Class)this.getClass(className);
        return classElement != null ? classElement.isInterface() : false;
    }

    @Override
    protected BufferedInputStream getInputStreamForResource(String className, ClassLoader classLoader, String resourceName) {
        InputStream is = className != null ? classLoader.getResourceAsStream(resourceName) : null;
        BufferedInputStream rc = null;
        rc = is != null && !(is instanceof BufferedInputStream) ? new BufferedInputStream(is) : (BufferedInputStream)is;
        return rc;
    }

    private String getShortClassName(String className) {
        return JavaTypeHelper.getShortClassName(className);
    }

    @Override
    protected String findPenultimateSuperclass(String className) {
        Class classElement = (Class)this.getClass(className);
        Class<Object> objectClass = Object.class;
        Class testClass = null;
        if (classElement == null) {
            return className;
        }
        while ((testClass = classElement.getSuperclass()) != null && !testClass.equals(objectClass)) {
            classElement = testClass;
        }
        return classElement.getName();
    }

    @Override
    protected String getSuperclass(String className) {
        Class classElement = (Class)this.getClass(className);
        if (classElement != null) {
            classElement = classElement.getSuperclass();
        }
        return classElement != null ? classElement.getName() : null;
    }

    @Override
    public MappingClassElement getMappingClass(String className, ClassLoader classLoader) {
        String databaseRoot;
        MappingClassElement mappingClass = null;
        mappingClass = super.getMappingClass(className, classLoader = this.findClassLoader(className, classLoader));
        if (mappingClass != null && classLoader != null && !StringHelper.isEmpty((String)(databaseRoot = mappingClass.getDatabaseRoot())) && SchemaElement.forName((String)databaseRoot, (Object)classLoader) == null) {
            throw new RuntimeException(I18NHelper.getMessage(RuntimeModel.getMessages(), "dbschema.not_found", databaseRoot, className));
        }
        return mappingClass;
    }

    @Override
    public Map getClassLoaderCache() {
        return Collections.unmodifiableMap(this.classLoaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResourcesFromCaches(ClassLoader classLoader) {
        HashSet classNames = new HashSet();
        HashMap hashMap = this.classLoaders;
        synchronized (hashMap) {
            Iterator i = this.classLoaders.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry next = i.next();
                if (next.getValue() != classLoader) continue;
                classNames.add(next.getKey());
                i.remove();
            }
        }
        this.removeResourcesFromCaches(classNames);
    }

    @Override
    protected BufferedOutputStream createFile(String className, String baseFileName, String extension) throws IOException {
        Class classElement;
        char extensionCharacter = '.';
        File file = this.getFile(className, baseFileName + extensionCharacter + extension);
        if (file == null && (classElement = (Class)this.getClass(className)) != null) {
            String path = classElement.getResource(this.getShortClassName(className) + extensionCharacter + CLASS_EXTENSION).getFile();
            int index = path.lastIndexOf(extensionCharacter) + 1;
            file = new File(path.substring(0, index) + extension);
            file.createNewFile();
        }
        return file != null ? new BufferedOutputStream(new FileOutputStream(file)) : null;
    }

    @Override
    protected void deleteFile(String className, String fileName) throws IOException {
        File file = this.getFile(className, fileName);
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    protected File getFile(String className, String fileName) throws IOException {
        Class classElement = (Class)this.getClass(className);
        if (classElement != null) {
            URL path = classElement.getResource(fileName.substring(fileName.lastIndexOf(this.getShortClassName(className))));
            return path != null ? new File(path.getFile()) : null;
        }
        return null;
    }

    @Override
    public Object getClass(String className, ClassLoader classLoader) {
        if (className == null) {
            return null;
        }
        try {
            classLoader = this.findClassLoader(className, classLoader);
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClassLoader findClassLoader(String className, ClassLoader classLoader) throws IllegalArgumentException {
        ClassLoader cached = null;
        if (className == null) {
            return null;
        }
        if (className.startsWith(JAVA_PACKAGE) || this.isPrimitive(className)) {
            return this.getClass().getClassLoader();
        }
        HashMap hashMap = this.classLoaders;
        synchronized (hashMap) {
            block15: {
                cached = (ClassLoader)this.classLoaders.get(className);
                if (classLoader == null) {
                    classLoader = cached != null ? cached : this.getClass().getClassLoader();
                } else if (cached == null) {
                    this.classLoaders.put(className, classLoader);
                } else if (classLoader != cached) {
                    Class<?> clazz = null;
                    Class<?> cachedClazz = null;
                    try {
                        String prop = ClassLoaderStrategy.getStrategy();
                        clazz = Class.forName(className, true, classLoader);
                        cachedClazz = Class.forName(className, true, cached);
                        if (clazz.getClassLoader() == cachedClazz.getClassLoader()) {
                            return cached;
                        }
                        if ("ignore".equals(prop)) {
                            return cached;
                        }
                        if ("reload".equals(prop)) {
                            this.removeResourcesFromCaches(cachedClazz.getClassLoader());
                            this.classLoaders.put(className, classLoader);
                            return classLoader;
                        }
                        throw new IllegalArgumentException(I18NHelper.getMessage(RuntimeModel.getMessages(), "classloader.multiple", className));
                    }
                    catch (ClassNotFoundException ex) {
                        if (clazz == null || cachedClazz != null) break block15;
                        this.classLoaders.put(className, classLoader);
                    }
                }
            }
        }
        return classLoader;
    }

    @Override
    public boolean implementsInterface(Object classElement, String interfaceName) {
        Class interfaceClass = (Class)this.getClass(interfaceName);
        if (classElement == null || !(classElement instanceof Class) || interfaceClass == null) {
            return false;
        }
        return interfaceClass.isAssignableFrom((Class)classElement);
    }

    @Override
    public boolean hasConstructor(String className) {
        final Class classElement = (Class)this.getClass(className);
        if (classElement != null) {
            Boolean b = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return JavaTypeHelper.valueOf(classElement.getDeclaredConstructors().length != 0);
                }
            });
            return b;
        }
        return false;
    }

    @Override
    public Object getConstructor(String className, String[] argTypeNames) {
        final Class classElement = (Class)this.getClass(className);
        if (classElement != null) {
            final Class[] argTypes = this.getTypesForNames(argTypeNames);
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return classElement.getDeclaredConstructor(argTypes);
                    }
                    catch (NoSuchMethodException ex) {
                        return null;
                    }
                }
            });
        }
        return null;
    }

    @Override
    public Object getMethod(String className, final String methodName, String[] argTypeNames) {
        final Class classElement = (Class)this.getClass(className);
        if (classElement != null) {
            final Class[] argTypes = this.getTypesForNames(argTypeNames);
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return classElement.getDeclaredMethod(methodName, argTypes);
                    }
                    catch (NoSuchMethodException ex) {
                        return null;
                    }
                }
            });
        }
        return null;
    }

    @Override
    public String getType(Object element) {
        return this.getNameForType(this.getTypeObject(element));
    }

    @Override
    public List getFields(String className) {
        ArrayList<String> returnList = new ArrayList<String>();
        final Class classElement = (Class)this.getClass(className);
        if (classElement != null) {
            Field[] fields = (Field[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return classElement.getDeclaredFields();
                }
            });
            int count = fields.length;
            for (int i = 0; i < count; ++i) {
                returnList.add(fields[i].getName());
            }
        }
        return returnList;
    }

    @Override
    public Object getField(String className, final String fieldName) {
        final Class classElement = (Class)this.getClass(className);
        if (classElement != null) {
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return classElement.getDeclaredField(fieldName);
                    }
                    catch (NoSuchFieldException e) {
                        return null;
                    }
                }
            });
        }
        return null;
    }

    @Override
    public boolean isSerializable(Object fieldElement) {
        Class<?> type;
        for (type = this.getTypeObject(fieldElement); type != null && type.isArray(); type = type.getComponentType()) {
        }
        return type != null ? type.isPrimitive() || this.implementsInterface(type, SERIALIZABLE) : false;
    }

    @Override
    public boolean isArray(String className, String fieldName) {
        Object fieldElement = this.getField(className, fieldName);
        return fieldElement != null ? this.getTypeObject(fieldElement).isArray() : false;
    }

    @Override
    public String getDeclaringClass(Object memberElement) {
        Class<?> classElement = null;
        if (memberElement != null && memberElement instanceof Member) {
            classElement = ((Member)memberElement).getDeclaringClass();
        }
        return classElement != null ? classElement.getName() : null;
    }

    @Override
    public int getModifiers(Object memberElement) {
        int modifiers = 0;
        if (memberElement != null) {
            if (memberElement instanceof Class) {
                modifiers = ((Class)memberElement).getModifiers();
            } else if (memberElement instanceof Member) {
                modifiers = ((Member)memberElement).getModifiers();
            }
        }
        return modifiers;
    }

    protected Class getTypeObject(Object element) {
        Class<?> type = null;
        if (element != null) {
            if (element instanceof Field) {
                type = ((Field)element).getType();
            } else if (element instanceof Method) {
                type = ((Method)element).getReturnType();
            }
        }
        return type;
    }

    private String getNameForType(Class type) {
        Object typeName = null;
        if (type != null) {
            typeName = type.isArray() ? this.getNameForType(type.getComponentType()) + "[]" : type.getName();
        }
        return typeName;
    }

    private Class[] getTypesForNames(String[] typeNames) {
        Class[] classes = new Class[typeNames.length];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = this.getTypeForName(typeNames[i]);
        }
        return classes;
    }

    private Class getTypeForName(String typeName) {
        Class clazz = JavaTypeHelper.getPrimitiveClass(typeName);
        if (clazz == null) {
            clazz = (Class)this.getClass(typeName);
        }
        return clazz;
    }
}

