/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast;

import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Member;
import com.hazelcast.collection.ISet;
import com.hazelcast.config.Config;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.KubernetesConfig;
import com.hazelcast.config.MemberAddressProviderConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.cp.CPSubsystemManagementService;
import com.hazelcast.cp.event.CPGroupAvailabilityEvent;
import com.hazelcast.cp.event.CPGroupAvailabilityListener;
import com.hazelcast.cp.event.CPMembershipEvent;
import com.hazelcast.cp.event.CPMembershipListener;
import com.hazelcast.cp.exception.CPGroupDestroyedException;
import com.hazelcast.internal.config.ConfigLoader;
import com.hazelcast.kubernetes.KubernetesProperties;
import com.hazelcast.map.IMap;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.StreamSerializer;
import com.hazelcast.spi.MemberAddressProvider;
import com.hazelcast.spi.discovery.integration.DiscoveryServiceProvider;
import com.hazelcast.spi.properties.ClusterProperty;
import com.sun.enterprise.util.Utility;
import fish.payara.nucleus.events.HazelcastEvents;
import fish.payara.nucleus.hazelcast.DnsDiscoveryServiceProvider;
import fish.payara.nucleus.hazelcast.DomainDiscoveryStrategy;
import fish.payara.nucleus.hazelcast.HazelcastConfigSpecificConfiguration;
import fish.payara.nucleus.hazelcast.HazelcastRuntimeConfiguration;
import fish.payara.nucleus.hazelcast.MemberAddressPicker;
import fish.payara.nucleus.hazelcast.PayaraHazelcastDiscoveryFactory;
import fish.payara.nucleus.hazelcast.PayaraHazelcastSerializer;
import fish.payara.nucleus.hazelcast.PayaraMicroNameGenerator;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.cache.spi.CachingProvider;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.JavaEEContextUtil;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="hazelcast-core")
@RunLevel(value=10)
public class HazelcastCore
implements EventListener,
ConfigListener {
    public static final String INSTANCE_ATTRIBUTE_MAP = "payara-instance-map";
    public static final String INSTANCE_ATTRIBUTE = "GLASSFISH-INSTANCE";
    public static final String INSTANCE_GROUP_ATTRIBUTE = "GLASSFISH_INSTANCE_GROUP";
    public static final String CLUSTER_EXECUTOR_SERVICE_NAME = "payara-cluster-execution";
    public static final String SCHEDULED_CLUSTER_EXECUTOR_SERVICE_NAME = "payara-scheduled-execution";
    private static HazelcastCore theCore;
    private HazelcastInstance theInstance;
    private CachingProvider hazelcastCachingProvider;
    private boolean enabled;
    private boolean booted = false;
    private String memberName;
    private String memberGroup;
    private boolean datagridEncryptionValue;
    @Inject
    Events events;
    @Inject
    ServerContext context;
    @Inject
    ServerEnvironment env;
    @Inject
    HazelcastRuntimeConfiguration configuration;
    @Inject
    HazelcastConfigSpecificConfiguration nodeConfig;
    @Inject
    private ClassLoaderHierarchy clh;
    @Inject
    @Optional
    private JavaEEContextUtil ctxUtil;
    @Inject
    Transactions transactions;
    final Lock cpResetLock = new ReentrantLock();
    final AtomicReference<Instant> lastResetTime = new AtomicReference<Instant>(Instant.EPOCH);

    public static HazelcastCore getCore() {
        return theCore;
    }

    @PostConstruct
    public void postConstruct() {
        theCore = this;
        this.events.register((EventListener)this);
        this.enabled = Boolean.parseBoolean(this.nodeConfig.getEnabled());
        this.transactions.addListenerForType(HazelcastConfigSpecificConfiguration.class, (ConfigListener)this);
        this.transactions.addListenerForType(HazelcastRuntimeConfiguration.class, (ConfigListener)this);
        if (this.env.isMicro()) {
            this.memberName = this.nodeConfig.getMemberName();
            this.memberGroup = this.nodeConfig.getMemberGroup();
        } else {
            this.memberName = this.context.getInstanceName();
            this.memberGroup = this.nodeConfig.getMemberGroup();
        }
        this.datagridEncryptionValue = Boolean.parseBoolean(this.configuration.getDatagridEncryptionEnabled());
        if (this.datagridEncryptionValue) {
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "Data grid encryption is enabled");
        }
    }

    public String getMemberName() {
        return this.memberName;
    }

    public String getMemberGroup() {
        return this.memberGroup;
    }

    public UUID getUUID() {
        this.bootstrapHazelcast();
        if (!this.enabled) {
            return UUID.randomUUID();
        }
        return this.theInstance.getCluster().getLocalMember().getUuid();
    }

    public boolean isLite() {
        this.bootstrapHazelcast();
        if (!this.enabled) {
            return false;
        }
        return this.theInstance.getCluster().getLocalMember().isLiteMember();
    }

    public HazelcastInstance getInstance() {
        this.bootstrapHazelcast();
        return this.theInstance;
    }

    public CachingProvider getCachingProvider() {
        this.bootstrapHazelcast();
        return this.hazelcastCachingProvider;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void event(EventListener.Event event) {
        if (event.is(Deployment.ALL_APPLICATIONS_STOPPED)) {
            this.shutdownHazelcast();
        } else if (event.is(Deployment.ALL_APPLICATIONS_LOADED)) {
            ClassLoader oldCL = Utility.getClassLoader();
            try {
                Utility.setContextClassLoader((ClassLoader)this.clh.getCommonClassLoader());
                this.bootstrapHazelcast();
            }
            finally {
                Utility.setContextClassLoader((ClassLoader)oldCL);
            }
        } else if (event.is(EventTypes.SERVER_STARTUP) && this.isEnabled() && this.booted) {
            this.events.send(new EventListener.Event(HazelcastEvents.HAZELCAST_BOOTSTRAP_COMPLETE));
        }
    }

    public void setEnabled(Boolean enabled) {
        if (this.enabled || enabled.booleanValue()) {
            if (this.enabled && !enabled.booleanValue()) {
                this.enabled = false;
                this.shutdownHazelcast();
                this.booted = false;
            } else if (!this.enabled && enabled.booleanValue()) {
                this.enabled = true;
                this.bootstrapHazelcast();
            } else if (this.enabled && enabled.booleanValue()) {
                this.shutdownHazelcast();
                this.enabled = true;
                this.booted = false;
                this.bootstrapHazelcast();
            }
        }
    }

    private Config buildConfiguration() {
        Config config = new Config();
        String hazelcastFilePath = "";
        try {
            File file;
            Boolean isChangeToDefault = Boolean.valueOf(this.configuration.getChangeToDefault());
            hazelcastFilePath = System.getProperty("hazelcast.config");
            if (hazelcastFilePath == null || hazelcastFilePath.isEmpty()) {
                hazelcastFilePath = this.configuration.getHazelcastConfigurationFile();
            }
            if ((file = new File(hazelcastFilePath)).exists()) {
                Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "Loading Hazelcast configuration from file: {0}", hazelcastFilePath);
                config = ConfigLoader.load((String)hazelcastFilePath);
                if (config == null) {
                    Logger.getLogger(HazelcastCore.class.getName()).log(Level.WARNING, "Hazelcast Core could not find configuration file {0} using default configuration", hazelcastFilePath);
                    config = new Config();
                }
                config.setClassLoader((ClassLoader)this.clh.getCommonClassLoader());
                if (this.ctxUtil == null) {
                    Logger.getLogger(HazelcastCore.class.getName()).log(Level.WARNING, "Hazelcast Application Object Serialization Not Available");
                } else {
                    SerializationConfig serConfig = config.getSerializationConfig();
                    if (serConfig == null) {
                        serConfig = new SerializationConfig();
                        this.setPayaraSerializerConfig(serConfig);
                        config.setSerializationConfig(serConfig);
                    } else if (serConfig.getGlobalSerializerConfig() == null) {
                        this.setPayaraSerializerConfig(serConfig);
                    } else {
                        Serializer ser = serConfig.getGlobalSerializerConfig().getImplementation();
                        if (ser instanceof StreamSerializer) {
                            config.getSerializationConfig().getGlobalSerializerConfig().setImplementation((Serializer)new PayaraHazelcastSerializer(this.ctxUtil, (StreamSerializer)ser));
                        } else {
                            Logger.getLogger(HazelcastCore.class.getName()).log(Level.WARNING, "Global serializer is not StreamSerializer: {0}", ser.getClass().getName());
                        }
                    }
                }
                final Config config1 = config;
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HazelcastRuntimeConfiguration>(){

                    public Object run(HazelcastRuntimeConfiguration hazelcastRuntimeConfigurationProxy) {
                        HazelcastCore.this.fillHazelcastConfigurationFromConfig(config1, hazelcastRuntimeConfigurationProxy);
                        Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "Hazelcast general configuration filled from file");
                        return null;
                    }
                }, (ConfigBeanProxy)this.configuration);
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HazelcastConfigSpecificConfiguration>(){

                    public Object run(HazelcastConfigSpecificConfiguration hazelcastRuntimeConfigurationProxy) {
                        HazelcastCore.this.fillSpecificHazelcastConfigFromConfig(config1, hazelcastRuntimeConfigurationProxy);
                        Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "Hazelcast specific configuration created");
                        return null;
                    }
                }, (ConfigBeanProxy)this.nodeConfig);
            } else {
                if (isChangeToDefault.booleanValue()) {
                    try {
                        this.fillConfigurationWithDefaults();
                    }
                    catch (TransactionFailure e) {
                        Logger.getLogger(HazelcastCore.class.getName()).log(Level.SEVERE, "Hazelcast setting to default config exception: " + e.toString(), e);
                    }
                }
                config.setClassLoader((ClassLoader)this.clh.getCommonClassLoader());
                config.setProperty(ClusterProperty.WAIT_SECONDS_BEFORE_JOIN.getName(), "1");
                if (this.ctxUtil != null) {
                    SerializationConfig serializationConfig = new SerializationConfig();
                    this.setPayaraSerializerConfig(serializationConfig);
                    config.setSerializationConfig(serializationConfig);
                }
                config.setLicenseKey(this.configuration.getLicenseKey());
                config.setLiteMember(Boolean.parseBoolean(this.nodeConfig.getLite()));
                config.setClusterName(this.configuration.getClusterGroupName());
                boolean hostAwarePartitioning = false;
                if ("true".equals(this.configuration.getHostAwarePartitioning())) {
                    hostAwarePartitioning = true;
                    PartitionGroupConfig partitionGroupConfig = config.getPartitionGroupConfig();
                    partitionGroupConfig.setEnabled(this.enabled);
                    partitionGroupConfig.setGroupType(PartitionGroupConfig.MemberGroupType.HOST_AWARE);
                }
                this.buildNetworkConfiguration(config, hostAwarePartitioning);
                ExecutorConfig executorConfig = config.getExecutorConfig(CLUSTER_EXECUTOR_SERVICE_NAME);
                executorConfig.setStatisticsEnabled(true);
                executorConfig.setPoolSize(Integer.parseInt(this.nodeConfig.getExecutorPoolSize()));
                executorConfig.setQueueCapacity(Integer.parseInt(this.nodeConfig.getExecutorQueueCapacity()));
                ScheduledExecutorConfig scheduledExecutorConfig = config.getScheduledExecutorConfig(SCHEDULED_CLUSTER_EXECUTOR_SERVICE_NAME);
                scheduledExecutorConfig.setDurability(1);
                scheduledExecutorConfig.setCapacity(Integer.parseInt(this.nodeConfig.getScheduledExecutorQueueCapacity()));
                scheduledExecutorConfig.setPoolSize(Integer.parseInt(this.nodeConfig.getScheduledExecutorPoolSize()));
                config.setProperty("hazelcast.jmx", "true");
            }
            if (config.getCPSubsystemConfig().getCPMemberCount() == 0) {
                config.getCPSubsystemConfig().setCPMemberCount(Integer.getInteger("hazelcast.cp-subsystem.cp-member-count", 0).intValue());
            }
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.WARNING, "Unable to parse server config URL", ex);
        }
        catch (IOException ex) {
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.WARNING, "Hazelcast Core could not load configuration file " + hazelcastFilePath + " using default configuration", ex);
        }
        catch (TransactionFailure ex) {
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.WARNING, "Hazelcast Configuration data could no be saved", ex);
        }
        return config;
    }

    private void setPayaraSerializerConfig(SerializationConfig serConfig) {
        if (serConfig == null || this.ctxUtil == null) {
            throw new IllegalStateException("either serialization config or ctxUtil is null");
        }
        serConfig.setGlobalSerializerConfig(new GlobalSerializerConfig().setImplementation((Serializer)new PayaraHazelcastSerializer(this.ctxUtil, null)).setOverrideJavaSerialization(true));
    }

    private void buildNetworkConfiguration(Config config, boolean hostAwarePartitioning) throws NumberFormatException {
        String discoveryMode;
        int configSpecificPortInt;
        NetworkConfig nConfig = config.getNetworkConfig();
        String noClusterProp = this.nodeConfig.getClusteringEnabled();
        if (noClusterProp != null && Boolean.parseBoolean(noClusterProp)) {
            config.getNetworkConfig().getJoin().getAutoDetectionConfig().setEnabled(false);
        }
        if (this.nodeConfig.getPublicAddress() != null && !this.nodeConfig.getPublicAddress().isEmpty()) {
            nConfig.setPublicAddress(this.nodeConfig.getPublicAddress());
        }
        if (!this.configuration.getInterface().isEmpty()) {
            String[] interfaceNames;
            for (String interfaceName : interfaceNames = this.configuration.getInterface().split(",")) {
                nConfig.getInterfaces().addInterface(interfaceName.trim());
            }
            nConfig.getInterfaces().setEnabled(true);
        } else {
            MemberAddressProviderConfig memberAddressProviderConfig = nConfig.getMemberAddressProviderConfig();
            memberAddressProviderConfig.setEnabled(this.enabled);
            memberAddressProviderConfig.setImplementation((MemberAddressProvider)new MemberAddressPicker(this.env, this.configuration, this.nodeConfig));
        }
        int port = Integer.parseInt(this.configuration.getStartPort());
        String configSpecificPort = this.nodeConfig.getConfigSpecificDataGridStartPort();
        if (configSpecificPort != null && !configSpecificPort.isEmpty() && (configSpecificPortInt = Integer.parseInt(configSpecificPort)) != 0) {
            port = configSpecificPortInt;
        }
        if ((discoveryMode = this.configuration.getDiscoveryMode()).startsWith("tcpip")) {
            TcpIpConfig tConfig = config.getNetworkConfig().getJoin().getTcpIpConfig();
            tConfig.setEnabled(true);
            tConfig.addMember(this.configuration.getTcpipMembers());
            config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        } else if (discoveryMode.startsWith("dns")) {
            config.setProperty("hazelcast.discovery.enabled", "true");
            config.getNetworkConfig().getJoin().getDiscoveryConfig().setDiscoveryServiceProvider((DiscoveryServiceProvider)new DnsDiscoveryServiceProvider(this.configuration.getDnsMembers()));
            config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        } else if (discoveryMode.startsWith("multicast")) {
            MulticastConfig mcConfig = config.getNetworkConfig().getJoin().getMulticastConfig();
            mcConfig.setEnabled(true);
            mcConfig.setMulticastGroup(this.configuration.getMulticastGroup());
            mcConfig.setMulticastPort(Integer.parseInt(this.configuration.getMulticastPort()));
        } else if (discoveryMode.startsWith("kubernetes")) {
            config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
            ((KubernetesConfig)((KubernetesConfig)((KubernetesConfig)config.getNetworkConfig().getJoin().getKubernetesConfig().setEnabled(true)).setProperty(KubernetesProperties.NAMESPACE.key(), this.configuration.getKubernetesNamespace())).setProperty(KubernetesProperties.SERVICE_NAME.key(), this.configuration.getKubernetesServiceName())).setProperty(KubernetesProperties.SERVICE_PORT.key(), String.valueOf(port));
        } else {
            config.setProperty("hazelcast.discovery.enabled", "true");
            config.getNetworkConfig().getJoin().getDiscoveryConfig().addDiscoveryStrategyConfig(new DiscoveryStrategyConfig(DomainDiscoveryStrategy.class.getName()).addProperty(PayaraHazelcastDiscoveryFactory.HOST_AWARE_PARTITIONING.key(), (Comparable)Boolean.valueOf(hostAwarePartitioning)));
            config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
            if (Boolean.parseBoolean(System.getProperty("hazelcast.auto-partition-group", "true"))) {
                PartitionGroupConfig partitionGroupConfig = config.getPartitionGroupConfig();
                partitionGroupConfig.setEnabled(true);
                partitionGroupConfig.setGroupType(PartitionGroupConfig.MemberGroupType.SPI);
            }
        }
        if (this.env.isDas() && !this.env.isMicro()) {
            port = Integer.parseInt(this.configuration.getDasPort());
        }
        config.getNetworkConfig().setPort(port);
        config.getNetworkConfig().setPortAutoIncrement("true".equalsIgnoreCase(this.configuration.getAutoIncrementPort()));
    }

    private void shutdownHazelcast() {
        if (this.theInstance != null) {
            this.enabled = false;
            this.events.send(new EventListener.Event(HazelcastEvents.HAZELCAST_SHUTDOWN_STARTED, (Object)true));
            this.unbindFromJNDI();
            this.hazelcastCachingProvider.getCacheManager().close();
            this.hazelcastCachingProvider.close();
            this.theInstance.shutdown();
            this.theInstance = null;
            this.events.send(new EventListener.Event(HazelcastEvents.HAZELCAST_SHUTDOWN_COMPLETE));
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "Shutdown Hazelcast");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void bootstrapHazelcast() {
        if (!this.booted && this.isEnabled()) {
            Config config = this.buildConfiguration();
            Logger cpSubsystemLogger = Logger.getLogger("com.hazelcast.cp.CPSubsystem");
            Level cpSubsystemLevel = cpSubsystemLogger.getLevel();
            try {
                cpSubsystemLogger.setLevel(Level.SEVERE);
                config.getMemberAttributeConfig().setAttribute(INSTANCE_GROUP_ATTRIBUTE, this.memberGroup);
                this.theInstance = Hazelcast.newHazelcastInstance((Config)config);
                this.autoPromoteCPMembers(config);
            }
            finally {
                cpSubsystemLogger.setLevel(cpSubsystemLevel);
            }
            if (this.env.isMicro() && (Boolean.valueOf(this.configuration.getGenerateNames()).booleanValue() || this.memberName == null)) {
                this.memberName = PayaraMicroNameGenerator.generateName();
                Set clusterMembers = this.theInstance.getCluster().getMembers();
                ArrayList<String> takenNames = new ArrayList<String>();
                for (Member member : clusterMembers) {
                    Map<String, String> attributes = this.getAttributes(member.getUuid());
                    if (member == this.theInstance.getCluster().getLocalMember() || attributes.get(INSTANCE_GROUP_ATTRIBUTE) == null || !attributes.get(INSTANCE_GROUP_ATTRIBUTE).equalsIgnoreCase(this.memberGroup)) continue;
                    takenNames.add(attributes.get(INSTANCE_ATTRIBUTE));
                }
                if (takenNames.contains(this.memberName)) {
                    this.memberName = PayaraMicroNameGenerator.generateUniqueName(takenNames, this.theInstance.getCluster().getLocalMember().getUuid());
                    this.setAttribute(this.theInstance.getCluster().getLocalMember().getUuid(), INSTANCE_ATTRIBUTE, this.memberName);
                }
            }
            this.setAttribute(this.theInstance.getCluster().getLocalMember().getUuid(), INSTANCE_ATTRIBUTE, this.memberName);
            this.setAttribute(this.theInstance.getCluster().getLocalMember().getUuid(), INSTANCE_GROUP_ATTRIBUTE, this.memberGroup);
            this.hazelcastCachingProvider = new HazelcastServerCachingProvider(this.theInstance);
            this.bindToJNDI();
            if (this.env.getStatus() == ServerEnvironment.Status.started) {
                this.events.send(new EventListener.Event(HazelcastEvents.HAZELCAST_BOOTSTRAP_COMPLETE));
            }
            this.booted = true;
        }
    }

    public String getAttribute(UUID memberUUID, String key) {
        return this.getAttributes(memberUUID).get(key);
    }

    public void setAttribute(UUID memberUUID, String key, String value) {
        IMap instanceAttributeMap = this.theInstance.getMap(INSTANCE_ATTRIBUTE_MAP);
        instanceAttributeMap.compute((Object)memberUUID, (uuid, map) -> {
            if (map == null) {
                map = new HashMap<String, String>();
            }
            map.put(INSTANCE_ATTRIBUTE, this.memberName);
            return map;
        });
    }

    public Map<String, String> getAttributes(UUID memberUUID) {
        IMap instanceAttributeMap = this.theInstance.getMap(INSTANCE_ATTRIBUTE_MAP);
        return (Map)instanceAttributeMap.getOrDefault((Object)memberUUID, Collections.unmodifiableMap(new TreeMap()));
    }

    private void bindToJNDI() {
        try {
            InitialContext ctx = new InitialContext();
            ctx.bind(this.nodeConfig.getJNDIName(), (Object)this.theInstance);
            ctx.bind(this.nodeConfig.getCachingProviderJNDIName(), (Object)this.hazelcastCachingProvider);
            ctx.bind(this.nodeConfig.getCacheManagerJNDIName(), (Object)this.hazelcastCachingProvider.getCacheManager());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "Hazelcast Instance Bound to JNDI at {0}", this.nodeConfig.getJNDIName());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "JSR107 Caching Provider Bound to JNDI at {0}", this.nodeConfig.getCachingProviderJNDIName());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "JSR107 Default Cache Manager Bound to JNDI at {0}", this.nodeConfig.getCacheManagerJNDIName());
        }
        catch (NamingException ex) {
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void unbindFromJNDI() {
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind(this.nodeConfig.getJNDIName());
            ctx.unbind(this.nodeConfig.getCacheManagerJNDIName());
            ctx.unbind(this.nodeConfig.getCachingProviderJNDIName());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "Hazelcast Instance Unbound from JNDI at {0}", this.nodeConfig.getJNDIName());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "JSR107 Caching Provider Unbound from JNDI at {0}", this.nodeConfig.getCachingProviderJNDIName());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "JSR107 Cache Manager Unbound from JNDI at {0}", this.nodeConfig.getCacheManagerJNDIName());
        }
        catch (NamingException ex) {
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public int getPort() {
        return this.theInstance.getCluster().getLocalMember().getSocketAddress().getPort();
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] pces) {
        ArrayList<UnprocessedChangeEvent> unprocessedChanges = new ArrayList<UnprocessedChangeEvent>();
        for (PropertyChangeEvent pce : pces) {
            if (!pce.getPropertyName().equalsIgnoreCase("datagrid-encryption-enabled")) continue;
            unprocessedChanges.add(new UnprocessedChangeEvent(pce, "Hazelcast encryption settings changed"));
        }
        if (unprocessedChanges.isEmpty()) {
            return null;
        }
        return new UnprocessedChangeEvents(unprocessedChanges);
    }

    public boolean isDatagridEncryptionEnabled() {
        return this.datagridEncryptionValue;
    }

    private void fillHazelcastConfigurationFromConfig(Config config, HazelcastRuntimeConfiguration configuration) {
        JoinConfig joinConfig;
        configuration.setClusterGroupName(config.getClusterName());
        configuration.setLicenseKey(config.getLicenseKey());
        if (this.env.isDas() && !this.env.isMicro()) {
            configuration.setDasPort(String.valueOf(config.getNetworkConfig().getPort()));
        } else {
            configuration.setStartPort(String.valueOf(config.getNetworkConfig().getPort()));
        }
        configuration.setAutoIncrementPort(String.valueOf(config.getNetworkConfig().isPortAutoIncrement()));
        NetworkConfig nConfig = config.getNetworkConfig();
        InterfacesConfig interfacesConfig = nConfig.getInterfaces();
        if (interfacesConfig != null) {
            configuration.setInterface(interfacesConfig.getInterfaces().stream().collect(Collectors.joining(",")));
        }
        if ((joinConfig = nConfig.getJoin()) != null) {
            KubernetesConfig kubernetesConfig;
            MulticastConfig multicastConfig;
            TcpIpConfig tConfig = joinConfig.getTcpIpConfig();
            if (tConfig != null && tConfig.isEnabled()) {
                configuration.setTcpipMembers(tConfig.getMembers().stream().collect(Collectors.joining(",")));
            }
            if ((multicastConfig = joinConfig.getMulticastConfig()) != null && multicastConfig.isEnabled()) {
                configuration.setMulticastGroup(multicastConfig.getMulticastGroup());
                configuration.setMulticastPort(String.valueOf(multicastConfig.getMulticastPort()));
            }
            if ((kubernetesConfig = joinConfig.getKubernetesConfig()) != null && kubernetesConfig.isEnabled()) {
                configuration.setKubernetesNamespace(kubernetesConfig.getProperty(KubernetesProperties.NAMESPACE.key()));
                configuration.setKubernetesServiceName(kubernetesConfig.getProperty(KubernetesProperties.SERVICE_NAME.key()));
            }
        }
    }

    private void fillSpecificHazelcastConfigFromConfig(Config config, HazelcastConfigSpecificConfiguration nodeConfig) {
        NetworkConfig nConfig = config.getNetworkConfig();
        if (nConfig.getPublicAddress() != null && !nConfig.getPublicAddress().isEmpty()) {
            nodeConfig.setPublicAddress(nConfig.getPublicAddress());
        }
        nodeConfig.setLite(String.valueOf(config.isLiteMember()));
        ExecutorConfig executorConfig = config.getExecutorConfig(CLUSTER_EXECUTOR_SERVICE_NAME);
        nodeConfig.setExecutorPoolSize(String.valueOf(executorConfig.getPoolSize()));
        nodeConfig.setExecutorQueueCapacity(String.valueOf(executorConfig.getQueueCapacity()));
        ScheduledExecutorConfig scheduledExecutorConfig = config.getScheduledExecutorConfig(SCHEDULED_CLUSTER_EXECUTOR_SERVICE_NAME);
        nodeConfig.setScheduledExecutorPoolSize(String.valueOf(scheduledExecutorConfig.getPoolSize()));
        nodeConfig.setScheduledExecutorQueueCapacity(String.valueOf(scheduledExecutorConfig.getCapacity()));
    }

    private void fillConfigurationWithDefaults() throws TransactionFailure {
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HazelcastRuntimeConfiguration>(){

            public Object run(HazelcastRuntimeConfiguration hazelcastRuntimeConfiguration) {
                hazelcastRuntimeConfiguration.setChangeToDefault("false");
                hazelcastRuntimeConfiguration.setClusterGroupName("development");
                hazelcastRuntimeConfiguration.setLicenseKey("");
                hazelcastRuntimeConfiguration.setDasPort("4900");
                hazelcastRuntimeConfiguration.setStartPort("5900");
                hazelcastRuntimeConfiguration.setAutoIncrementPort("true");
                hazelcastRuntimeConfiguration.setInterface("");
                hazelcastRuntimeConfiguration.setTcpipMembers("127.0.0.1:5900");
                hazelcastRuntimeConfiguration.setMulticastGroup("224.2.2.3");
                hazelcastRuntimeConfiguration.setMulticastPort("54327");
                hazelcastRuntimeConfiguration.setKubernetesNamespace("default");
                hazelcastRuntimeConfiguration.setKubernetesServiceName("");
                Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "Hazelcast general configuration filled with defaults");
                return null;
            }
        }, (ConfigBeanProxy)this.configuration);
        ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<HazelcastConfigSpecificConfiguration>(){

            public Object run(HazelcastConfigSpecificConfiguration hazelcastConfigSpecificConfiguration) {
                hazelcastConfigSpecificConfiguration.setPublicAddress("");
                hazelcastConfigSpecificConfiguration.setLite("false");
                hazelcastConfigSpecificConfiguration.setExecutorPoolSize("4");
                hazelcastConfigSpecificConfiguration.setExecutorQueueCapacity("20");
                hazelcastConfigSpecificConfiguration.setScheduledExecutorPoolSize("4");
                hazelcastConfigSpecificConfiguration.setScheduledExecutorQueueCapacity("20");
                Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "Hazelcast specific configuration filled with defaults");
                return null;
            }
        }, (ConfigBeanProxy)this.nodeConfig);
    }

    private void autoPromoteCPMembers(Config config) {
        String availabilityStructureName = "Payara/cluster/cp/availability";
        String waitBeforeJoinStr = config.getProperty(ClusterProperty.WAIT_SECONDS_BEFORE_JOIN.getName());
        if (waitBeforeJoinStr == null) {
            waitBeforeJoinStr = ClusterProperty.WAIT_SECONDS_BEFORE_JOIN.getDefaultValue();
        }
        final int waitBeforeJoin = Math.max(5, Integer.parseInt(waitBeforeJoinStr));
        String maxWaitBeforeJoinStr = config.getProperty(ClusterProperty.MAX_WAIT_SECONDS_BEFORE_JOIN.getName());
        if (maxWaitBeforeJoinStr == null) {
            maxWaitBeforeJoinStr = ClusterProperty.MAX_WAIT_SECONDS_BEFORE_JOIN.getDefaultValue();
        }
        int maxWaitBeforeJoin = Integer.parseInt(maxWaitBeforeJoinStr) * 10 * 2;
        if (!config.isLiteMember() && config.getCPSubsystemConfig().getCPMemberCount() > 0 && Boolean.parseBoolean(System.getProperty("hazelcast.cp-subsystem.auto-promote", "true"))) {
            this.theInstance.getCPSubsystem().addMembershipListener(new CPMembershipListener(){

                public void memberAdded(CPMembershipEvent cpMembershipEvent) {
                    HazelcastCore.this.theInstance.getMap("Payara/cluster/cp/availability").remove((Object)cpMembershipEvent.getMember().getAddress());
                }

                public void memberRemoved(CPMembershipEvent cpMembershipEvent) {
                    block3: {
                        try {
                            if (!cpMembershipEvent.getMember().equals(HazelcastCore.this.theInstance.getCPSubsystem().getCPSubsystemManagementService().getLocalCPMember())) {
                                HazelcastCore.this.theInstance.getCPSubsystem().getCPSubsystemManagementService().getCPGroup("METADATA").toCompletableFuture().get(waitBeforeJoin, TimeUnit.SECONDS);
                            }
                        }
                        catch (InterruptedException | CompletionException | ExecutionException | TimeoutException e) {
                            if (!(e.getCause() instanceof IllegalStateException)) break block3;
                            HazelcastCore.this.theInstance.getSet("Payara/cluster/cp/availability").add((Object)HazelcastCore.this.theInstance.getCluster().getLocalMember());
                        }
                    }
                }
            });
            this.theInstance.getCPSubsystem().addGroupAvailabilityListener(new CPGroupAvailabilityListener(){

                public void availabilityDecreased(CPGroupAvailabilityEvent cpGroupAvailabilityEvent) {
                    if (cpGroupAvailabilityEvent.isMetadataGroup()) {
                        IMap map = HazelcastCore.this.theInstance.getMap("Payara/cluster/cp/availability");
                        cpGroupAvailabilityEvent.getUnavailableMembers().forEach(member -> map.put((Object)member.getAddress(), (Object)member.getUuid()));
                    }
                }

                public void majorityLost(CPGroupAvailabilityEvent cpGroupAvailabilityEvent) {
                    if (cpGroupAvailabilityEvent.isMetadataGroup()) {
                        HazelcastCore.this.theInstance.getSet("Payara/cluster/cp/availability").add((Object)HazelcastCore.this.theInstance.getCluster().getLocalMember());
                    }
                }
            });
            CPSubsystemManagementService cpManagementService = this.theInstance.getCPSubsystem().getCPSubsystemManagementService();
            if (cpManagementService.isDiscoveryCompleted()) {
                Executors.newSingleThreadExecutor().submit(() -> {
                    block7: {
                        try {
                            for (int ii = 0; ii < maxWaitBeforeJoin && this.theInstance.getCluster().getClusterState() != ClusterState.ACTIVE; ++ii) {
                                TimeUnit.MILLISECONDS.sleep(100L);
                            }
                            this.sendCPResetToMaster("Payara/cluster/cp/availability", waitBeforeJoin);
                            Member localMember = this.theInstance.getCluster().getLocalMember();
                            IMap map = this.theInstance.getMap("Payara/cluster/cp/availability");
                            UUID uuid = (UUID)map.get((Object)localMember.getAddress());
                            if (uuid == null && ((Collection)cpManagementService.getCPMembers().toCompletableFuture().join()).size() >= config.getCPSubsystemConfig().getCPMemberCount()) break block7;
                            if (uuid != null) {
                                try {
                                    cpManagementService.removeCPMember(uuid).toCompletableFuture().join();
                                }
                                catch (CompletionException completionException) {
                                    // empty catch block
                                }
                                map.remove((Object)localMember.getAddress());
                            }
                            cpManagementService.promoteToCPMember();
                            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "Instance Promoted into CP Subsystem");
                        }
                        catch (HazelcastInstanceNotActiveException localMember) {
                        }
                        catch (Exception exc) {
                            if (exc.getCause() instanceof CPGroupDestroyedException) break block7;
                            Logger.getLogger(HazelcastCore.class.getName()).log(Level.WARNING, "Auto CP Promotion Failure", exc);
                        }
                    }
                });
            }
        }
    }

    private void sendCPResetToMaster(String availabilityStructureName, int waitBeforeJoin) {
        ISet cpMembersToReset = this.theInstance.getSet(availabilityStructureName);
        if (!cpMembersToReset.isEmpty()) {
            Serializable fn = (Runnable & Serializable)() -> {
                HazelcastCore.theCore.cpResetLock.lock();
                try {
                    if (HazelcastCore.theCore.lastResetTime.get().plusSeconds(waitBeforeJoin).isAfter(Instant.now())) {
                        return;
                    }
                    try {
                        HazelcastCore.theCore.theInstance.getCPSubsystem().getCPSubsystemManagementService().getCPGroup("METADATA").toCompletableFuture().get(waitBeforeJoin, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException | CompletionException | ExecutionException | TimeoutException e) {
                        HazelcastCore.theCore.theInstance.getCPSubsystem().getCPSubsystemManagementService().reset().toCompletableFuture().join();
                        HazelcastCore.theCore.lastResetTime.set(Instant.now());
                    }
                    HazelcastCore.theCore.theInstance.getSet(availabilityStructureName).clear();
                }
                catch (Exception exc) {
                    Logger.getLogger(HazelcastCore.class.getName()).log(Level.FINE, "Auto CP Reset Failure", exc);
                }
                finally {
                    HazelcastCore.theCore.cpResetLock.unlock();
                }
            };
            this.theInstance.getExecutorService(availabilityStructureName).executeOnMembers((Runnable)((Object)fn), (Collection)cpMembersToReset);
        }
    }
}

