/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.healthcheck;

import com.sun.enterprise.web.WebApplication;
import com.sun.enterprise.web.WebComponentInvocation;
import com.sun.enterprise.web.WebContainer;
import fish.payara.microprofile.healthcheck.HealthCheckType;
import fish.payara.microprofile.healthcheck.checks.PayaraHealthCheck;
import fish.payara.microprofile.healthcheck.config.MicroprofileHealthCheckConfiguration;
import fish.payara.monitoring.collect.MonitoringData;
import fish.payara.monitoring.collect.MonitoringDataCollector;
import fish.payara.monitoring.collect.MonitoringDataSource;
import fish.payara.monitoring.collect.MonitoringWatchCollector;
import fish.payara.monitoring.collect.MonitoringWatchSource;
import fish.payara.nucleus.healthcheck.configuration.Checker;
import fish.payara.nucleus.healthcheck.events.PayaraHealthCheckServiceEvents;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationException;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="healthcheck-service")
@RunLevel(value=10)
public class HealthCheckService
implements EventListener,
ConfigListener,
MonitoringDataSource,
MonitoringWatchSource {
    @Inject
    private Events events;
    @Inject
    private ApplicationRegistry applicationRegistry;
    @Inject
    private InvocationManager invocationManager;
    @Inject
    private MicroprofileHealthCheckConfiguration configuration;
    private static final Logger LOG = Logger.getLogger(HealthCheckService.class.getName());
    private final Map<String, Set<HealthCheck>> readiness = new ConcurrentHashMap<String, Set<HealthCheck>>();
    private final Map<String, Set<HealthCheck>> liveness = new ConcurrentHashMap<String, Set<HealthCheck>>();
    private final Map<String, Set<HealthCheck>> startup = new ConcurrentHashMap<String, Set<HealthCheck>>();
    private final Map<String, ClassLoader> applicationClassLoaders = new ConcurrentHashMap<String, ClassLoader>();
    private final List<String> applicationsLoaded = new CopyOnWriteArrayList<String>();
    private final AtomicReference<Map<String, Set<String>>> checksCollected = new AtomicReference();

    @PostConstruct
    public void postConstruct() {
        if (this.events == null) {
            this.events = (Events)Globals.getDefaultBaseServiceLocator().getService(Events.class, new Annotation[0]);
        }
        this.events.register((EventListener)this);
    }

    @MonitoringData(ns="health", intervalSeconds=12)
    public void collect(MonitoringDataCollector collector) {
        HashMap<String, Set<String>> collected = new HashMap<String, Set<String>>();
        Map<String, List<HealthCheckResponse>> readinessResponsesByAppName = this.collectChecks(collector, this.readiness, collected);
        Map<String, List<HealthCheckResponse>> livenessResponsesByAppName = this.collectChecks(collector, this.liveness, collected);
        Map<String, List<HealthCheckResponse>> startupResponsesByAppName = this.collectChecks(collector, this.startup, collected);
        this.checksCollected.set(collected);
        if (!collected.isEmpty()) {
            ArrayList<HealthCheckResponse> overall = new ArrayList<HealthCheckResponse>();
            overall.addAll(HealthCheckService.collectJointType(collector, "Readiness", readinessResponsesByAppName));
            overall.addAll(HealthCheckService.collectJointType(collector, "Liveness", livenessResponsesByAppName));
            overall.addAll(HealthCheckService.collectJointType(collector, "Startup", startupResponsesByAppName));
            HealthCheckService.collectUpDown(collector, HealthCheckService.computeJointState("Overall", overall));
        }
        for (String appName : collected.keySet()) {
            ArrayList<HealthCheckResponse> overallByApp = new ArrayList<HealthCheckResponse>();
            overallByApp.addAll(readinessResponsesByAppName.getOrDefault(appName, Collections.emptyList()));
            overallByApp.addAll(livenessResponsesByAppName.getOrDefault(appName, Collections.emptyList()));
            overallByApp.addAll(startupResponsesByAppName.getOrDefault(appName, Collections.emptyList()));
            HealthCheckService.collectUpDown(collector.group((CharSequence)appName), HealthCheckService.computeJointState("Overall", overallByApp));
        }
    }

    private static void collectUpDown(MonitoringDataCollector collector, HealthCheckResponse response) {
        collector.collect((CharSequence)response.getName(), response.getStatus() == HealthCheckResponse.Status.UP ? 1L : 0L);
    }

    private static List<HealthCheckResponse> collectJointType(MonitoringDataCollector collector, String type, Map<String, List<HealthCheckResponse>> healthResponsesByAppName) {
        ArrayList<HealthCheckResponse> allForType = new ArrayList<HealthCheckResponse>();
        for (Map.Entry<String, List<HealthCheckResponse>> e : healthResponsesByAppName.entrySet()) {
            HealthCheckResponse joint = HealthCheckService.computeJointState(type, (Collection<HealthCheckResponse>)e.getValue());
            HealthCheckService.collectUpDown(collector.group((CharSequence)e.getKey()), joint);
            allForType.addAll((Collection<HealthCheckResponse>)e.getValue());
        }
        HealthCheckService.collectUpDown(collector, HealthCheckService.computeJointState(type, allForType));
        return allForType;
    }

    public void collect(MonitoringWatchCollector collector) {
        Map<String, Set<String>> collected = this.checksCollected.get();
        if (collected != null) {
            for (Map.Entry<String, Set<String>> e : collected.entrySet()) {
                String appName = e.getKey();
                for (String metric : e.getValue()) {
                    HealthCheckService.addWatch(collector, appName, metric);
                }
                HealthCheckService.addWatch(collector, appName, "Readiness");
                HealthCheckService.addWatch(collector, appName, "Liveness");
                HealthCheckService.addWatch(collector, appName, "Startup");
                HealthCheckService.addWatch(collector, appName, "Health");
            }
            if (!collected.isEmpty()) {
                HealthCheckService.addWatch(collector, null, "Readiness");
                HealthCheckService.addWatch(collector, null, "Liveness");
                HealthCheckService.addWatch(collector, null, "Startup");
                HealthCheckService.addWatch(collector, null, "Health");
            }
        }
    }

    private static void addWatch(MonitoringWatchCollector collector, String appName, String metric) {
        String series = appName == null ? "ns:health " + metric : "ns:health @:" + appName + " " + metric;
        String watchName = "RAG " + metric + (String)(appName == null ? "" : " @" + appName);
        collector.watch((CharSequence)series, watchName, "updown").red(-1L, (Number)5, false, null, (Number)1, false).amber(-1L, (Number)1, false, null, (Number)1, false).green(1L, (Number)1, false, null, (Number)1, false);
    }

    private Map<String, List<HealthCheckResponse>> collectChecks(MonitoringDataCollector collector, Map<String, Set<HealthCheck>> checks, Map<String, Set<String>> collected) {
        HashMap<String, List<HealthCheckResponse>> statusByApp = new HashMap<String, List<HealthCheckResponse>>();
        for (Map.Entry<String, Set<HealthCheck>> entry : checks.entrySet()) {
            String appName = entry.getKey();
            MonitoringDataCollector appCollector = collector.group((CharSequence)appName);
            for (HealthCheck check : entry.getValue()) {
                HealthCheckResponse response = this.performHealthCheckInApplicationContext(appName, check);
                String metric = response.getName();
                Set<String> appCollected = collected.get(appName);
                if (appCollected != null && appCollected.contains(metric)) continue;
                statusByApp.computeIfAbsent(appName, key -> new ArrayList()).add(response);
                HealthCheckService.collectUpDown(appCollector, response);
                if (response.getStatus() == HealthCheckResponse.Status.DOWN && response.getData().isPresent()) {
                    appCollector.annotate((CharSequence)metric, 0L, HealthCheckService.createAnnotation(response.getData().get()));
                }
                collected.computeIfAbsent(appName, key -> new HashSet()).add(metric);
            }
        }
        return statusByApp;
    }

    private static HealthCheckResponse computeJointState(String name, Collection<HealthCheckResponse> responses) {
        long ups = responses.stream().filter(response -> response.getStatus() == HealthCheckResponse.Status.UP).count();
        if (ups == (long)responses.size()) {
            return HealthCheckResponse.up(name);
        }
        String upNames = responses.stream().filter(r -> r.getStatus() == HealthCheckResponse.Status.UP).map(r -> r.getName()).collect(Collectors.joining(","));
        String downNames = responses.stream().filter(r -> r.getStatus() == HealthCheckResponse.Status.DOWN).map(r -> r.getName()).collect(Collectors.joining(","));
        return HealthCheckResponse.named(name).down().withData("up", upNames).withData("down", downNames).build();
    }

    private static String[] createAnnotation(Map<String, Object> data) {
        ArrayList<String> attrs = new ArrayList<String>();
        for (Map.Entry<String, Object> e : data.entrySet()) {
            Object value = e.getValue();
            if (!(value instanceof String) && !(value instanceof Number) && !(value instanceof Boolean)) continue;
            attrs.add(e.getKey());
            attrs.add(value.toString());
        }
        return attrs.toArray(new String[0]);
    }

    public void event(EventListener.Event<?> event) {
        Deployment.APPLICATION_UNLOADED.onMatch(event, appInfo -> this.unregisterHealthCheck(appInfo.getName()));
        Deployment.APPLICATION_STARTED.onMatch(event, appInfo -> this.applicationsLoaded.add(appInfo.getName()));
        PayaraHealthCheckServiceEvents.HEALTHCHECK_SERVICE_CHECKER_ADD_TO_MICROPROFILE_HEALTH.onMatch(event, healthChecker -> this.registerHealthCheck(healthChecker.getName(), new PayaraHealthCheck(healthChecker.getName(), healthChecker.getCheck()), HealthCheckType.READINESS));
        PayaraHealthCheckServiceEvents.HEALTHCHECK_SERVICE_CHECKER_REMOVE_FROM_MICROPROFILE_HEALTH.onMatch(event, healthChecker -> this.unregisterHealthCheck(healthChecker.getName()));
        if (event.is(PayaraHealthCheckServiceEvents.HEALTHCHECK_SERVICE_DISABLED)) {
            for (Checker checker : this.getHealthCheckerList()) {
                if (!Boolean.valueOf(checker.getAddToMicroProfileHealth()).booleanValue()) continue;
                this.unregisterHealthCheck(checker.getName());
            }
        }
    }

    private List<Checker> getHealthCheckerList() {
        fish.payara.nucleus.healthcheck.HealthCheckService payaraHealthCheckService = (fish.payara.nucleus.healthcheck.HealthCheckService)Globals.getDefaultBaseServiceLocator().getService(fish.payara.nucleus.healthcheck.HealthCheckService.class, new Annotation[0]);
        return payaraHealthCheckService.getConfiguration().getCheckerList();
    }

    public boolean isEnabled() {
        return Boolean.parseBoolean(this.configuration.getEnabled());
    }

    public boolean isSecurityEnabled() {
        return Boolean.parseBoolean(this.configuration.getSecurityEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHealthCheck(String healthCheckName, HealthCheck healthCheck, HealthCheckType type) {
        Map<String, Set<HealthCheck>> healthChecks = this.getHealthChecks(type);
        if (!healthChecks.containsKey(healthCheckName)) {
            HealthCheckService healthCheckService = this;
            synchronized (healthCheckService) {
                if (!healthChecks.containsKey(healthCheckName)) {
                    healthChecks.put(healthCheckName, ConcurrentHashMap.newKeySet());
                }
            }
        }
        healthChecks.get(healthCheckName).add(healthCheck);
    }

    public void unregisterHealthCheck(String appName) {
        this.readiness.remove(appName);
        this.liveness.remove(appName);
        this.startup.remove(appName);
        this.applicationClassLoaders.remove(appName);
        this.applicationsLoaded.remove(appName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClassLoader(String appName, ClassLoader classloader) {
        if (!this.applicationClassLoaders.containsKey(appName)) {
            HealthCheckService healthCheckService = this;
            synchronized (healthCheckService) {
                if (!this.applicationClassLoaders.containsKey(appName)) {
                    this.applicationClassLoaders.put(appName, classloader);
                }
            }
        }
    }

    private Map<String, Set<HealthCheck>> getHealthChecks(HealthCheckType type) {
        if (type == null) {
            type = HealthCheckType.UNKNOWN;
        }
        switch (type) {
            case LIVENESS: {
                return this.liveness;
            }
            case READINESS: {
                return this.readiness;
            }
            case STARTUP: {
                return this.startup;
            }
        }
        LOG.warning("Unrecognised HealthCheckType: " + type);
        return new HashMap<String, Set<HealthCheck>>();
    }

    private Map<String, Set<HealthCheck>> getCollectiveHealthChecks(HealthCheckType type) {
        Map<String, Set<HealthCheck>> healthChecks;
        if (type == HealthCheckType.READINESS) {
            healthChecks = this.readiness;
        } else if (type == HealthCheckType.LIVENESS) {
            healthChecks = this.liveness;
        } else if (type == HealthCheckType.STARTUP) {
            healthChecks = this.startup;
        } else {
            healthChecks = this.readiness.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> new HashSet((Collection)entry.getValue())));
            BiConsumer<String, Set> mergeHealthCheckMap = (key, value) -> healthChecks.merge((String)key, (Set<HealthCheck>)value, (oldValue, newValue) -> {
                oldValue.addAll(newValue);
                return oldValue;
            });
            this.liveness.forEach(mergeHealthCheckMap);
            this.startup.forEach(mergeHealthCheckMap);
        }
        return healthChecks;
    }

    public void performHealthChecks(HttpServletResponse response, HealthCheckType type, String enablePrettyPrint) throws IOException {
        HashSet<HealthCheckResponse> healthCheckResponses = new HashSet<HealthCheckResponse>();
        for (Map.Entry<String, Set<HealthCheck>> healthChecksEntry : this.getCollectiveHealthChecks(type).entrySet()) {
            for (HealthCheck healthCheck : healthChecksEntry.getValue()) {
                try {
                    healthCheckResponses.add(healthCheck.call());
                }
                catch (IllegalStateException ise) {
                    ApplicationInfo appInfo = this.applicationRegistry.get(healthChecksEntry.getKey());
                    if (!this.createWebComponentInvocation(appInfo).isPresent()) continue;
                    healthCheckResponses.add(this.performHealthCheckInApplicationContext(healthChecksEntry.getKey(), healthCheck));
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "Exception executing HealthCheck : " + healthCheck.getClass().getCanonicalName(), ex);
                    response.setStatus(500);
                }
            }
        }
        if (this.applicationsLoaded.isEmpty()) {
            healthCheckResponses.add(HealthCheckResponse.builder().name("No Application deployed").down().build());
        }
        if (response.getStatus() != 500) {
            this.constructResponse(response, healthCheckResponses, type, enablePrettyPrint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HealthCheckResponse performHealthCheckInApplicationContext(String appName, HealthCheck healthCheck) {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        Optional<Object> wciOpt = Optional.empty();
        try {
            ApplicationInfo appInfo = this.applicationRegistry.get(appName);
            currentThread.setContextClassLoader(appInfo.getAppClassLoader());
            wciOpt = this.createWebComponentInvocation(appInfo);
            wciOpt.ifPresent(wci -> this.invocationManager.preInvoke((ComponentInvocation)wci));
            HealthCheckResponse healthCheckResponse = healthCheck.call();
            return healthCheckResponse;
        }
        finally {
            wciOpt.ifPresent(wci -> this.invocationManager.postInvoke((ComponentInvocation)wci));
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    private Optional<WebComponentInvocation> createWebComponentInvocation(ApplicationInfo appInfo) throws InvocationException {
        return appInfo.getModuleInfos().stream().map(mi -> mi.getEngineRefForContainer(WebContainer.class)).filter(engineRef -> engineRef != null).flatMap(engineRef -> ((WebApplication)engineRef.getApplicationContainer()).getWebModules().stream()).findFirst().map(wm -> new WebComponentInvocation(wm));
    }

    private void constructResponse(HttpServletResponse httpResponse, Set<HealthCheckResponse> healthCheckResponses, HealthCheckType type, String enablePrettyPrint) throws IOException {
        httpResponse.setContentType("application/json");
        JsonArrayBuilder checksArray = Json.createArrayBuilder();
        for (HealthCheckResponse healthCheckResponse : healthCheckResponses) {
            JsonObjectBuilder healthCheckObject = Json.createObjectBuilder();
            healthCheckObject.add("name", healthCheckResponse.getName());
            healthCheckObject.add("status", healthCheckResponse.getStatus().toString());
            JsonObjectBuilder healthCheckData = Json.createObjectBuilder();
            if (healthCheckResponse.getData().isPresent() && !healthCheckResponse.getData().get().isEmpty()) {
                for (Map.Entry<String, Object> dataMapEntry : healthCheckResponse.getData().get().entrySet()) {
                    healthCheckData.add(dataMapEntry.getKey(), dataMapEntry.getValue().toString());
                }
            }
            healthCheckObject.add("data", healthCheckData);
            checksArray.add(healthCheckObject);
            if (httpResponse.getStatus() != 200 || !healthCheckResponse.getStatus().equals((Object)HealthCheckResponse.Status.DOWN)) continue;
            httpResponse.setStatus(503);
        }
        JsonObjectBuilder responseObject = Json.createObjectBuilder();
        responseObject.add("status", httpResponse.getStatus() == 200 ? "UP" : "DOWN");
        responseObject.add("checks", checksArray);
        String prettyPrinting = enablePrettyPrint == null || enablePrettyPrint.equals("false") ? "" : "jakarta.json.stream.JsonGenerator.prettyPrinting";
        JsonWriterFactory jsonWriterFactory = Json.createWriterFactory(Collections.singletonMap(prettyPrinting, ""));
        StringWriter stringWriter = new StringWriter();
        try (JsonWriter jsonWriter = jsonWriterFactory.createWriter((Writer)stringWriter);){
            jsonWriter.writeObject(responseObject.build());
        }
        httpResponse.getOutputStream().print(stringWriter.toString());
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        ArrayList<UnprocessedChangeEvent> unchangedList = new ArrayList<UnprocessedChangeEvent>();
        for (PropertyChangeEvent event : events) {
            unchangedList.add(new UnprocessedChangeEvent(event, "Microprofile HealthCheck configuration changed:" + event.getPropertyName() + " was changed from " + event.getOldValue().toString() + " to " + event.getNewValue().toString()));
        }
        return new UnprocessedChangeEvents(unchangedList);
    }
}

