/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ConfiguratorImpl;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import java.lang.annotation.Annotation;
import java.util.Properties;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.hk2.api.ServiceLocator;

public class GlassFishImpl
implements GlassFish {
    public static final String PAYARA_SHUTDOWNGRACE_PROPERTY = "fish.payara.shutdowngrace";
    private ModuleStartup gfKernel;
    private ServiceLocator habitat;
    volatile GlassFish.Status status = GlassFish.Status.INIT;

    public GlassFishImpl(ModuleStartup gfKernel, ServiceLocator habitat, Properties gfProps) throws GlassFishException {
        this.gfKernel = gfKernel;
        this.habitat = habitat;
        this.configure(gfProps);
    }

    private void configure(Properties gfProps) throws GlassFishException {
        ConfiguratorImpl configurator = new ConfiguratorImpl(this.habitat);
        configurator.configure(gfProps);
    }

    @Override
    public synchronized void start() throws GlassFishException {
        if (this.status == GlassFish.Status.STARTED || this.status == GlassFish.Status.STARTING || this.status == GlassFish.Status.DISPOSED) {
            throw new IllegalStateException("Already in " + this.status + " state.");
        }
        this.status = GlassFish.Status.STARTING;
        try {
            this.gfKernel.start();
        }
        catch (Error | RuntimeException t) {
            this.dispose();
            if (t.getCause() instanceof GlassFishException) {
                throw (GlassFishException)t.getCause();
            }
            throw t;
        }
        this.status = GlassFish.Status.STARTED;
    }

    @Override
    public synchronized void stop() throws GlassFishException {
        if (this.status == GlassFish.Status.STOPPED || this.status == GlassFish.Status.STOPPING || this.status == GlassFish.Status.DISPOSED) {
            throw new IllegalStateException("Already in " + this.status + " state.");
        }
        this.status = GlassFish.Status.STOPPING;
        GlassFishImpl.sleepShutdownGracePeriod();
        this.gfKernel.stop();
        this.status = GlassFish.Status.STOPPED;
    }

    public static void sleepShutdownGracePeriod() {
        String shutdowngrace = System.getProperty(PAYARA_SHUTDOWNGRACE_PROPERTY);
        if (shutdowngrace != null) {
            try {
                Thread.sleep(Integer.parseInt(shutdowngrace));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void dispose() throws GlassFishException {
        if (this.status == GlassFish.Status.DISPOSED) {
            throw new IllegalStateException("Already disposed.");
        }
        if (this.status != GlassFish.Status.STOPPED) {
            try {
                this.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.gfKernel = null;
        this.habitat = null;
        this.status = GlassFish.Status.DISPOSED;
    }

    @Override
    public GlassFish.Status getStatus() {
        return this.status;
    }

    @Override
    public <T> T getService(Class<T> serviceType) throws GlassFishException {
        return this.getService(serviceType, null);
    }

    @Override
    public synchronized <T> T getService(Class<T> serviceType, String serviceName) throws GlassFishException {
        if (this.status != GlassFish.Status.STARTED) {
            throw new IllegalArgumentException("Server is not started yet. It is in " + this.status + "state");
        }
        return (T)(serviceName != null ? this.habitat.getService(serviceType, serviceName, new Annotation[0]) : this.habitat.getService(serviceType, new Annotation[0]));
    }

    @Override
    public Deployer getDeployer() throws GlassFishException {
        return this.getService(Deployer.class);
    }

    @Override
    public CommandRunner getCommandRunner() throws GlassFishException {
        return (CommandRunner)this.habitat.getService(CommandRunner.class, new Annotation[0]);
    }
}

