/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.embeddable;

import java.util.Objects;
import java.util.Properties;

public class GlassFishProperties {
    private Properties gfProperties;
    private static final String INSTANCE_ROOT_PROP_NAME = "com.sun.aas.instanceRoot";
    private static final String CONFIG_FILE_URI_PROP_NAME = "org.glassfish.embeddable.configFileURI";
    private static final String CONFIG_FILE_READ_ONLY = "org.glassfish.embeddable.configFileReadOnly";
    private static final String NETWORK_LISTENER_KEY = "embedded-glassfish-config.server.network-config.network-listeners.network-listener.%s";

    public GlassFishProperties() {
        this.gfProperties = new Properties();
    }

    public GlassFishProperties(Properties props) {
        Objects.requireNonNull(props, "Properties parameter cannot be null");
        this.gfProperties = props;
    }

    public Properties getProperties() {
        return this.gfProperties;
    }

    public void setProperty(String key, String value) {
        this.gfProperties.setProperty(key, value);
    }

    public void setInstanceRoot(String instanceRoot) {
        this.gfProperties.setProperty(INSTANCE_ROOT_PROP_NAME, instanceRoot);
    }

    public String getInstanceRoot() {
        return this.gfProperties.getProperty(INSTANCE_ROOT_PROP_NAME);
    }

    public void setConfigFileURI(String configFileURI) {
        this.gfProperties.setProperty(CONFIG_FILE_URI_PROP_NAME, configFileURI);
    }

    public String getConfigFileURI() {
        return this.gfProperties.getProperty(CONFIG_FILE_URI_PROP_NAME);
    }

    public boolean isConfigFileReadOnly() {
        return Boolean.valueOf(this.gfProperties.getProperty(CONFIG_FILE_READ_ONLY, "true"));
    }

    public void setConfigFileReadOnly(boolean readOnly) {
        this.gfProperties.setProperty(CONFIG_FILE_READ_ONLY, Boolean.toString(readOnly));
    }

    public void setPort(String networkListener, int port) {
        String key;
        if (networkListener != null && (key = String.format(NETWORK_LISTENER_KEY, networkListener)) != null) {
            this.gfProperties.setProperty(key + ".port", Integer.toString(port));
            this.gfProperties.setProperty(key + ".enabled", "true");
        }
    }

    public int getPort(String networkListener) {
        String key;
        int port = -1;
        if (networkListener != null && (key = String.format(NETWORK_LISTENER_KEY, networkListener)) != null) {
            String portStr = this.gfProperties.getProperty(key + ".port");
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return port;
    }
}

