/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.controller;

import fish.payara.security.annotations.ClaimsDefinition;
import fish.payara.security.annotations.LogoutDefinition;
import fish.payara.security.annotations.OpenIdAuthenticationDefinition;
import fish.payara.security.annotations.ProxyDefinition;
import fish.payara.security.openid.OpenIdAuthenticationException;
import fish.payara.security.openid.OpenIdUtil;
import fish.payara.security.openid.api.OpenIdConstant;
import fish.payara.security.openid.controller.CacheKey;
import fish.payara.security.openid.controller.ProviderMetadataContoller;
import fish.payara.security.openid.domain.ClaimsConfiguration;
import fish.payara.security.openid.domain.LogoutConfiguration;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import fish.payara.security.openid.domain.OpenIdProviderMetadata;
import fish.payara.security.openid.domain.OpenIdTokenEncryptionMetadata;
import fish.payara.security.openid.domain.ProxyConfiguration;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.json.JsonObject;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@ApplicationScoped
public class ConfigurationController
implements Serializable {
    @Inject
    private ProviderMetadataContoller providerMetadataContoller;
    private static final String SPACE_SEPARATOR = " ";
    private volatile transient LastBuiltConfig lastBuiltConfig;

    @Produces
    @RequestScoped
    public OpenIdConfiguration produceConfiguration(OpenIdAuthenticationDefinition definition) {
        OpenIdConfiguration cached;
        if (this.lastBuiltConfig == null) {
            this.lastBuiltConfig = new LastBuiltConfig(null, null);
        }
        if ((cached = this.lastBuiltConfig.cachedConfiguration(definition)) != null) {
            return cached;
        }
        OpenIdConfiguration config = this.buildConfig(definition);
        this.lastBuiltConfig = new LastBuiltConfig(definition, config);
        return config;
    }

    public OpenIdConfiguration buildConfig(OpenIdAuthenticationDefinition definition) {
        URL jwksURL;
        Config provider = ConfigProvider.getConfig();
        String providerURI = OpenIdUtil.getConfiguredValue(String.class, definition.providerURI(), provider, "payara.security.openid.providerURI");
        fish.payara.security.annotations.OpenIdProviderMetadata providerMetadata = definition.providerMetadata();
        JsonObject providerDocument = this.providerMetadataContoller.getDocument(providerURI);
        String issuerURI = OpenIdUtil.readConfiguredValueFromMetadataOrProvider(providerMetadata.issuer(), providerDocument, "issuer", provider, "payara.security.openid.provider.issuer");
        if (issuerURI == null || issuerURI.isEmpty()) {
            throw new OpenIdAuthenticationException("issuer URL is not available, specify it either in @OpenIdProviderMetadata or by providerURI and autoconfiguration");
        }
        String authorizationEndpoint = OpenIdUtil.readConfiguredValueFromMetadataOrProvider(providerMetadata.authorizationEndpoint(), providerDocument, "authorization_endpoint", provider, "payara.security.openid.provider.authorizationEndpoint");
        String tokenEndpoint = OpenIdUtil.readConfiguredValueFromMetadataOrProvider(providerMetadata.tokenEndpoint(), providerDocument, "token_endpoint", provider, "payara.security.openid.provider.tokenEndpoint");
        String userinfoEndpoint = OpenIdUtil.readConfiguredValueFromMetadataOrProvider(providerMetadata.userinfoEndpoint(), providerDocument, "userinfo_endpoint", provider, "payara.security.openid.provider.userinfoEndpoint");
        String endSessionEndpoint = OpenIdUtil.readConfiguredValueFromMetadataOrProvider(providerMetadata.endSessionEndpoint(), providerDocument, "end_session_endpoint", provider, "payara.security.openid.provider.endSessionEndpoint");
        String jwksURI = OpenIdUtil.readConfiguredValueFromMetadataOrProvider(providerMetadata.jwksURI(), providerDocument, "jwks_uri", provider, "payara.security.openid.provider.jwksURI");
        try {
            jwksURL = new URL(jwksURI);
        }
        catch (MalformedURLException ex) {
            throw new OpenIdAuthenticationException("jwksURI is not a valid URL: " + jwksURI, ex);
        }
        Set<String> scopesSupported = OpenIdUtil.readConfiguredValueFromMetadataOrProvider(providerMetadata.scopesSupported(), providerDocument, "scopes_supported", provider, "payara.security.openid.provider.scopesSupported");
        Set<String> responseTypesSupported = OpenIdUtil.readConfiguredValueFromMetadataOrProvider(providerMetadata.responseTypesSupported(), providerDocument, "response_types_supported", provider, "payara.security.openid.provider.responseTypesSupported");
        Set<String> subjectTypesSupported = OpenIdUtil.readConfiguredValueFromMetadataOrProvider(providerMetadata.subjectTypesSupported(), providerDocument, "subject_types_supported", provider, "payara.security.openid.provider.subjectTypesSupported");
        Set<String> idTokenSigningAlgValuesSupported = OpenIdUtil.readConfiguredValueFromMetadataOrProvider(providerMetadata.idTokenSigningAlgValuesSupported(), providerDocument, "id_token_signing_alg_values_supported", provider, "payara.security.openid.provider.idTokenSigningAlgValuesSupported");
        Set<String> idTokenEncryptionAlgValuesSupported = OpenIdUtil.readConfiguredValueFromMetadataOrProvider(providerMetadata.idTokenEncryptionAlgValuesSupported(), providerDocument, "id_token_encryption_alg_values_supported", provider, "payara.security.openid.provider.idTokenEncryptionAlgValuesSupported");
        Set<String> idTokenEncryptionEncValuesSupported = OpenIdUtil.readConfiguredValueFromMetadataOrProvider(providerMetadata.idTokenEncryptionEncValuesSupported(), providerDocument, "id_token_encryption_enc_values_supported", provider, "payara.security.openid.provider.idTokenEncryptionEncValuesSupported");
        Set<String> claimsSupported = OpenIdUtil.readConfiguredValueFromMetadataOrProvider(providerMetadata.claimsSupported(), providerDocument, "claims_supported", provider, "payara.security.openid.provider.claimsSupported");
        String clientId = OpenIdUtil.getConfiguredValue(String.class, definition.clientId(), provider, "payara.security.openid.clientId");
        char[] clientSecret = OpenIdUtil.getConfiguredValue(String.class, definition.clientSecret(), provider, "payara.security.openid.clientSecret").toCharArray();
        String redirectURI = OpenIdUtil.getConfiguredValue(String.class, definition.redirectURI(), provider, "payara.security.openid.redirectURI");
        Object scopes = Arrays.stream(definition.scope()).collect(Collectors.joining(SPACE_SEPARATOR));
        scopes = OpenIdUtil.getConfiguredValue(String.class, scopes, provider, "payara.security.openid.scope");
        if (OpenIdUtil.isEmpty((String)scopes)) {
            scopes = "openid";
        } else if (!((String)scopes).contains("openid")) {
            scopes = "openid " + (String)scopes;
        }
        String responseType = OpenIdUtil.getConfiguredValue(String.class, definition.responseType(), provider, "payara.security.openid.responseType");
        responseType = Arrays.stream(responseType.trim().split(SPACE_SEPARATOR)).map(String::toLowerCase).sorted().collect(Collectors.joining(SPACE_SEPARATOR));
        String responseMode = OpenIdUtil.getConfiguredValue(String.class, definition.responseMode(), provider, "payara.security.openid.responseMode");
        String display = definition.display().toString().toLowerCase();
        display = OpenIdUtil.getConfiguredValue(String.class, display, provider, "payara.security.openid.display");
        String prompt = Arrays.stream(definition.prompt()).map(Enum::toString).map(String::toLowerCase).collect(Collectors.joining(SPACE_SEPARATOR));
        prompt = OpenIdUtil.getConfiguredValue(String.class, prompt, provider, "payara.security.openid.prompt");
        String extraParametersFromAnnotation = ConfigurationController.createUrlQuery("extraParameters", definition.extraParameters());
        boolean useNonce = OpenIdUtil.getConfiguredValue(Boolean.class, definition.useNonce(), provider, "payara.security.openid.useNonce");
        boolean useSession = OpenIdUtil.getConfiguredValue(Boolean.class, definition.useSession(), provider, "payara.security.openid.useSession");
        int jwksConnectTimeout = OpenIdUtil.getConfiguredValue(Integer.class, definition.jwksConnectTimeout(), provider, "payara.security.openid.jwks.connect.timeout");
        int jwksReadTimeout = OpenIdUtil.getConfiguredValue(Integer.class, definition.jwksReadTimeout(), provider, "payara.security.openid.jwks.read.timeout");
        String encryptionAlgorithm = provider.getOptionalValue("payara.security.openid.client.encryption.algorithm", String.class).orElse(null);
        String encryptionMethod = provider.getOptionalValue("payara.security.openid.client.encryption.method", String.class).orElse(null);
        String privateKeyJWKS = provider.getOptionalValue("payara.security.openid.client.encryption.jwks", String.class).orElse(null);
        String callerNameClaim = OpenIdUtil.getConfiguredValue(String.class, definition.claimsDefinition().callerNameClaim(), provider, "payara.security.openid.callerNameClaim");
        String callerGroupsClaim = OpenIdUtil.getConfiguredValue(String.class, definition.claimsDefinition().callerGroupsClaim(), provider, "payara.security.openid.callerGroupsClaim");
        String proxyHostName = OpenIdUtil.getConfiguredValue(String.class, definition.proxyDefinition().hostName(), provider, "payara.security.openid.proxyHostname");
        String proxyPort = OpenIdUtil.getConfiguredValue(String.class, definition.proxyDefinition().port(), provider, "payara.security.openid.proxyPort");
        Boolean notifyProvider = OpenIdUtil.getConfiguredValue(Boolean.class, definition.logout().notifyProvider(), provider, "payara.security.openid.provider.notify.logout");
        String logoutRedirectURI = OpenIdUtil.getConfiguredValue(String.class, definition.logout().redirectURI(), provider, "payara.security.openid.logout.redirectURI");
        Boolean accessTokenExpiry = OpenIdUtil.getConfiguredValue(Boolean.class, definition.logout().accessTokenExpiry(), provider, "payara.security.openid.logout.access.token.expiry");
        Boolean identityTokenExpiry = OpenIdUtil.getConfiguredValue(Boolean.class, definition.logout().identityTokenExpiry(), provider, "payara.security.openid.logout.identity.token.expiry");
        boolean tokenAutoRefresh = OpenIdUtil.getConfiguredValue(Boolean.class, definition.tokenAutoRefresh(), provider, "payara.security.openid.token.autoRefresh");
        int tokenMinValidity = OpenIdUtil.getConfiguredValue(Integer.class, definition.tokenMinValidity(), provider, "payara.security.openid.token.minValidity");
        boolean userClaimsFromIDToken = OpenIdUtil.getConfiguredValue(Boolean.class, definition.userClaimsFromIDToken(), provider, "payara.security.openid.userClaimsFromIDToken");
        String extraParamsRaw = OpenIdUtil.getConfiguredValue(String.class, extraParametersFromAnnotation, provider, "payara.security.openid.extraParams.raw");
        Map<String, List<String>> extraParameters = ConfigurationController.parseMultiMapFromUrlQuery(extraParamsRaw);
        boolean disableScopeValidation = OpenIdUtil.getConfiguredValue(Boolean.class, providerMetadata.disableScopeValidation(), provider, "payara.security.openid.disableScopeValidation");
        String accessTokenIssuerURI = OpenIdUtil.getConfiguredValue(String.class, providerMetadata.accessTokenIssuer(), provider, "payara.security.openid.provider.accessTokenIssuer");
        OpenIdProviderMetadata openIdProviderMetadata = new OpenIdProviderMetadata(providerDocument, issuerURI, scopesSupported, claimsSupported, responseTypesSupported, idTokenSigningAlgValuesSupported, idTokenEncryptionAlgValuesSupported, idTokenEncryptionEncValuesSupported, subjectTypesSupported).setAuthorizationEndpoint(authorizationEndpoint).setTokenEndpoint(tokenEndpoint).setUserinfoEndpoint(userinfoEndpoint).setEndSessionEndpoint(endSessionEndpoint).setJwksURL(jwksURL).setAccessTokenIssuerURI(accessTokenIssuerURI);
        OpenIdConfiguration configuration = new OpenIdConfiguration().setProviderMetadata(openIdProviderMetadata).setClaimsConfiguration(new ClaimsConfiguration().setCallerNameClaim(callerNameClaim).setCallerGroupsClaim(callerGroupsClaim)).setProxyConfiguration(new ProxyConfiguration().setHostName(proxyHostName).setPort(proxyPort)).setLogoutConfiguration(new LogoutConfiguration().setNotifyProvider(notifyProvider).setRedirectURI(logoutRedirectURI).setAccessTokenExpiry(accessTokenExpiry).setIdentityTokenExpiry(identityTokenExpiry)).setEncryptionMetadata(new OpenIdTokenEncryptionMetadata().setEncryptionAlgorithm(encryptionAlgorithm).setEncryptionMethod(encryptionMethod).setPrivateKeySource(privateKeyJWKS)).setClientId(clientId).setClientSecret(clientSecret).setRedirectURI(redirectURI).setScopes((String)scopes).setResponseType(responseType).setResponseMode(responseMode).setExtraParameters(extraParameters).setPrompt(prompt).setDisplay(display).setUseNonce(useNonce).setUseSession(useSession).setJwksConnectTimeout(jwksConnectTimeout).setJwksReadTimeout(jwksReadTimeout).setTokenAutoRefresh(tokenAutoRefresh).setTokenMinValidity(tokenMinValidity).setUserClaimsFromIDToken(userClaimsFromIDToken).setDisableScopeValidation(disableScopeValidation);
        this.validateConfiguration(configuration);
        return configuration;
    }

    private void validateConfiguration(OpenIdConfiguration configuration) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        errorMessages.addAll(this.validateProviderMetadata(configuration));
        errorMessages.addAll(this.validateClientConfiguration(configuration));
        if (!errorMessages.isEmpty()) {
            throw new OpenIdAuthenticationException(((Object)errorMessages).toString());
        }
    }

    private List<String> validateProviderMetadata(OpenIdConfiguration configuration) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        String issuerURI = configuration.getProviderMetadata().getIssuerURI();
        if (OpenIdUtil.isEmpty(issuerURI)) {
            errorMessages.add("issuer metadata is mandatory");
        }
        try {
            new URL(issuerURI);
        }
        catch (MalformedURLException ex) {
            errorMessages.add("issuer metadata is not a valid URL: " + ex.getMessage());
        }
        if (OpenIdUtil.isEmpty(configuration.getProviderMetadata().getAuthorizationEndpoint())) {
            errorMessages.add("authorization_endpoint metadata is mandatory");
        }
        if (OpenIdUtil.isEmpty(configuration.getProviderMetadata().getTokenEndpoint())) {
            errorMessages.add("token_endpoint metadata is mandatory");
        }
        if (configuration.getProviderMetadata().getJwksURL() == null) {
            errorMessages.add("jwks_uri metadata is mandatory");
        }
        if (configuration.getProviderMetadata().getResponseTypesSupported().isEmpty()) {
            errorMessages.add("response_types_supported metadata is mandatory");
        }
        if (configuration.getProviderMetadata().getIdTokenSigningAlgValuesSupported().isEmpty()) {
            errorMessages.add("id_token_signing_alg_values_supported metadata is mandatory");
        }
        return errorMessages;
    }

    private List<String> validateClientConfiguration(OpenIdConfiguration configuration) {
        Set<String> supportedScopes;
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (OpenIdUtil.isEmpty(configuration.getClientId())) {
            errorMessages.add("client_id request parameter is mandatory");
        }
        if (OpenIdUtil.isEmpty(configuration.getRedirectURI())) {
            errorMessages.add("redirect_uri request parameter is mandatory");
        }
        if (configuration.getJwksConnectTimeout() <= 0) {
            errorMessages.add("jwksConnectTimeout value is not valid");
        }
        if (configuration.getJwksReadTimeout() <= 0) {
            errorMessages.add("jwksReadTimeout value is not valid");
        }
        if (OpenIdUtil.isEmpty(configuration.getResponseType())) {
            errorMessages.add("The response type must contain at least one value");
        } else if (!(configuration.getProviderMetadata().getResponseTypesSupported().contains(configuration.getResponseType()) || OpenIdConstant.AUTHORIZATION_CODE_FLOW_TYPES.contains(configuration.getResponseType()) || OpenIdConstant.IMPLICIT_FLOW_TYPES.contains(configuration.getResponseType()) || OpenIdConstant.HYBRID_FLOW_TYPES.contains(configuration.getResponseType()))) {
            errorMessages.add("Unsupported OpenID Connect response type value : " + configuration.getResponseType());
        }
        if (!configuration.isDisableScopeValidation() && !(supportedScopes = configuration.getProviderMetadata().getScopesSupported()).isEmpty()) {
            for (String scope : configuration.getScopes().split(SPACE_SEPARATOR)) {
                if (supportedScopes.contains(scope)) continue;
                errorMessages.add(String.format("%s scope is not supported by %s OpenId Connect provider", scope, configuration.getProviderMetadata().getIssuerURI()));
            }
        }
        return errorMessages;
    }

    public static String createUrlQuery(String paramsName, String[] parameters) {
        StringBuilder extraParametersFromAnnotationBuf = new StringBuilder();
        String extraParamDelim = "";
        for (String extraParameter : parameters) {
            String[] parts = extraParameter.split("=");
            if (parts.length == 0 || parts[0].length() == 0) {
                throw new OpenIdAuthenticationException(paramsName + " contain parameter without key: '" + extraParameter + "', expected format: key=value");
            }
            String key = parts[0];
            String value = parts.length > 1 ? parts[1] : null;
            try {
                extraParametersFromAnnotationBuf.append(extraParamDelim).append(URLEncoder.encode(key, "UTF-8"));
                if (value != null) {
                    extraParametersFromAnnotationBuf.append("=").append(URLEncoder.encode(value, "UTF-8"));
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new OpenIdAuthenticationException("UTF-8 is no more supported");
            }
            extraParamDelim = "&";
        }
        return extraParametersFromAnnotationBuf.toString();
    }

    public static Map<String, List<String>> parseMultiMapFromUrlQuery(String query) {
        String[] pairs;
        LinkedHashMap<String, List<String>> multiMap = new LinkedHashMap<String, List<String>>();
        for (String pair : pairs = query.split("&")) {
            String[] keyValue = pair.split("=");
            if (keyValue.length <= 0 || keyValue[0].length() <= 0) continue;
            try {
                String key = keyValue[0];
                String value = keyValue.length > 1 ? URLDecoder.decode(keyValue[1], "UTF-8") : null;
                List values = multiMap.computeIfAbsent(key, k -> new ArrayList());
                values.add(value);
            }
            catch (UnsupportedEncodingException e) {
                throw new OpenIdAuthenticationException("UTF-8 is no more supported");
            }
        }
        return multiMap;
    }

    static CacheKey keyFromDefinition(OpenIdAuthenticationDefinition definition) {
        String[][] values = new String[][]{{definition.providerURI(), definition.clientId(), definition.clientSecret(), definition.redirectURI(), definition.responseType(), definition.responseMode(), Arrays.toString((Object[])definition.prompt()), String.valueOf(definition.useNonce()), String.valueOf(definition.useSession()), String.valueOf(definition.tokenAutoRefresh()), String.valueOf(definition.tokenMinValidity())}, definition.scope(), definition.extraParameters(), ConfigurationController.providerMetadataAttrs(definition.providerMetadata()), ConfigurationController.claimsAttrs(definition.claimsDefinition()), ConfigurationController.proxyAttrs(definition.proxyDefinition()), ConfigurationController.logoutAttrs(definition.logout())};
        return new CacheKey(Stream.of(values).flatMap(Stream::of).toArray(String[]::new));
    }

    private static String[] logoutAttrs(LogoutDefinition logout) {
        String[] stringArray;
        if (logout != null) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = String.valueOf(logout.notifyProvider());
            stringArray2[1] = logout.redirectURI();
            stringArray2[2] = String.valueOf(logout.accessTokenExpiry());
            stringArray = stringArray2;
            stringArray2[3] = String.valueOf(logout.identityTokenExpiry());
        } else {
            stringArray = new String[4];
        }
        return stringArray;
    }

    private static String[] claimsAttrs(ClaimsDefinition claimsDefinition) {
        String[] stringArray;
        if (claimsDefinition != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = claimsDefinition.callerGroupsClaim();
            stringArray = stringArray2;
            stringArray2[1] = claimsDefinition.callerNameClaim();
        } else {
            stringArray = new String[2];
        }
        return stringArray;
    }

    private static String[] proxyAttrs(ProxyDefinition proxyDefinition) {
        String[] stringArray;
        if (proxyDefinition != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = proxyDefinition.hostName();
            stringArray = stringArray2;
            stringArray2[1] = proxyDefinition.port();
        } else {
            stringArray = new String[2];
        }
        return stringArray;
    }

    private static String[] providerMetadataAttrs(fish.payara.security.annotations.OpenIdProviderMetadata providerMetadata) {
        String[] stringArray;
        if (providerMetadata != null) {
            String[] stringArray2 = new String[5];
            stringArray2[0] = providerMetadata.authorizationEndpoint();
            stringArray2[1] = providerMetadata.tokenEndpoint();
            stringArray2[2] = providerMetadata.userinfoEndpoint();
            stringArray2[3] = providerMetadata.endSessionEndpoint();
            stringArray = stringArray2;
            stringArray2[4] = providerMetadata.jwksURI();
        } else {
            stringArray = new String[5];
        }
        return stringArray;
    }

    static class LastBuiltConfig {
        private final OpenIdAuthenticationDefinition definition;
        private final OpenIdConfiguration configuration;

        public LastBuiltConfig(OpenIdAuthenticationDefinition definition, OpenIdConfiguration configuration) {
            this.definition = definition;
            this.configuration = configuration;
        }

        OpenIdConfiguration cachedConfiguration(OpenIdAuthenticationDefinition definition) {
            if (this.definition != null && this.definition.equals(definition)) {
                return this.configuration;
            }
            return null;
        }
    }
}

