/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.domain;

import fish.payara.security.openid.domain.ClaimsConfiguration;
import fish.payara.security.openid.domain.LogoutConfiguration;
import fish.payara.security.openid.domain.OpenIdProviderMetadata;
import fish.payara.security.openid.domain.OpenIdTokenEncryptionMetadata;
import fish.payara.security.openid.domain.ProxyConfiguration;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class OpenIdConfiguration {
    private String clientId;
    private char[] clientSecret;
    private String redirectURI;
    private String scopes;
    private String responseType;
    private String responseMode;
    private Map<String, List<String>> extraParameters;
    private String prompt;
    private String display;
    private boolean useNonce;
    private boolean useSession;
    private int jwksConnectTimeout;
    private int jwksReadTimeout;
    private OpenIdProviderMetadata providerMetadata;
    private OpenIdTokenEncryptionMetadata encryptionMetadata;
    private ClaimsConfiguration claimsConfiguration;
    private ProxyConfiguration proxyConfiguration;
    private LogoutConfiguration logoutConfiguration;
    private boolean tokenAutoRefresh;
    private int tokenMinValidity;
    private boolean userClaimsFromIDToken;
    private boolean disableScopeValidation;
    static final String BASE_URL_EXPRESSION = "${baseURL}";

    public String getClientId() {
        return this.clientId;
    }

    public OpenIdConfiguration setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public char[] getClientSecret() {
        return this.clientSecret;
    }

    public OpenIdConfiguration setClientSecret(char[] clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public String buildRedirectURI(HttpServletRequest request) {
        String uri = this.redirectURI;
        if (this.redirectURI.contains(BASE_URL_EXPRESSION)) {
            String baseURL;
            if (this.proxyConfiguration != null && !this.proxyConfiguration.getHostName().isEmpty()) {
                baseURL = request.getScheme() + "://" + this.proxyConfiguration.getHostName();
                if (!this.proxyConfiguration.getPort().isEmpty()) {
                    baseURL = baseURL + ":" + this.proxyConfiguration.getPort();
                }
                baseURL = baseURL + request.getContextPath();
            } else {
                baseURL = request.getRequestURL().substring(0, request.getRequestURL().length() - request.getRequestURI().length()) + request.getContextPath();
            }
            uri = this.redirectURI.replace(BASE_URL_EXPRESSION, baseURL);
        }
        return uri;
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    public OpenIdConfiguration setRedirectURI(String redirectURI) {
        this.redirectURI = redirectURI;
        return this;
    }

    public String getScopes() {
        return this.scopes;
    }

    public OpenIdConfiguration setScopes(String scopes) {
        this.scopes = scopes;
        return this;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public OpenIdConfiguration setResponseType(String responseType) {
        this.responseType = responseType;
        return this;
    }

    public String getResponseMode() {
        return this.responseMode;
    }

    public OpenIdConfiguration setResponseMode(String responseMode) {
        this.responseMode = responseMode;
        return this;
    }

    public Map<String, List<String>> getExtraParameters() {
        return this.extraParameters;
    }

    public OpenIdConfiguration setExtraParameters(Map<String, List<String>> extraParameters) {
        this.extraParameters = extraParameters;
        return this;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public OpenIdConfiguration setPrompt(String prompt) {
        this.prompt = prompt;
        return this;
    }

    public String getDisplay() {
        return this.display;
    }

    public OpenIdConfiguration setDisplay(String display) {
        this.display = display;
        return this;
    }

    public boolean isUseNonce() {
        return this.useNonce;
    }

    public OpenIdConfiguration setUseNonce(boolean useNonce) {
        this.useNonce = useNonce;
        return this;
    }

    public boolean isUseSession() {
        return this.useSession;
    }

    public int getJwksConnectTimeout() {
        return this.jwksConnectTimeout;
    }

    public OpenIdConfiguration setJwksConnectTimeout(int jwksConnectTimeout) {
        this.jwksConnectTimeout = jwksConnectTimeout;
        return this;
    }

    public int getJwksReadTimeout() {
        return this.jwksReadTimeout;
    }

    public OpenIdConfiguration setJwksReadTimeout(int jwksReadTimeout) {
        this.jwksReadTimeout = jwksReadTimeout;
        return this;
    }

    public OpenIdConfiguration setUseSession(boolean useSession) {
        this.useSession = useSession;
        return this;
    }

    public OpenIdProviderMetadata getProviderMetadata() {
        return this.providerMetadata;
    }

    public OpenIdConfiguration setProviderMetadata(OpenIdProviderMetadata providerMetadata) {
        this.providerMetadata = providerMetadata;
        return this;
    }

    public ClaimsConfiguration getClaimsConfiguration() {
        return this.claimsConfiguration;
    }

    public OpenIdConfiguration setClaimsConfiguration(ClaimsConfiguration claimsConfiguration) {
        this.claimsConfiguration = claimsConfiguration;
        return this;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public OpenIdConfiguration setProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
        return this;
    }

    public LogoutConfiguration getLogoutConfiguration() {
        return this.logoutConfiguration;
    }

    public OpenIdConfiguration setLogoutConfiguration(LogoutConfiguration logoutConfiguration) {
        this.logoutConfiguration = logoutConfiguration;
        return this;
    }

    public OpenIdTokenEncryptionMetadata getEncryptionMetadata() {
        return this.encryptionMetadata;
    }

    public OpenIdConfiguration setEncryptionMetadata(OpenIdTokenEncryptionMetadata encryptionMetadata) {
        this.encryptionMetadata = encryptionMetadata;
        return this;
    }

    public boolean isTokenAutoRefresh() {
        return this.tokenAutoRefresh;
    }

    public OpenIdConfiguration setTokenAutoRefresh(boolean tokenAutoRefresh) {
        this.tokenAutoRefresh = tokenAutoRefresh;
        return this;
    }

    public int getTokenMinValidity() {
        return this.tokenMinValidity;
    }

    public OpenIdConfiguration setTokenMinValidity(int tokenMinValidity) {
        this.tokenMinValidity = tokenMinValidity;
        return this;
    }

    public boolean isUserClaimsFromIDToken() {
        return this.userClaimsFromIDToken;
    }

    public OpenIdConfiguration setUserClaimsFromIDToken(boolean userClaimsFromIDToken) {
        this.userClaimsFromIDToken = userClaimsFromIDToken;
        return this;
    }

    public boolean isDisableScopeValidation() {
        return this.disableScopeValidation;
    }

    public OpenIdConfiguration setDisableScopeValidation(boolean disableScopeValidation) {
        this.disableScopeValidation = disableScopeValidation;
        return this;
    }

    public String toString() {
        return OpenIdConfiguration.class.getSimpleName() + "{clientID=" + this.clientId + ", clientSecret=" + Arrays.toString(this.clientSecret) + ", redirectURI=" + this.redirectURI + ", scopes=" + this.scopes + ", responseType=" + this.responseType + ", responseMode=" + this.responseMode + ", extraParameters=" + this.extraParameters + ", prompt=" + this.prompt + ", display=" + this.display + ", useNonce=" + this.useNonce + ", useSession=" + this.useSession + ", providerMetadata=" + this.providerMetadata + ", claimsConfiguration=" + this.claimsConfiguration + ", encryptionMetadata=" + this.encryptionMetadata + ", tokenAutoRefresh=" + this.tokenAutoRefresh + ", tokenMinValidity=" + this.tokenMinValidity + ", userClaimsFromIDToken=" + this.userClaimsFromIDToken + ", disableScopeValidation=" + this.disableScopeValidation + "}";
    }
}

