/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jmx.monitoring.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.ColumnFormatter;
import com.sun.enterprise.util.StringUtils;
import fish.payara.internal.notification.NotifierUtils;
import fish.payara.internal.notification.PayaraNotifier;
import fish.payara.jmx.monitoring.configuration.MonitoredAttribute;
import fish.payara.jmx.monitoring.configuration.MonitoringServiceConfiguration;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-jmx-monitoring-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="get.jmx.monitoring.configuration")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="get-jmx-monitoring-configuration", description="List Payara JMX Monitoring Service Configuration")})
public class GetJMXMonitoringConfiguration
implements AdminCommand {
    private static final String[] JMX_MONITORING_HEADERS = new String[]{"JMX Monitoring Enabled", "JMX Log Frequency", "JMX Log Frequency Unit"};
    private static final String[] ATTRIBUTE_HEADERS = new String[]{"Object Name", "Attribute", "Description"};
    private static final String[] NOTIFIER_HEADERS = new String[]{"Name", "Notifier Enabled"};
    @Inject
    private Target targetUtil;
    @Param(name="pretty", defaultValue="false", optional=true)
    private Boolean pretty;
    @Param(name="target", defaultValue="server", optional=true)
    private String target;
    @Inject
    ServiceLocator habitat;

    public void execute(AdminCommandContext context) {
        Config config = this.targetUtil.getConfig(this.target);
        if (config == null) {
            context.getActionReport().setMessage("No such config name: " + this.targetUtil);
            context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ActionReport actionReport = context.getActionReport();
        ActionReport jmxMonitoringReport = actionReport.addSubActionsReport();
        ActionReport notifiersReport = actionReport.addSubActionsReport();
        ActionReport attributeReport = actionReport.addSubActionsReport();
        ColumnFormatter jmxMonitoringColumnFormatter = new ColumnFormatter(JMX_MONITORING_HEADERS);
        ColumnFormatter attributeColumnFormatter = new ColumnFormatter(ATTRIBUTE_HEADERS);
        ColumnFormatter notifiersColumnFormatter = new ColumnFormatter(NOTIFIER_HEADERS);
        MonitoringServiceConfiguration monitoringConfig = (MonitoringServiceConfiguration)config.getExtensionByType(MonitoringServiceConfiguration.class);
        List allNotifierServiceHandles = this.habitat.getAllServiceHandles(PayaraNotifier.class, new Annotation[0]);
        jmxMonitoringColumnFormatter.addRow(new Object[]{monitoringConfig.getEnabled(), monitoringConfig.getLogFrequency(), monitoringConfig.getLogFrequencyUnit()});
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("enabled", monitoringConfig.getEnabled());
        map.put("logfrequency", monitoringConfig.getLogFrequency());
        map.put("logfrequencyunit", monitoringConfig.getLogFrequencyUnit());
        Properties extraProps = new Properties();
        extraProps.put("jmxmonitoringConfiguration", map);
        ArrayList monitoredAttributes = new ArrayList();
        for (MonitoredAttribute monitoredBean : monitoringConfig.getMonitoredAttributes()) {
            Object[] values = new Object[]{monitoredBean.getObjectName(), monitoredBean.getAttributeName(), monitoredBean.getDescription()};
            HashMap<String, String> monitoredAttribute = new HashMap<String, String>();
            monitoredAttribute.put(monitoredBean.getObjectName(), monitoredBean.getAttributeName());
            monitoredAttributes.add(monitoredAttribute);
            attributeColumnFormatter.addRow(values);
        }
        extraProps.put("monitored-beans", monitoredAttributes);
        actionReport.setExtraProperties(extraProps);
        if (!monitoringConfig.getNotifierList().isEmpty()) {
            List<String> notifiers = monitoringConfig.getNotifierList();
            Properties notifierProps = new Properties();
            for (ServiceHandle serviceHandle : allNotifierServiceHandles) {
                String notifierClassName = serviceHandle.getActiveDescriptor().getImplementationClass().getSimpleName();
                String notifierName = NotifierUtils.getNotifierName((ActiveDescriptor)serviceHandle.getActiveDescriptor());
                Object[] values = new Object[]{notifierName, notifiers.contains(notifierName)};
                notifiersColumnFormatter.addRow(values);
                HashMap<String, Object> mapNotifiers = new HashMap<String, Object>(2);
                mapNotifiers.put("notifierName", values[0]);
                mapNotifiers.put("notifierEnabled", values[1]);
                notifierProps.put("notifierList" + notifierClassName, mapNotifiers);
            }
            actionReport.getExtraProperties().putAll((Map<?, ?>)notifierProps);
        }
        jmxMonitoringReport.setMessage(jmxMonitoringColumnFormatter.toString());
        jmxMonitoringReport.appendMessage(StringUtils.EOL);
        notifiersReport.setMessage(notifiersColumnFormatter.toString());
        notifiersReport.appendMessage(StringUtils.EOL);
        attributeReport.setMessage(attributeColumnFormatter.toString());
        attributeReport.appendMessage(StringUtils.EOL);
        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private String prettyBool(boolean plain) {
        if (!this.pretty.booleanValue()) {
            return String.valueOf(plain);
        }
        if (plain) {
            return "\u2713";
        }
        return "\u2717";
    }
}

