/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.appserver.context;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.Utility;
import fish.payara.appserver.context.ContextImpl;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.JavaEEContextUtil;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.ModuleInfo;
import org.jboss.weld.context.bound.BoundRequestContext;
import org.jvnet.hk2.annotations.Service;

@Service
public class JavaEEContextUtilImpl
implements JavaEEContextUtil,
Serializable {
    private static final long serialVersionUID = 2L;
    @Inject
    private transient ComponentEnvManager compEnvMgr;
    @Inject
    private transient ApplicationRegistry appRegistry;
    @Inject
    private transient InvocationManager invocationManager;

    public JavaEEContextUtil.Instance empty() {
        return new InstanceImpl();
    }

    public JavaEEContextUtil.Instance currentInvocation() {
        ComponentInvocation currentInvocation = this.invocationManager.getCurrentInvocation();
        if (currentInvocation == null) {
            throw new IllegalStateException("No Current Invocation present");
        }
        return new InstanceImpl(currentInvocation);
    }

    public JavaEEContextUtil.Instance fromComponentId(String componentId) throws IllegalArgumentException {
        if (componentId == null) {
            throw new IllegalArgumentException("componentId cannot be null");
        }
        return new InstanceImpl(componentId);
    }

    public ClassLoader getInvocationClassLoader() {
        JndiNameEnvironment componentEnv = this.compEnvMgr.getCurrentJndiNameEnvironment();
        return JavaEEContextUtilImpl.getClassLoaderForEnvironment(componentEnv);
    }

    public String getInvocationComponentId() {
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        return inv != null ? inv.getComponentId() : null;
    }

    public boolean isInvocationLoaded() {
        ComponentInvocation inv = this.invocationManager.getCurrentInvocation();
        return inv != null ? this.isLoaded(inv.getComponentId(), inv) : false;
    }

    public boolean moduleMatches(ModuleInfo moduleInfo, String modulNameToMatch) {
        return VersioningUtils.getUntaggedName((String)moduleInfo.getName()).equals(modulNameToMatch);
    }

    private static ClassLoader getClassLoaderForEnvironment(JndiNameEnvironment componentEnv) {
        if (componentEnv instanceof BundleDescriptor) {
            BundleDescriptor bd = (BundleDescriptor)componentEnv;
            return bd.getClassLoader();
        }
        if (componentEnv instanceof EjbDescriptor) {
            EjbDescriptor ed = (EjbDescriptor)componentEnv;
            return ed.getEjbBundleDescriptor().getClassLoader();
        }
        return null;
    }

    private ComponentInvocation createInvocation(JndiNameEnvironment jndiEnv, String componentId) {
        ComponentInvocation newInvocation = new ComponentInvocation();
        newInvocation.componentId = componentId;
        newInvocation.setJNDIEnvironment((Object)jndiEnv);
        newInvocation.setComponentInvocationType(ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION);
        return newInvocation;
    }

    private boolean isLoaded(String componentId, ComponentInvocation invocation) {
        JndiNameEnvironment env;
        if (componentId == null) {
            return true;
        }
        JndiNameEnvironment jndiNameEnvironment = env = invocation != null ? (JndiNameEnvironment)invocation.getJNDIEnvironment() : this.compEnvMgr.getJndiNameEnvironment(componentId);
        if (env != null) {
            ApplicationInfo appInfo = null;
            try {
                appInfo = this.appRegistry.get(DOLUtils.getApplicationFromEnv((JndiNameEnvironment)env).getRegistrationName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (appInfo != null && appInfo.getModuleInfos().stream().filter(mod -> DOLUtils.isEarApplication((JndiNameEnvironment)env) ? true : mod.getName().equals(DOLUtils.getModuleName((JndiNameEnvironment)env))).anyMatch(moduleInfo -> !moduleInfo.isLoaded())) {
                return false;
            }
        }
        return env != null;
    }

    static boolean isLeaked(ComponentEnvManager compEnvMgr, ComponentInvocation cachedInvocation, String componentId) {
        return cachedInvocation != null && JavaEEContextUtilImpl.getClassLoaderForEnvironment((JndiNameEnvironment)cachedInvocation.getJNDIEnvironment()) != JavaEEContextUtilImpl.getClassLoaderForEnvironment(compEnvMgr.getJndiNameEnvironment(componentId));
    }

    private Object readResolve() {
        return Globals.getDefaultHabitat().getService(JavaEEContextUtil.class, new Annotation[0]);
    }

    public class InstanceImpl
    implements JavaEEContextUtil.Instance {
        private static final long serialVersionUID = 1L;
        private final String componentId;
        private volatile transient ComponentInvocation cachedInvocation;
        private volatile transient boolean loaded;

        private InstanceImpl() {
            this.componentId = null;
            this.checkState();
        }

        private InstanceImpl(ComponentInvocation currentInvocation) {
            boolean isApplicationComponent = false;
            if (currentInvocation.getComponentId() != null) {
                this.componentId = VersioningUtils.getUntaggedName((String)currentInvocation.getComponentId());
            } else if (currentInvocation.getJNDIEnvironment() instanceof JndiNameEnvironment) {
                this.componentId = DOLUtils.toEarComponentId((String)DOLUtils.getApplicationName((JndiNameEnvironment)((JndiNameEnvironment)currentInvocation.jndiEnvironment)));
                isApplicationComponent = true;
            } else {
                this.componentId = null;
            }
            this.cachedInvocation = currentInvocation.clone();
            if (isApplicationComponent) {
                this.cachedInvocation.setComponentId(this.componentId);
            }
            this.cachedInvocation.clearRegistry();
            this.checkState();
        }

        private InstanceImpl(String componentId) {
            this.componentId = componentId;
            this.checkState();
        }

        public JavaEEContextUtil.Context pushContext() {
            if (this.isEmpty()) {
                return new ContextImpl.EmptyContext(JavaEEContextUtilImpl.this.invocationManager);
            }
            if (!this.isValidAndNotEmpty()) {
                return new ContextImpl.Context(null, JavaEEContextUtilImpl.this.invocationManager, JavaEEContextUtilImpl.this.compEnvMgr, null);
            }
            ComponentInvocation newInvocation = this.ensureCached(true).clone();
            JavaEEContextUtilImpl.this.invocationManager.preInvoke(newInvocation);
            return new ContextImpl.Context(newInvocation, JavaEEContextUtilImpl.this.invocationManager, JavaEEContextUtilImpl.this.compEnvMgr, Utility.setContextClassLoader((ClassLoader)JavaEEContextUtilImpl.this.getInvocationClassLoader()));
        }

        public JavaEEContextUtil.Context pushRequestContext() {
            BoundRequestContext brc;
            JavaEEContextUtil.Context rootCtx = this.pushContext();
            if (!this.isValidAndNotEmpty()) {
                return rootCtx;
            }
            try {
                brc = (BoundRequestContext)CDI.current().select(BoundRequestContext.class, new Annotation[0]).get();
            }
            catch (Throwable ex) {
                return rootCtx;
            }
            ContextImpl.RequestContext context = new ContextImpl.RequestContext(rootCtx, brc.isActive() ? null : brc, new HashMap<String, Object>());
            if (context.ctx != null) {
                context.ctx.associate(context.storage);
                context.ctx.activate();
            }
            return context;
        }

        public JavaEEContextUtil.Context setApplicationClassLoader() {
            ClassLoader cl = null;
            ComponentInvocation localCachedInvocation = this.ensureCached(false);
            if (localCachedInvocation != null) {
                cl = JavaEEContextUtilImpl.getClassLoaderForEnvironment((JndiNameEnvironment)localCachedInvocation.getJNDIEnvironment());
            } else if (this.componentId != null) {
                cl = JavaEEContextUtilImpl.getClassLoaderForEnvironment(JavaEEContextUtilImpl.this.compEnvMgr.getJndiNameEnvironment(this.componentId));
            }
            if (cl != null) {
                return new ContextImpl.ClassLoaderContext(Utility.setContextClassLoader((ClassLoader)cl), true);
            }
            return new ContextImpl.ClassLoaderContext(null, false);
        }

        public String getInstanceComponentId() {
            return this.componentId;
        }

        private ComponentInvocation ensureCached(boolean failOnError) {
            ComponentInvocation localCachedInvocation = this.cachedInvocation;
            if (localCachedInvocation != null || this.isEmpty()) {
                return localCachedInvocation;
            }
            JndiNameEnvironment jndiEnv = JavaEEContextUtilImpl.this.compEnvMgr.getJndiNameEnvironment(this.componentId);
            if (jndiEnv != null) {
                this.cachedInvocation = localCachedInvocation = JavaEEContextUtilImpl.this.createInvocation(jndiEnv, this.componentId);
            } else if (failOnError) {
                throw new IllegalStateException(String.format("Cannot cache invocation: %s", this.componentId));
            }
            this.checkState();
            return localCachedInvocation;
        }

        public boolean isLoaded() {
            if (!this.loaded) {
                this.loaded = JavaEEContextUtilImpl.this.isLoaded(this.componentId, this.cachedInvocation);
            }
            return this.loaded;
        }

        public boolean isEmpty() {
            return this.componentId == null;
        }

        public void clearInstanceInvocation() {
            this.loaded = false;
            this.cachedInvocation = null;
        }

        private boolean isValidAndNotEmpty() {
            return this.isCurrentInvocationPresentAndSame() || this.isLoaded();
        }

        private boolean isCurrentInvocationPresentAndSame() {
            ComponentInvocation invocation = JavaEEContextUtilImpl.this.invocationManager.getCurrentInvocation();
            if (invocation != null) {
                return this.componentId != null && this.componentId.equals(invocation.getComponentId());
            }
            return false;
        }

        private void checkState() {
            ComponentInvocation localCachedInvocation = this.cachedInvocation;
            if (this.componentId == null && localCachedInvocation != null) {
                throw new IllegalStateException("Cannot have non-null cached invocation for an empty component");
            }
            if (localCachedInvocation != null && (localCachedInvocation.getComponentId() == null || localCachedInvocation.getJNDIEnvironment() == null)) {
                throw new IllegalStateException("Invalid Cached Invocation - either componentID or JNDIEnvironment is null");
            }
            if (this.loaded && localCachedInvocation == null) {
                throw new IllegalStateException("running/loaded invocation with null cache");
            }
        }
    }
}

