/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.microprofile.jaxrs.client.ssl;

import com.sun.enterprise.security.ssl.SSLUtils;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509KeyManager;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.spi.RestClientListener;
import org.glassfish.internal.api.Globals;

public class RestClientSslContextAliasListener
implements RestClientListener {
    private static final Logger logger = Logger.getLogger(RestClientSslContextAliasListener.class.getName());

    public void onNewClient(Class<?> serviceInterface, RestClientBuilder restClientBuilder) {
        logger.log(Level.FINE, "Evaluating state of the RestClientBuilder after calling build method");
        Object objectProperty = restClientBuilder.getConfiguration().getProperty("fish.payara.rest.client.certificate.alias");
        if (objectProperty instanceof String) {
            String alias = (String)objectProperty;
            logger.log(Level.INFO, String.format("The alias: %s is available from the RestClientBuilder configuration", alias));
            SSLContext customSSLContext = this.buildSSlContext(alias);
            if (customSSLContext != null) {
                restClientBuilder.sslContext(customSSLContext);
            } else {
                logger.log(Level.INFO, String.format("Although the alias: %s is configured, it could not be found in an available keystore", alias));
            }
        } else {
            Config config = this.getConfig();
            try {
                String alias = config.getValue("payara.certificate.alias", String.class);
                if (alias != null) {
                    logger.log(Level.INFO, String.format("The alias: %s is available from the MP Config", alias));
                    SSLContext customSSLContext = this.buildSSlContext(alias);
                    if (customSSLContext != null) {
                        restClientBuilder.sslContext(customSSLContext);
                    } else {
                        logger.log(Level.INFO, String.format("Although the alias: %s is configured, it could not be found in an available keystore", alias));
                    }
                }
            }
            catch (NoSuchElementException e) {
                logger.log(Level.FINE, String.format("The MP config property %s was not set", "payara.certificate.alias"));
            }
        }
    }

    protected SSLContext buildSSlContext(String alias) {
        logger.log(Level.FINE, "Building the SSLContext for the alias");
        try {
            KeyStore[] keyStores;
            KeyManager[] managers = this.getKeyManagers();
            Optional<X509KeyManager> optionalKeyManager = null;
            optionalKeyManager = Arrays.stream(managers).filter(m -> m instanceof X509KeyManager).map(m -> (X509KeyManager)m).findFirst();
            for (KeyStore ks : keyStores = this.getKeyStores()) {
                if (!ks.containsAlias(alias) || !optionalKeyManager.isPresent()) continue;
                SingleCertificateKeyManager customKeyManager = new SingleCertificateKeyManager(alias, optionalKeyManager.get());
                SSLContext customSSLContext = SSLContext.getInstance("TLS");
                customSSLContext.init(new KeyManager[]{customKeyManager}, null, null);
                return customSSLContext;
            }
        }
        catch (IOException e) {
            logger.severe("An IOException was thrown with the following message" + e.getMessage());
        }
        catch (KeyStoreException e) {
            logger.severe("A KeyStoreException was thrown with the following message" + e.getMessage());
        }
        catch (Exception e) {
            logger.severe("An Exception was thrown with the following message" + e.getMessage());
        }
        return null;
    }

    protected Config getConfig() {
        return ConfigProvider.getConfig();
    }

    protected KeyManager[] getKeyManagers() throws Exception {
        SSLUtils sslUtils = (SSLUtils)Globals.get(SSLUtils.class);
        return sslUtils.getKeyManagers();
    }

    protected KeyStore[] getKeyStores() throws IOException {
        SSLUtils sslUtils = (SSLUtils)Globals.get(SSLUtils.class);
        return sslUtils.getKeyStores();
    }

    private static class SingleCertificateKeyManager
    implements X509KeyManager {
        private String alias;
        private X509KeyManager keyManager;

        SingleCertificateKeyManager(String alias, X509KeyManager keyManager) {
            this.alias = alias;
            this.keyManager = keyManager;
        }

        @Override
        public String[] getClientAliases(String s, Principal[] principals) {
            return this.keyManager.getClientAliases(s, principals);
        }

        @Override
        public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
            return this.alias;
        }

        @Override
        public String[] getServerAliases(String s, Principal[] principals) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
            throw new UnsupportedOperationException();
        }

        @Override
        public X509Certificate[] getCertificateChain(String s) {
            return this.keyManager.getCertificateChain(s);
        }

        @Override
        public PrivateKey getPrivateKey(String s) {
            return this.keyManager.getPrivateKey(s);
        }
    }
}

