/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.ConnectionConsumerReader;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import com.sun.messaging.jmq.jmsclient.RemoteAcknowledgeException;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.SessionQueue;
import com.sun.messaging.jmq.jmsclient.Traceable;
import com.sun.messaging.jmq.jmsclient.XAResourceImpl;
import com.sun.messaging.jmq.jmsclient.XAResourceMap;
import com.sun.messaging.jmq.jmsclient.XASessionImpl;
import com.sun.messaging.jmq.jmsspi.ServerSession;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.ServerSessionPool;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectionConsumerImpl
extends Consumer
implements ConnectionConsumer,
Traceable {
    protected ServerSessionPool serverSessionPool;
    protected int maxMessages;
    private SessionQueue readQueue = null;
    private ConnectionConsumerReader reader = null;
    private Long readQueueId = null;
    private jakarta.jms.ServerSession serverSession = null;
    private SessionImpl session = null;
    private Object closeLock = new Object();
    private boolean failoverInProgress = false;
    private Object recreationLock = new Object();
    private boolean recreationInProgress1 = false;
    private boolean recreationInProgress2 = false;
    private Long interestIdToBeRecreated = null;
    private List seenSessions = Collections.synchronizedList(new ArrayList());

    public ConnectionConsumerImpl(ConnectionImpl connection, Destination d, String messageSelector, ServerSessionPool sessionPool, int maxMessages, String subscriptionName, boolean durable, boolean share) throws JMSException {
        super(connection, d, messageSelector, false);
        if (durable) {
            if (!share && connection.clientID == null) {
                String errorString = AdministeredObject.cr.getKString("C4053", "\"\"");
                throw new JMSException(errorString, "C4053");
            }
            this.setDurable(true);
            this.setDurableName(subscriptionName);
        }
        if (share) {
            this.setShared(true);
            if (!durable) {
                this.setSharedSubscriptionName(subscriptionName);
            }
        }
        if ((durable || share) && connection.clientID != null && !connection.getProtocolHandler().isClientIDsent()) {
            connection.getProtocolHandler().setClientID(connection.clientID);
        }
        this.serverSessionPool = sessionPool;
        this.maxMessages = maxMessages;
        this.init();
    }

    public void init() throws JMSException {
        this.readQueue = new SessionQueue();
        if (this.connection.getIsStopped()) {
            this.readQueue.setIsLocked(true);
        }
        this.readQueueId = this.connection.getNextSessionId();
        this.connection.addToReadQTable(this.readQueueId, this.readQueue);
        this.reader = new ConnectionConsumerReader(this);
        this.reader.start();
        this.addInterest();
    }

    private void addInterest() throws JMSException {
        this.connection.addConnectionConsumer(this);
        this.registerInterest();
    }

    private void removeInterest() throws JMSException {
        this.connection.removeConnectionConsumer(this);
        this.deregisterInterest();
    }

    @Override
    protected Long getReadQueueId() {
        return this.readQueueId;
    }

    protected SessionQueue getReadQueue() {
        return this.readQueue;
    }

    protected boolean canRecreate() {
        if (this.destination instanceof Queue) {
            return true;
        }
        return this.getDurableName() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRecreation(RemoteAcknowledgeException rex) {
        Long cid = this.getInterestId();
        Hashtable<Long, ConnectionConsumerImpl> ht = new Hashtable<Long, ConnectionConsumerImpl>();
        ht.put(cid, this);
        if (SessionImpl.matchConsumerIDs(rex, ht, ConnectionImpl.connectionLogger)) {
            Object object = this.recreationLock;
            synchronized (object) {
                if (this.interestIdToBeRecreated == null || !this.interestIdToBeRecreated.equals(cid)) {
                    if (!this.getInterestId().equals(cid)) {
                        return;
                    }
                    this.interestIdToBeRecreated = cid;
                    ConnectionImpl.connectionLogger.log(Level.FINE, "Notified ConnectionConsumer[" + cid + "] to be recreated");
                    if (this.readQueue.isEmpty()) {
                        this.readQueue.enqueueNotify(null);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recreateIfNecessary() throws JMSException {
        if (!this.canRecreate()) {
            return false;
        }
        Long recid = null;
        boolean recreated = false;
        Object object = this.closeLock;
        synchronized (object) {
            this.checkState();
            if (this.failoverInProgress) {
                return false;
            }
            Object object2 = this.recreationLock;
            synchronized (object2) {
                recid = this.interestIdToBeRecreated;
                this.setRecreationInProgress1(true);
            }
        }
        Logger logger = ConnectionImpl.connectionLogger;
        boolean sessionstopped = false;
        try {
            Long cid = this.getInterestId();
            if (recid != null && recid.equals(cid)) {
                Object object3;
                Object emsg2;
                logger.log(Level.INFO, "Recreate ConnectionConsumer[" + cid + "] ...");
                ProtocolHandler ph = this.connection.getProtocolHandler();
                try {
                    ph.stopSession(this.connection.getConnectionID());
                    logger.log(Level.FINE, "Stopped ConnectionConsumer[" + cid + "]'s session " + cid);
                    sessionstopped = true;
                }
                catch (Throwable t) {
                    String emsg2 = "Exception in stopping ConnectionConsumer[" + cid + "]'s session";
                    logger.log(Level.SEVERE, emsg2, t);
                    if (t instanceof JMSException) {
                        throw (JMSException)t;
                    }
                    JMSException jmse = new JMSException(emsg2 + ": " + t.getMessage());
                    jmse.initCause(t);
                    throw jmse;
                }
                Object t = this.closeLock;
                synchronized (t) {
                    block97: {
                        this.checkState();
                        if (!this.failoverInProgress) break block97;
                        boolean emsg2 = false;
                        return emsg2;
                    }
                    emsg2 = this.recreationLock;
                    synchronized (emsg2) {
                        this.setRecreationInProgress2(true);
                    }
                }
                logger.log(Level.INFO, "Reset ConnectionConsumer[" + cid + "]'s ServerSessions " + this.seenSessions.size());
                SessionImpl[] sss = null;
                emsg2 = this.seenSessions;
                synchronized (emsg2) {
                    sss = this.seenSessions.toArray(new SessionImpl[this.seenSessions.size()]);
                }
                SessionImpl ss = null;
                for (int i = 0; i < sss.length; ++i) {
                    ss = sss[i];
                    logger.log(Level.FINE, "Reseting ConnectionConsumer[" + cid + "]'s ServerSession's session " + ss);
                    ss.resetServerSessionRunner(false);
                    logger.log(Level.FINE, "Reseted ConnectionConsumer[" + cid + "]'s ServerSession's session " + ss);
                }
                int xarcnt = 0;
                long waittime = 0L;
                while ((xarcnt = XAResourceMap.hasXAResourceForCC(this)) > 0 && !this.failoverInProgress && !this.isClosed) {
                    if (waittime % 15000L == 0L) {
                        waittime = 0L;
                        logger.log(Level.INFO, "Waiting for all active XAResources " + xarcnt + " before recreate ConnectionConsumer[" + cid + "] ...");
                    }
                    object3 = this.closeLock;
                    synchronized (object3) {
                        try {
                            this.closeLock.wait(1000L);
                            waittime += 1000L;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                try {
                    this.deregisterInterest();
                }
                catch (Throwable t2) {
                    Level loglevel = Level.SEVERE;
                    if (this.connection.getRecoverInProcess()) {
                        loglevel = Level.WARNING;
                    }
                    logger.log(loglevel, "Exception on deregister interest to recreate ConnectionConsumer[" + cid + "]");
                    boolean bl = false;
                    this.setRecreationInProgress1(false);
                    this.setRecreationInProgress2(false);
                    if (sessionstopped) {
                        ProtocolHandler ph2 = this.connection.getProtocolHandler();
                        logger.log(Level.INFO, "Start ConnectionConsumer[" + this.getInterestId() + "]'s session " + this.connection.getConnectionID());
                        while (true) {
                            try {
                                ph2.resumeSession(this.connection.getConnectionID());
                                logger.log(Level.INFO, "Started ConnectionConsumer[" + this.getInterestId() + "]'s session " + this.connection.getConnectionID());
                            }
                            catch (Throwable t3) {
                                String emsg3 = "Exception on start ConnectionConsumer[" + this.getInterestId() + "]'s session, retry ...";
                                logger.log(Level.SEVERE, emsg3, t3);
                                Object object4 = this.closeLock;
                                synchronized (object4) {
                                    try {
                                        this.closeLock.wait(5000L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    continue;
                                }
                                if (!this.isClosed) continue;
                            }
                            break;
                        }
                    }
                    return bl;
                }
                this.readQueue.clear();
                while (true) {
                    try {
                        this.registerInterest();
                        logger.log(Level.INFO, "Recreated ConnectionConsumer[" + cid + "]: " + this.getInterestId());
                        recreated = true;
                    }
                    catch (Throwable t4) {
                        logger.log(Level.SEVERE, "Exception on register interest to recreate ConnectionConsumer[" + cid + "], retry ...", t4);
                        try {
                            this.deregisterInterest();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.readQueue.clear();
                        Object object5 = this.closeLock;
                        synchronized (object5) {
                            try {
                                this.closeLock.wait(5000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            continue;
                        }
                        if (!this.isClosed && !this.failoverInProgress) continue;
                    }
                    break;
                }
                object3 = this.closeLock;
                synchronized (object3) {
                    this.checkState();
                    if (this.failoverInProgress) {
                        throw new JMSException("Connection recovery in progress");
                    }
                }
                this.setRecreationInProgress2(false);
            }
            Object object6 = this.recreationLock;
            synchronized (object6) {
                block98: {
                    if (this.interestIdToBeRecreated != null) break block98;
                    boolean sss = recreated;
                    return sss;
                }
                if (this.interestIdToBeRecreated.equals(recid)) {
                    this.interestIdToBeRecreated = null;
                }
            }
            boolean bl = recreated;
            return bl;
        }
        finally {
            this.setRecreationInProgress1(false);
            this.setRecreationInProgress2(false);
            if (sessionstopped) {
                ProtocolHandler ph = this.connection.getProtocolHandler();
                logger.log(Level.INFO, "Start ConnectionConsumer[" + this.getInterestId() + "]'s session " + this.connection.getConnectionID());
                while (true) {
                    try {
                        ph.resumeSession(this.connection.getConnectionID());
                        logger.log(Level.INFO, "Started ConnectionConsumer[" + this.getInterestId() + "]'s session " + this.connection.getConnectionID());
                    }
                    catch (Throwable t) {
                        String emsg = "Exception on start ConnectionConsumer[" + this.getInterestId() + "]'s session, retry ...";
                        logger.log(Level.SEVERE, emsg, t);
                        Object object7 = this.closeLock;
                        synchronized (object7) {
                            try {
                                this.closeLock.wait(5000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (!this.isClosed) continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRecreationInProgress1(boolean b) {
        Object object = this.recreationLock;
        synchronized (object) {
            this.recreationInProgress1 = b;
            if (!b) {
                this.recreationLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRecreationInProgress2(boolean b) {
        Object object = this.recreationLock;
        synchronized (object) {
            this.recreationInProgress2 = b;
            if (!b) {
                this.recreationLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisteredXAResource() {
        Object object = this.closeLock;
        synchronized (object) {
            this.closeLock.notifyAll();
        }
    }

    protected void sessionClosed(SessionImpl ss) {
        this.seenSessions.remove(ss);
    }

    protected void onNullMessage() throws JMSException {
        if (this.isClosed) {
            return;
        }
        this.recreateIfNecessary();
    }

    @Override
    protected void onMessage(MessageImpl message) throws JMSException {
        if (this.recreateIfNecessary()) {
            return;
        }
        if (this.session == null) {
            this.serverSession = this.serverSessionPool.getServerSession();
            try {
                this.session = (SessionImpl)this.serverSession.getSession();
                if (this.session.getConnection() != this.connection) {
                    String errorString = AdministeredObject.cr.getKString("C4029");
                    throw new JMSException(errorString, "C4029");
                }
                if (this.session.getMessageListener() == null) {
                    String errorString = AdministeredObject.cr.getKString("C4029");
                    throw new IllegalStateException(errorString, "C4029");
                }
            }
            catch (JMSException e) {
                if (this.session != null && this.serverSession instanceof ServerSession) {
                    ((ServerSession)this.serverSession).destroy();
                }
                this.session = null;
                this.serverSession = null;
                throw e;
            }
        }
        message.setSession(this.session);
        this.session.loadMessageToServerSession(message, this.serverSession, this.isDMQConsumer);
        if (this.session instanceof XASessionImpl) {
            XAResourceImpl xar = (XAResourceImpl)((XASessionImpl)this.session).getXAResource();
            xar.setConnectionConsumer(this);
            this.session.setConnectionConsumer(this);
            if (!this.seenSessions.contains(this.session)) {
                this.seenSessions.add(this.session);
            }
        }
    }

    protected void startServerSession() throws JMSException {
        if (this.serverSession != null) {
            this.serverSession.start();
            this.serverSession = null;
            this.session = null;
        }
    }

    protected int getMaxMessages() {
        return this.maxMessages;
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        return this.serverSessionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        Object object = this.closeLock;
        synchronized (object) {
            this.isClosed = true;
            this.closeLock.notifyAll();
        }
        this.reader.close();
        long waittime = 0L;
        Object object2 = this.recreationLock;
        synchronized (object2) {
            while (this.recreationInProgress1) {
                if (waittime % 15000L == 0L) {
                    waittime = 0L;
                    ConnectionImpl.connectionLogger.log(Level.INFO, "Waiting for ConnectionConsumer[" + this.getInterestId() + "] reader thread completion ...");
                }
                try {
                    this.recreationLock.wait(5000L);
                    waittime += 5000L;
                }
                catch (Exception exception) {}
            }
        }
        this.removeInterest();
        this.connection.removeFromReadQTable(this.readQueueId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFailoverInprogress(boolean b) {
        Object object = this.closeLock;
        synchronized (object) {
            this.failoverInProgress = b;
            this.closeLock.notifyAll();
            if (!b) {
                return;
            }
        }
        long waittime = 0L;
        Object object2 = this.recreationLock;
        synchronized (object2) {
            while (this.recreationInProgress2) {
                if (waittime % 15000L == 0L) {
                    waittime = 0L;
                    ConnectionImpl.connectionLogger.log(Level.INFO, "Waiting for reader thread completes recreation of ConnectionConsumer[" + this.getInterestId() + "] ...");
                }
                try {
                    this.recreationLock.wait(5000L);
                    waittime += 5000L;
                }
                catch (Exception exception) {}
            }
        }
        this.readQueue.clear();
    }

    protected void stop() {
        this.readQueue.stop(false);
    }

    protected void start() {
        this.readQueue.start();
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("------ ConnectionConsumerImpl dump ------");
        ps.println("Interest ID: " + this.getInterestId());
        ps.println("is registered: " + this.getIsRegistered());
        ps.println("is durable: " + this.getDurable());
        if (this.durable) {
            ps.println("durableName: " + this.getDurableName());
        }
        ps.println("destination: " + this.getDestination());
        ps.println("selector: " + this.messageSelector);
        ps.println("maxMessages: " + this.maxMessages);
    }

    @Override
    protected Hashtable getDebugState(boolean verbose) {
        Hashtable ht = super.getDebugState(verbose);
        ht.put("maxMessages", String.valueOf(this.maxMessages));
        ht.put("recreationInProgress1", this.recreationInProgress1);
        ht.put("recreationInProgress2", this.recreationInProgress2);
        ht.put("failoverInProgress", this.failoverInProgress);
        Long id = this.interestIdToBeRecreated;
        ht.put("interestIdToBeRecreated", id == null ? "null" : String.valueOf(id));
        int sssize = this.seenSessions.size();
        ht.put("#seenSessions", String.valueOf(sssize));
        int cnt = XAResourceMap.hasXAResourceForCC(this, false);
        ht.put("#xaresourcesInFlight", String.valueOf(cnt));
        return ht;
    }
}

