/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.blc;

import com.sun.messaging.AdminConnectionFactory;
import com.sun.messaging.ConnectionFactory;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsspi.PropertiesHolder;
import com.sun.messaging.jmq.util.service.PortMapperClientHandler;
import com.sun.messaging.jms.blc.EmbeddedBrokerRunner;
import com.sun.messaging.jms.blc.LocalBrokerRunner;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.resource.spi.ResourceAdapterInternalException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.remote.JMXServiceURL;

public class LifecycleManagedBroker {
    public static final String BROKER_TYPE_REMOTE = "REMOTE";
    public static final String BROKER_TYPE_LOCAL = "LOCAL";
    public static final String BROKER_TYPE_EMBEDDED = "EMBEDDED";
    public static final String BROKER_TYPE_DIRECT = "DIRECT";
    private static final String _className = "com.sun.messaging.jms.ra.LifecycleManagedBroker";
    private static final String _lgrNameLifecycle = "javax.resourceadapter.mqjmsra.lifecycle";
    private static final Logger _loggerL = Logger.getLogger("javax.resourceadapter.mqjmsra.lifecycle");
    private static final String _lgrMIDPrefix = "MQJMSRA_RA";
    private static final String _lgrMID_INF = "MQJMSRA_RA1101: ";
    private static final String _lgrMID_WRN = "MQJMSRA_RA2001: ";
    private static final String _lgrMID_ERR = "MQJMSRA_RA3001: ";
    private static final String _lgrMID_EXC = "MQJMSRA_RA4001: ";
    private EmbeddedBrokerRunner ebr = null;
    private LocalBrokerRunner lbr = null;
    private static JMSService jmsservice = null;
    private boolean started;
    private boolean doBind = true;
    private static boolean _startedAtLeastOnce;
    private static int _rmiRegistryPort;
    private String brokerType = "REMOTE";
    private String brokerInstanceName = "imqbroker";
    private String adminUsername = "admin";
    private String adminPassword = null;
    private String brokerBindAddress = null;
    private int rmiRegistryPort = 1099;
    private boolean startRmiRegistry = false;
    private String jmxServiceURL = null;
    private int brokerPort = 7676;
    private String brokerHomeDir = null;
    private String brokerLibDir = null;
    private String brokerVarDir = null;
    private String brokerJavaDir = null;
    private String brokerArgs = null;
    private boolean useJNDIRmiServiceURL = true;
    private boolean useSSLJMXConnector = true;
    private int nowaitForMasterBrokerTimeoutInSeconds = -1;
    private String brokerId = null;
    private int brokerStartTimeout = 20000;
    private String adminPassFile = null;
    private boolean brokerEnableHA = false;
    private String clusterId = null;
    private String dbType = null;
    private String connectionURL = "";
    public static final String DB_TYPE_DERBY = "derby";
    public static final String DB_TYPE_MYSQL = "mysql";
    public static final String DB_TYPE_ORACLE = "oracle";
    public static final String DB_TYPE_POINTBASE = "pointbase";
    public static final String DB_TYPE_CLOUDSCAPE = "cloudscape";
    private static String IMQ_BROKERID;
    private static String IMQ_JDBC_VENDOR;
    private static String MYSQL_USER;
    private static String MYSQL_PASSWORD;
    private static String MYSQL_URL;
    private static String FALLBACK_DATABASE_PASSWORD;
    private static String IMQ_MYSQL;
    private static String IMQ_MYSQL_DSPROP;
    private static String IMQ_MYSQL_USER;
    private static String IMQ_MYSQL_PASSWORD;
    private static String IMQ_MYSQL_DSPROP_URL;
    private static String IMQ_FALLBACK_DATABASE_PASSWORD;
    private Properties dbProps = new Properties();
    private Properties brokerProps = new Properties();
    private Properties dsProps = new Properties();
    private HashMap<String, String[]> jmxConnectorEnv = null;
    private String jmxServiceURLList = null;
    private boolean isJMXServiceURLListValid = false;
    private String masterBroker = null;
    private String clusterBrokerList = null;

    public synchronized void start() throws ResourceAdapterInternalException {
        if (BROKER_TYPE_LOCAL.equals(this.brokerType)) {
            try {
                this.lbr = new LocalBrokerRunner(this.getBrokerUrl(), this.brokerInstanceName, this.brokerBindAddress, this.brokerPort, this.brokerHomeDir, this.brokerLibDir, this.brokerVarDir, this.brokerJavaDir, this.brokerArgs, this.useJNDIRmiServiceURL, this.rmiRegistryPort, this.startRmiRegistry, this.useSSLJMXConnector, this.brokerStartTimeout, this.adminUsername, this.adminPassFile, new EffectiveBrokerProps());
                this.lbr.start();
            }
            catch (Exception lbse) {
                ResourceAdapterInternalException raie = new ResourceAdapterInternalException("MQJMSRA_RA4001: start:Aborting:Exception starting LOCAL broker=" + lbse.getMessage());
                raie.initCause((Throwable)lbse);
                _loggerL.severe(raie.getMessage());
                _loggerL.info(this.toString());
                lbse.printStackTrace();
                _loggerL.throwing(_className, "start()", (Throwable)raie);
                throw raie;
            }
        }
        if (this.isInProcess()) {
            try {
                if (!_startedAtLeastOnce) {
                    _rmiRegistryPort = this.rmiRegistryPort;
                }
                if (this.ebr == null) {
                    this.ebr = new EmbeddedBrokerRunner(this.brokerInstanceName, this.brokerBindAddress, this.brokerPort, this.brokerHomeDir, this.brokerLibDir, this.brokerVarDir, this.brokerJavaDir, this.brokerArgs, this.useJNDIRmiServiceURL, _rmiRegistryPort, this.startRmiRegistry, this.useSSLJMXConnector, this.doBind, this._getEffectiveBrokerProps());
                    this.ebr.init();
                }
                this.ebr.start();
                LifecycleManagedBroker._setRAJMSService(this.ebr.getJMSService());
                _startedAtLeastOnce = true;
            }
            catch (Exception ebse) {
                ResourceAdapterInternalException raie = new ResourceAdapterInternalException("MQJMSRA_RA4001: start:Aborting:Exception starting EMBEDDED broker=" + ebse.getMessage());
                raie.initCause((Throwable)ebse);
                _loggerL.severe(raie.getMessage());
                _loggerL.info(this.toString());
                ebse.printStackTrace();
                _loggerL.throwing(_className, "start()", (Throwable)raie);
                throw raie;
            }
        }
        this.started = true;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void stop() {
        if (this.ebr != null) {
            this.ebr.stop();
            this.ebr = null;
        }
        if (this.lbr != null) {
            this.lbr.stop();
            this.lbr = null;
        }
        this.started = false;
    }

    private Properties _getEffectiveBrokerProps() {
        Properties props = new Properties();
        for (Map.Entry<Object, Object> thisEntry : this.brokerProps.entrySet()) {
            props.put(thisEntry.getKey(), thisEntry.getValue());
        }
        props.setProperty("imq.jmsra.managed", "true");
        props.setProperty("imq.cluster.nowaitForMasterBroker", "true");
        if (this.isInProcess()) {
            props.setProperty("imq.service.activate", "jmsdirect");
        }
        if (this.brokerEnableHA) {
            props.setProperty("imq.cluster.ha", "true");
            if (this.clusterId != null) {
                props.setProperty("imq.cluster.clusterid", this.clusterId);
            }
        } else {
            if (this.clusterBrokerList != null && !this.clusterBrokerList.equals("")) {
                props.setProperty("imq.cluster.brokerlist", this.clusterBrokerList);
            } else if (!props.containsKey("imq.cluster.brokerlist") && this.connectionURL != null && !"".equals(this.connectionURL)) {
                props.setProperty("imq.cluster.brokerlist", this.connectionURL);
            }
            if (this.masterBroker != null && !this.masterBroker.equals("")) {
                props.setProperty("imq.cluster.masterbroker", this.masterBroker);
            }
            if (this.nowaitForMasterBrokerTimeoutInSeconds > -1) {
                String strVal = String.valueOf(this.nowaitForMasterBrokerTimeoutInSeconds);
                props.setProperty("imq.cluster.nowaitForMasterBrokerTimeoutInSeconds", strVal);
            }
        }
        if (this.dbType != null) {
            props.setProperty("imq.persist.store", "jdbc");
            if (this.dbProps.containsKey(FALLBACK_DATABASE_PASSWORD)) {
                props.setProperty(IMQ_FALLBACK_DATABASE_PASSWORD, this.dbProps.getProperty(FALLBACK_DATABASE_PASSWORD));
            }
            if (DB_TYPE_MYSQL.equals(this.dbType)) {
                props.setProperty(IMQ_JDBC_VENDOR, this.dbType);
                props.setProperty(IMQ_BROKERID, this.brokerId);
                if (this.dbProps.containsKey(MYSQL_USER)) {
                    props.setProperty(IMQ_MYSQL_USER, this.dbProps.getProperty(MYSQL_USER));
                }
                if (this.dbProps.containsKey(MYSQL_PASSWORD)) {
                    props.setProperty(IMQ_MYSQL_PASSWORD, this.dbProps.getProperty(MYSQL_PASSWORD));
                }
                if (this.dsProps.containsKey(MYSQL_URL)) {
                    props.setProperty(IMQ_MYSQL_DSPROP_URL, this.dsProps.getProperty(MYSQL_URL));
                }
            }
        }
        String defaultAdminPassword = "admin";
        if (props.containsKey("imq.imqcmd.password")) {
            if (this.adminPassword == null) {
                this.adminPassword = props.getProperty("imq.imqcmd.password");
            } else {
                props.setProperty("imq.imqcmd.password", this.adminPassword);
            }
        } else if (this.adminPassword == null) {
            this.adminPassword = defaultAdminPassword;
            props.setProperty("imq.imqcmd.password", defaultAdminPassword);
        } else {
            props.setProperty("imq.imqcmd.password", this.adminPassword);
        }
        return props;
    }

    public synchronized JMSService _getJMSService() {
        if (this.ebr != null) {
            JMSService result = this.ebr.getJMSService();
            if (LifecycleManagedBroker._getRAJMSService() == null) {
                LifecycleManagedBroker._setRAJMSService(result);
            }
            return result;
        }
        return null;
    }

    public static final JMSService _getRAJMSService() {
        return jmsservice;
    }

    public static void _setRAJMSService(JMSService jmsserviceArg) {
        jmsservice = jmsserviceArg;
    }

    public synchronized void setStartRmiRegistry(boolean startRmiRegistry) {
        _loggerL.entering(_className, "setStartRmiRegistry()", startRmiRegistry);
        if (this.started || _startedAtLeastOnce && this.isInProcess()) {
            _loggerL.warning("MQJMSRA_RA2001: setStartRmiRegistry:RA already started OR run once as EMBEDDED:Disallowing change from:" + this.startRmiRegistry + ":to:" + startRmiRegistry);
            return;
        }
        this.startRmiRegistry = startRmiRegistry;
    }

    public synchronized boolean getStartRmiRegistry() {
        _loggerL.entering(_className, "getStartRmiRegistry()", this.startRmiRegistry);
        return this.startRmiRegistry;
    }

    public synchronized void setRmiRegistryPort(int rmiRegistryPort) {
        _loggerL.entering(_className, "setRmiRegistryPort()", rmiRegistryPort);
        if (this.started || _startedAtLeastOnce && this.isInProcess()) {
            _loggerL.warning("MQJMSRA_RA2001: setRmiRegistryPort:RA already started OR run once as EMBEDDED:Disallowing change from:" + this.rmiRegistryPort + ":to:" + rmiRegistryPort);
            return;
        }
        this.rmiRegistryPort = rmiRegistryPort;
    }

    public synchronized int getRmiRegistryPort() {
        _loggerL.entering(_className, "getRmiRegistryPort()", this.rmiRegistryPort);
        return this.rmiRegistryPort;
    }

    public synchronized String getBrokerType() {
        return this.brokerType;
    }

    public synchronized void setBrokerType(String brokerType) {
        _loggerL.entering(_className, "setBrokerType()", brokerType);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerType:lifecycle managed broker already started:Disallowing change from:" + this.brokerType + ":to:" + brokerType);
            return;
        }
        if (BROKER_TYPE_DIRECT.equals(brokerType) || BROKER_TYPE_EMBEDDED.equals(brokerType) || BROKER_TYPE_LOCAL.equals(brokerType) || BROKER_TYPE_REMOTE.equals(brokerType)) {
            this.brokerType = brokerType;
        } else {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerType:Invalid value:" + brokerType + ":remaining at brokerType=" + this.brokerType);
        }
    }

    public boolean isLocal() {
        return BROKER_TYPE_LOCAL.equals(this.brokerType);
    }

    public boolean isInProcess() {
        return BROKER_TYPE_DIRECT.equals(this.brokerType) | BROKER_TYPE_EMBEDDED.equals(this.brokerType);
    }

    public boolean isRemote() {
        return BROKER_TYPE_REMOTE.equals(this.brokerType);
    }

    public synchronized String getBrokerInstanceName() {
        _loggerL.entering(_className, "getBrokerInstanceName()", this.brokerInstanceName);
        return this.brokerInstanceName;
    }

    public synchronized void setBrokerInstanceName(String brokerInstanceName) {
        _loggerL.entering(_className, "setBrokerInstanceName()", brokerInstanceName);
        if (LifecycleManagedBroker.isNameValidAlphaNumeric_(brokerInstanceName)) {
            this.brokerInstanceName = brokerInstanceName;
        } else {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerInstanceName:Invalid value:" + brokerInstanceName);
        }
    }

    public synchronized void setBrokerBindAddress(String brokerBindAddress) {
        _loggerL.entering(_className, "setBrokerBindAddress()", brokerBindAddress);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerBindAddress:RA already started:Disallowing change from:" + this.brokerBindAddress + ":to:" + brokerBindAddress);
            return;
        }
        try {
            InetAddress.getByName(brokerBindAddress);
            this.brokerBindAddress = brokerBindAddress;
        }
        catch (UnknownHostException e) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerBindAddress:Ignoring Invalid Address:" + brokerBindAddress + ":ExceptionMsg=" + e.getMessage());
        }
    }

    public synchronized String getBrokerBindAddress() {
        _loggerL.entering(_className, "getBrokerBindAddress()", this.brokerBindAddress);
        return this.brokerBindAddress;
    }

    public synchronized void setBrokerPort(int brokerPort) {
        _loggerL.entering(_className, "setBrokerPort()", brokerPort);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerPort:RA already started:Disallowing change from:" + this.brokerPort + ":to:" + brokerPort);
            return;
        }
        this.brokerPort = brokerPort;
    }

    public synchronized int getBrokerPort() {
        _loggerL.entering(_className, "getBrokerPort()", this.brokerPort);
        return this.brokerPort;
    }

    public int getBrokerStartTimeout() {
        return this.brokerStartTimeout;
    }

    public void setBrokerStartTimeout(int brokerStartTimeout) {
        this.brokerStartTimeout = brokerStartTimeout;
    }

    public synchronized void setBrokerHomeDir(String brokerHomeDir) {
        _loggerL.entering(_className, "setBrokerHomeDir()", brokerHomeDir);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerHomeDir:RA already started:Disallowing change from:" + this.brokerHomeDir + ":to:" + brokerHomeDir);
            return;
        }
        try {
            String path;
            this.brokerHomeDir = path = new File(brokerHomeDir).getCanonicalPath();
        }
        catch (IOException e) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerHomeDir:Invalid value:" + brokerHomeDir + ":Exception Message=" + e.getMessage());
        }
    }

    public synchronized String getBrokerHomeDir() {
        _loggerL.entering(_className, "getBrokerHomeDir()", this.brokerHomeDir);
        return this.brokerHomeDir;
    }

    public synchronized void setBrokerLibDir(String brokerLibDir) {
        _loggerL.entering(_className, "setBrokerLibDir()", brokerLibDir);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerLibDir:RA already started:Disallowing change from:" + this.brokerLibDir + ":to:" + brokerLibDir);
            return;
        }
        try {
            String path;
            this.brokerLibDir = path = new File(brokerLibDir).getCanonicalPath();
        }
        catch (IOException e) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerLibDir:Invalid value:" + brokerLibDir + ":Exception Message=" + e.getMessage());
        }
    }

    public synchronized String getBrokerLibDir() {
        _loggerL.entering(_className, "getBrokerLibDir()", this.brokerLibDir);
        return this.brokerLibDir;
    }

    public synchronized void setBrokerVarDir(String brokerVarDir) {
        _loggerL.entering(_className, "setBrokerVarDir()", brokerVarDir);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerVarDir:RA already started:Disallowing change from:" + this.brokerVarDir + ":to:" + brokerVarDir);
            return;
        }
        try {
            String path;
            this.brokerVarDir = path = new File(brokerVarDir).getCanonicalPath();
        }
        catch (IOException e) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerVarDir:Invalid value:" + brokerVarDir + ":Exception Message=" + e.getMessage());
        }
    }

    public synchronized String getBrokerVarDir() {
        _loggerL.entering(_className, "getBrokerVarDir()", this.brokerVarDir);
        return this.brokerVarDir;
    }

    public synchronized void setBrokerJavaDir(String brokerJavaDir) {
        _loggerL.entering(_className, "setBrokerJavaDir()", brokerJavaDir);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerJavaDir:RA already started:Disallowing change from:" + this.brokerJavaDir + ":to:" + brokerJavaDir);
            return;
        }
        try {
            String path;
            this.brokerJavaDir = path = new File(brokerJavaDir).getCanonicalPath();
        }
        catch (IOException e) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerJavaDir:Invalid value:" + brokerJavaDir + ":Exception Message=" + e.getMessage());
        }
    }

    public synchronized String getBrokerJavaDir() {
        _loggerL.entering(_className, "getBrokerJavaDir()", this.brokerJavaDir);
        return this.brokerJavaDir;
    }

    public synchronized void setBrokerArgs(String brokerArgs) {
        _loggerL.entering(_className, "setBrokerArgs()", brokerArgs);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerArgs:RA already started:Disallowing change from:" + this.brokerArgs + ":to:" + brokerArgs);
            return;
        }
        this.brokerArgs = brokerArgs;
    }

    public synchronized String getBrokerArgs() {
        _loggerL.entering(_className, "getBrokerArgs()", this.brokerArgs);
        return this.brokerArgs;
    }

    public synchronized void setUseJNDIRmiServiceURL(boolean useJNDIRmiServiceURL) {
        _loggerL.entering(_className, "setUseJNDIRmiServiceURL()", useJNDIRmiServiceURL);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setUseJNDIRmiServiceURL:RA already started:Disallowing change from:" + this.useJNDIRmiServiceURL + ":to:" + useJNDIRmiServiceURL);
            return;
        }
        this.useJNDIRmiServiceURL = useJNDIRmiServiceURL;
    }

    public synchronized HashMap getJMXConnectorEnv() {
        _loggerL.entering(_className, "getJMXConnectorEnv()");
        if (this.jmxConnectorEnv == null) {
            this.jmxConnectorEnv = new HashMap();
            String[] credentials = new String[]{this.getAdminUsername(), this.getAdminPassword()};
            this.jmxConnectorEnv.put("jmx.remote.credentials", credentials);
        }
        return this.jmxConnectorEnv;
    }

    public synchronized String getJMXServiceURL() {
        _loggerL.entering(_className, "getJMXServiceURL()");
        if (!this.started) {
            _loggerL.warning("MQJMSRA_RA2001: getJMXServiceURL:RA not started:Returning null");
            return null;
        }
        if (this.jmxServiceURL == null && !BROKER_TYPE_REMOTE.equals(this.brokerType)) {
            AdminConnectionFactory tacf = new AdminConnectionFactory();
            try {
                tacf.setProperty("imqAddress", "mq://" + (this.getBrokerBindAddress() != null ? this.getBrokerBindAddress() : "localhost") + ":" + Integer.toString(this.getBrokerPort()) + "/jmxrmi");
                tacf.setProperty("imqDefaultAdminUsername", this.getAdminUsername());
                tacf.setProperty("imqDefaultAdminPassword", this.getAdminPassword());
            }
            catch (Exception e) {
                _loggerL.warning("MQJMSRA_RA4001: getJMXServiceURL:Exception configuring AdminConnectionFactory:Message=" + e.getMessage());
            }
            try {
                JMXServiceURL _jmxserviceURL = tacf.getJMXServiceURL();
                this.jmxServiceURL = _jmxserviceURL.toString();
            }
            catch (Exception e) {
                _loggerL.warning("MQJMSRA_RA4001: getJMXServiceURL:Exception:Message=" + e.getMessage());
            }
        }
        _loggerL.exiting(_className, "getJMXServiceURL()", this.jmxServiceURL);
        return this.jmxServiceURL;
    }

    public synchronized String getJMXServiceURLList() {
        _loggerL.entering(_className, "getJMXServiceURLList()", "For addressList = " + this.getConnectionURL());
        if (this.isJMXServiceURLListValid) {
            _loggerL.exiting(_className, "getJMXServiceURLList()", this.jmxServiceURLList);
            return this.jmxServiceURLList;
        }
        AdminConnectionFactory tacf = new AdminConnectionFactory();
        try {
            tacf.setProperty("imqDefaultAdminUsername", this.getAdminUsername());
            tacf.setProperty("imqDefaultAdminPassword", this.getAdminPassword());
        }
        catch (Exception e) {
            _loggerL.warning("MQJMSRA_RA4001: getJMXServiceURLList:Exception configuring AdminConnectionFactory:Message=" + e.getMessage());
        }
        StringBuilder jb = new StringBuilder(256);
        jb.append("");
        String jurl = null;
        StringTokenizer st = new StringTokenizer(this.getConnectionURL(), " ,");
        while (st.hasMoreTokens()) {
            String t = st.nextToken().trim();
            if (_loggerL.isLoggable(Level.FINER)) {
                _loggerL.finer("MQJMSRA_RA1101: getJMXServiceURLList:addressList component = " + t);
            }
            try {
                tacf.setProperty("imqAddress", t);
                if (_loggerL.isLoggable(Level.FINER)) {
                    _loggerL.finer("MQJMSRA_RA1101: getJMXServiceURLList:address=" + t);
                }
                jurl = tacf.getJMXServiceURL().toString();
                if (_loggerL.isLoggable(Level.FINER)) {
                    _loggerL.finer("MQJMSRA_RA1101: getJMXServiceURLList:JMXServiceURL string for addressList component " + t + " = " + jurl);
                }
                jb.append(jurl + " ");
            }
            catch (Exception e) {
                _loggerL.warning("MQJMSRA_RA4001: getJMXServiceURLList:Exception:Message=" + e.getMessage());
            }
        }
        this.jmxServiceURLList = jb.toString();
        this.isJMXServiceURLListValid = true;
        _loggerL.exiting(_className, "getJMXServiceURLList()", this.jmxServiceURLList);
        return this.jmxServiceURLList;
    }

    public synchronized boolean getUseJNDIRmiServiceURL() {
        _loggerL.entering(_className, "getUseJNDIRmiServiceURL()", this.useJNDIRmiServiceURL);
        return this.useJNDIRmiServiceURL;
    }

    public synchronized void setUseSSLJMXConnector(boolean useSSLJMXConnector) {
        _loggerL.entering(_className, "setUseSSLJMXConnector()", useSSLJMXConnector);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setUseSSLJMXConnector:RA already started:Disallowing change from:" + this.useSSLJMXConnector + ":to:" + useSSLJMXConnector);
            return;
        }
        this.useSSLJMXConnector = useSSLJMXConnector;
    }

    public synchronized boolean getUseSSLJMXConnector() {
        _loggerL.entering(_className, "getUseSSLJMXConnector()", this.useSSLJMXConnector);
        return this.useSSLJMXConnector;
    }

    public synchronized void setAdminUsername(String adminUsername) {
        _loggerL.entering(_className, "setAdminUsername()", adminUsername);
        this.adminUsername = adminUsername;
    }

    public synchronized String getAdminUsername() {
        _loggerL.entering(_className, "getAdminUsername()", this.adminUsername);
        return this.adminUsername;
    }

    public synchronized void setAdminPassword(String adminPassword) {
        _loggerL.entering(_className, "setAdminPassword()");
        this.adminPassword = adminPassword;
    }

    public synchronized String getAdminPassword() {
        _loggerL.entering(_className, "getAdminPassword()");
        return this.adminPassword;
    }

    public synchronized void setBrokerEnableHA(boolean brokerEnableHA) {
        _loggerL.entering(_className, "setBrokerEnableHA()", brokerEnableHA);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerEnableHA:RA already started:Disallowing change from:" + this.brokerEnableHA + ":to:" + brokerEnableHA);
            return;
        }
        this.brokerEnableHA = brokerEnableHA;
    }

    public synchronized boolean getBrokerEnableHA() {
        _loggerL.entering(_className, "getBrokerEnableHA()", this.brokerEnableHA);
        return this.brokerEnableHA;
    }

    public synchronized void setClusterId(String clusterId) {
        _loggerL.entering(_className, "setClusterId()", clusterId);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setClusterId:RA already started:Disallowing change from:" + this.clusterId + ":to:" + clusterId);
            return;
        }
        if (LifecycleManagedBroker.isNameValidAlphaNumeric_(clusterId)) {
            this.clusterId = clusterId;
        } else {
            _loggerL.warning("MQJMSRA_RA2001: setClusterId:Invalid value:" + clusterId);
        }
    }

    public synchronized String getClusterId() {
        _loggerL.entering(_className, "getClusterId()", this.clusterId);
        return this.clusterId;
    }

    public synchronized void setConnectionURL(String connectionURL) {
        String tConnectionURL = connectionURL;
        _loggerL.entering(_className, "setConnectionURL()", tConnectionURL);
        this.connectionURL = connectionURL;
        this.isJMXServiceURLListValid = false;
    }

    public synchronized String getConnectionURL() {
        _loggerL.entering(_className, "getConnectionURL()", this.connectionURL);
        if ("".equals(this.connectionURL)) {
            _loggerL.fine("MQJMSRA_RA1101: getConnectionURL:returning default of 'localhost' for empty connectionURL");
            return "localhost";
        }
        return this.connectionURL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void setMasterBroker(String newMasterBroker) {
        _loggerL.entering(_className, "setMasterBroker()", newMasterBroker);
        if (this.started && !this.isRemote()) {
            if (!this.updateMasterBroker(this.masterBroker, newMasterBroker)) throw new IllegalStateException("Cannot update master broker");
            this.masterBroker = newMasterBroker;
            return;
        } else {
            this.masterBroker = newMasterBroker;
        }
    }

    public synchronized String getMasterBroker() {
        _loggerL.entering(_className, "getMasterBroker()", this.masterBroker);
        return this.masterBroker;
    }

    public int getNowaitForMasterBrokerTimeoutInSeconds() {
        return this.nowaitForMasterBrokerTimeoutInSeconds;
    }

    public void setNowaitForMasterBrokerTimeoutInSeconds(int nowaitForMasterBrokerTimeoutInSeconds) {
        this.nowaitForMasterBrokerTimeoutInSeconds = nowaitForMasterBrokerTimeoutInSeconds;
    }

    public synchronized void setBrokerId(String brokerId) {
        _loggerL.entering(_className, "setBrokerId()", brokerId);
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerId:RA already started:Disallowing change from:" + this.brokerId + ":to:" + brokerId);
            return;
        }
        if (LifecycleManagedBroker.isNameValidAlphaNumeric_(brokerId)) {
            this.brokerId = brokerId;
        } else {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerId:Invalid value:" + brokerId);
        }
    }

    public synchronized String getBrokerId() {
        _loggerL.entering(_className, "getBrokerId()", this.brokerId);
        return this.brokerId;
    }

    public synchronized void setBrokerProps(Properties brokerProps) {
        _loggerL.entering(_className, "setBrokerProps()");
        if (this.started) {
            _loggerL.warning("MQJMSRA_RA2001: setBrokerProps:RA already started:Disallowing change of broker properties");
            return;
        }
        this.brokerProps = brokerProps;
    }

    public synchronized void setBrokerProps(String aString) {
        Properties props = new Properties();
        try {
            byte[] bytes = aString.getBytes();
            ByteArrayInputStream byteInStream = new ByteArrayInputStream(bytes);
            props.load(byteInStream);
        }
        catch (IOException e) {
            _loggerL.log(Level.WARNING, "MQJMSRA_RA2001: setBrokerProps: Exception reading properties as string", e);
        }
        this.setBrokerProps(props);
    }

    public synchronized Properties getBrokerProps() {
        _loggerL.entering(_className, "getBrokerProps()");
        return this.brokerProps;
    }

    public void setClusterBrokerList(String clusterBrokerList) {
        _loggerL.entering(_className, "setClusterBrokerList()", clusterBrokerList);
        this.clusterBrokerList = clusterBrokerList;
        if (this.started && !this.isRemote()) {
            this.updateClusterBrokerList(clusterBrokerList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClusterBrokerList(String newClusterBrokerList) {
        Connection connection;
        int timeout = 60000;
        MessageConsumer replyReceiver = null;
        Message replyMessage = null;
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setConnectionType("ADMIN");
        try {
            connectionFactory.setProperty("imqAddressList", this.getBrokerUrl() + "/admin");
            connection = connectionFactory.createConnection(this.getAdminUsername(), this.getAdminPassword());
        }
        catch (JMSException e) {
            _loggerL.log(Level.SEVERE, "MQJMSRA_RA3001: setClusterBrokerList(): Cannot send updated broker list to managed broker: error creating connection: ", e);
            return;
        }
        try {
            try {
                Session session = connection.createSession(false, 1);
                TemporaryQueue replyQueue = session.createTemporaryQueue();
                replyReceiver = session.createConsumer((Destination)replyQueue);
                connection.start();
                Queue adminQueue = session.createQueue("__JMQAdmin");
                MessageProducer sender = session.createProducer((Destination)adminQueue);
                ObjectMessage updateMessage = session.createObjectMessage();
                updateMessage.setJMSReplyTo((Destination)replyQueue);
                updateMessage.setIntProperty("JMQMessageType", 94);
                updateMessage.setStringProperty("JMQClusterBrokerList", newClusterBrokerList);
                sender.send((Message)updateMessage, 1, 4, 0L);
            }
            catch (JMSException e) {
                _loggerL.log(Level.SEVERE, "MQJMSRA_RA3001: setClusterBrokerList(): Cannot send updated broker list to managed broker: error sending update: ", e);
                try {
                    connection.close();
                }
                catch (JMSException e2) {
                    _loggerL.log(Level.WARNING, "MQJMSRA_RA2001: setClusterBrokerList(): Error closing connection to broker after successful update: ", e2);
                }
                return;
            }
            replyMessage = replyReceiver.receive((long)timeout);
            if (replyMessage == null) {
                _loggerL.log(Level.SEVERE, "MQJMSRA_RA3001: setClusterBrokerList(): Error sending updated broker list to managed broker: no reply received from broker after " + timeout + "ms");
                return;
            }
            try {
                if (replyMessage.getIntProperty("JMQStatus") != 200 && replyMessage.getIntProperty("JMQMessageType") != 95) {
                    _loggerL.log(Level.SEVERE, "MQJMSRA_RA3001: setClusterBrokerList(): Error sending updated broker list to managed broker. Reply received from broker: JMQStatus=" + replyMessage.getIntProperty("JMQStatus") + ", JMQMessageTypee=" + replyMessage.getIntProperty("JMQMessageType"));
                }
            }
            catch (JMSException e) {
                _loggerL.log(Level.SEVERE, "MQJMSRA_RA3001: setClusterBrokerList(): Error sending updated broker list to managed broker: error receiving reply from broker: ", e);
                return;
            }
        }
        finally {
            try {
                connection.close();
            }
            catch (JMSException e) {
                _loggerL.log(Level.WARNING, "MQJMSRA_RA2001: setClusterBrokerList(): Error closing connection to broker after successful update: ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateMasterBroker(String oldMasterBroker, String newMasterBroker) {
        Connection connection;
        int timeout = 60000;
        MessageConsumer replyReceiver = null;
        Message replyMessage = null;
        ConnectionFactory connectionFactory = new ConnectionFactory();
        connectionFactory.setConnectionType("ADMIN");
        try {
            connectionFactory.setProperty("imqAddressList", this.getBrokerUrl() + "/admin");
            connection = connectionFactory.createConnection(this.getAdminUsername(), this.getAdminPassword());
        }
        catch (JMSException e) {
            _loggerL.log(Level.SEVERE, "MQJMSRA_RA3001: setMasterBroker(): Cannot send updated master broker to managed broker: error creating connection: ", e);
            return false;
        }
        try {
            try {
                Session session = connection.createSession(false, 1);
                TemporaryQueue replyQueue = session.createTemporaryQueue();
                replyReceiver = session.createConsumer((Destination)replyQueue);
                connection.start();
                Queue adminQueue = session.createQueue("__JMQAdmin");
                MessageProducer sender = session.createProducer((Destination)adminQueue);
                ObjectMessage updateMessage = session.createObjectMessage();
                updateMessage.setJMSReplyTo((Destination)replyQueue);
                updateMessage.setIntProperty("JMQMessageType", 96);
                updateMessage.setStringProperty("JMQClusterOldMasterBroker", oldMasterBroker);
                updateMessage.setStringProperty("JMQClusterNewMasterBroker", newMasterBroker);
                updateMessage.setBooleanProperty("JMQJMSRAManagedBroker", true);
                updateMessage.setBooleanProperty("JMQJMSRANotificationOnly", true);
                sender.send((Message)updateMessage, 1, 4, 0L);
            }
            catch (JMSException e) {
                _loggerL.log(Level.SEVERE, "MQJMSRA_RA3001: setMasterBroker(): Cannot send updated master broker to managed broker: error sending update: ", e);
                boolean replyQueue = false;
                try {
                    connection.close();
                }
                catch (JMSException e2) {
                    _loggerL.log(Level.WARNING, "MQJMSRA_RA2001: setMasterBroker(): Error closing connection to broker after successful update: ", e2);
                }
                return replyQueue;
            }
            replyMessage = replyReceiver.receive((long)timeout);
            if (replyMessage == null) {
                _loggerL.log(Level.SEVERE, "MQJMSRA_RA3001: setMasterBroker(): Error sending updated master broker to managed broker: no reply received from broker after " + timeout + "ms");
                boolean e = false;
                return e;
            }
            if (replyMessage.getIntProperty("JMQStatus") != 200 && replyMessage.getIntProperty("JMQMessageType") != 97) {
                _loggerL.log(Level.SEVERE, "MQJMSRA_RA3001: setClusterBrokerList(): Error sending updated broker list to managed broker. Reply received from broker: JMQStatus=" + replyMessage.getIntProperty("JMQStatus") + ", JMQMessageTypee=" + replyMessage.getIntProperty("JMQMessageType"));
                boolean e = false;
                return e;
            }
        }
        finally {
            try {
                connection.close();
            }
            catch (JMSException e) {
                _loggerL.log(Level.WARNING, "MQJMSRA_RA2001: setMasterBroker(): Error closing connection to broker after successful update: ", e);
            }
        }
        return true;
    }

    private String getBrokerUrl() {
        return (this.brokerBindAddress == null ? "localhost" : this.brokerBindAddress) + ":" + this.brokerPort;
    }

    public String getClusterBrokerList() {
        _loggerL.entering(_className, "getClusterBrokerList()", this.clusterBrokerList);
        return this.clusterBrokerList;
    }

    public boolean isDoBind() {
        return this.doBind;
    }

    public void setDoBind(boolean doBind) {
        this.doBind = doBind;
    }

    public PortMapperClientHandler getPortMapperClientHandler() {
        if (this.isRemote() || this.isLocal()) {
            throw new IllegalStateException("Cannot access PortMapperClientHandler for LOCAL or REMOTE brokers");
        }
        if (this.isStarted()) {
            return Globals.getPortMapper();
        }
        throw new IllegalStateException("Cannot access PortMapperClientHandler until embedded broker has been started ");
    }

    private static boolean isNameValidAlphaNumeric_(String name) {
        if (name == null || "".equals(name)) {
            return false;
        }
        char[] namechars = name.toCharArray();
        for (int i = 0; i < namechars.length; ++i) {
            if (Character.isLetterOrDigit(namechars[i]) || namechars[i] == '_') continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "SJSMQ LifecycleManagedBroker configuration=\n\tbrokerInstanceName       =" + this.brokerInstanceName + "\n\tbrokerBindAddress        =" + this.brokerBindAddress + "\n\tbrokerPort               =" + this.brokerPort + "\n\tbrokerHomeDir            =" + this.brokerHomeDir + "\n\tbrokerLibDir             =" + this.brokerLibDir + "\n\tbrokerVarDir             =" + this.brokerVarDir + "\n\tbrokerJavaDir            =" + this.brokerJavaDir + "\n\tbrokerArgs               =" + this.brokerArgs + "\n\tMasterBroker             =" + this.masterBroker + "\n\tbrokerId                 =" + this.brokerId + "\n\tadminUsername            =" + this.adminUsername + "\n\tadminPassword            =" + ("admin".equals(this.adminPassword) ? "<default>" : "<modified>") + "\n\tadminPassFile            =" + this.adminPassFile + "\n\tConnectionURL            =" + this.connectionURL + "\n\tdbType                   =" + this.dbType + "\n\tdbProps                  =" + (this.dbProps != null ? this.dbProps.toString() : "null") + "\n\tdsProps                  =" + (this.dsProps != null ? this.dsProps.toString() : "null") + "\n\tuseJNDIRmiServiceURL     =" + this.useJNDIRmiServiceURL + "\n\tuseSSLJMXConnector       =" + this.useSSLJMXConnector + "\n\tbrokerEnableHA           =" + this.brokerEnableHA + "\n\tclusterId                =" + this.clusterId + "\n\trmiRegistryPort          =" + this.rmiRegistryPort + "\n\tstartRmiRegistry         =" + this.startRmiRegistry + "\n\tbrokerStartTimeout       =\tjmxServiceURL            =" + this.jmxServiceURL + "\n" + this.brokerStartTimeout + "\n";
    }

    static {
        IMQ_BROKERID = "imq.brokerid";
        IMQ_JDBC_VENDOR = "imq.persist.jdbc.dbVendor";
        MYSQL_USER = "mysql.user";
        MYSQL_PASSWORD = "mysql.password";
        MYSQL_URL = "mysqlproperty.url";
        FALLBACK_DATABASE_PASSWORD = "jdbc.password";
        IMQ_MYSQL = "imq.persist.jdbc.mysql";
        IMQ_MYSQL_DSPROP = IMQ_MYSQL + ".property";
        IMQ_MYSQL_USER = IMQ_MYSQL + ".user";
        IMQ_MYSQL_PASSWORD = IMQ_MYSQL + ".password";
        IMQ_MYSQL_DSPROP_URL = IMQ_MYSQL_DSPROP + ".url";
        IMQ_FALLBACK_DATABASE_PASSWORD = "imq.persist.jdbc.password";
    }

    public class EffectiveBrokerProps
    implements PropertiesHolder {
        @Override
        public Properties getProperties() {
            return LifecycleManagedBroker.this._getEffectiveBrokerProps();
        }
    }
}

