/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.BasicQueue;
import com.sun.messaging.BasicTopic;
import com.sun.messaging.jmq.io.JMSPacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.ConsumerClosedNoDeliveryException;
import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jmq.jmsservice.JMSAck;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceException;
import com.sun.messaging.jmq.jmsservice.JMSServiceReply;
import com.sun.messaging.jms.IllegalStateException;
import com.sun.messaging.jms.JMSException;
import com.sun.messaging.jms.ra.DirectAck;
import com.sun.messaging.jms.ra.DirectBytesPacket;
import com.sun.messaging.jms.ra.DirectConnection;
import com.sun.messaging.jms.ra.DirectConsumer;
import com.sun.messaging.jms.ra.DirectMapPacket;
import com.sun.messaging.jms.ra.DirectObjectPacket;
import com.sun.messaging.jms.ra.DirectPacket;
import com.sun.messaging.jms.ra.DirectProducer;
import com.sun.messaging.jms.ra.DirectQueueBrowser;
import com.sun.messaging.jms.ra.DirectStreamPacket;
import com.sun.messaging.jms.ra.DirectTextPacket;
import com.sun.messaging.jms.ra.DirectXAResource;
import com.sun.messaging.jms.ra.MessageListener;
import com.sun.messaging.jms.ra.ResourceAdapter;
import com.sun.messaging.jms.ra.TemporaryDestination;
import com.sun.messaging.jms.ra.TemporaryQueue;
import com.sun.messaging.jms.ra.TemporaryTopic;
import jakarta.jms.BytesMessage;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectSession
implements Session,
QueueSession,
TopicSession {
    protected JMSService jmsservice;
    protected DirectConnection dc;
    protected long connectionId;
    protected long sessionId;
    protected JMSService.SessionAckMode ackMode;
    protected boolean isClosed;
    protected boolean isClosing;
    protected boolean isStopped;
    protected boolean isAsync;
    protected boolean inDeliver;
    protected long deliverThreadId = 0L;
    protected boolean enableThreadCheck = false;
    protected boolean isMDBSession = false;
    private boolean isXATransacted;
    protected long transactionId = 0L;
    protected boolean ackOnFetch = false;
    private Vector<DirectConsumer> consumers = null;
    private Vector<DirectProducer> producers = null;
    private Vector<DirectQueueBrowser> browsers = null;
    private ArrayList<SysMessageID> unackedMessageIDs = null;
    private ArrayList<Long> unackedConsumerIDs = null;
    private static final String _className = "com.sun.messaging.jms.ra.DirectSession";
    private static final String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    private static final String _lgrNameJMSSession = "jakarta.jms.Session.mqjmsra";
    protected static final Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    protected static final Logger _loggerJS = Logger.getLogger("jakarta.jms.Session.mqjmsra");
    private static final String _lgrMIDPrefix = "MQJMSRA_DS";
    protected static final String _lgrMID_EET = "MQJMSRA_DS1001: ";
    protected static final String _lgrMID_INF = "MQJMSRA_DS1101: ";
    protected static final String _lgrMID_WRN = "MQJMSRA_DS2001: ";
    protected static final String _lgrMID_ERR = "MQJMSRA_DS3001: ";
    protected static final String _lgrMID_EXC = "MQJMSRA_DS4001: ";
    protected static final int _logLevel;
    protected static final boolean _logFINE;

    public DirectSession(DirectConnection dc, JMSService jmsservice, long sessionId, JMSService.SessionAckMode ackMode) throws jakarta.jms.JMSException {
        Object[] params = new Object[]{dc, jmsservice, sessionId, ackMode};
        _loggerOC.entering(_className, "constructor()", params);
        this.dc = dc;
        this.jmsservice = jmsservice;
        this.connectionId = dc.getConnectionId();
        this.sessionId = sessionId;
        this.ackMode = ackMode;
        this.producers = new Vector();
        this.consumers = new Vector();
        this.browsers = new Vector();
        this.unackedMessageIDs = new ArrayList();
        this.unackedConsumerIDs = new ArrayList();
        this._initSession();
    }

    public synchronized void close() throws jakarta.jms.JMSException {
        _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":close()");
        if (this.isClosed) {
            return;
        }
        this.dc.removeSession(this);
        this._close();
    }

    public void commit() throws jakarta.jms.JMSException {
        String methodName = "commit()";
        _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName);
        this._checkIfClosed(methodName);
        this._checkTransactedState(methodName, true);
        try {
            this.jmsservice.commitTransaction(this.connectionId, this.transactionId, null, 0);
        }
        catch (JMSServiceException jmsse) {
            _loggerJS.warning("MQJMSRA_DS2001: sessionId=" + this.sessionId + ":" + methodName + ":JMSServiceException=" + jmsse.getMessage());
        }
        this._startTransaction(methodName);
    }

    public QueueBrowser createBrowser(Queue queue) throws jakarta.jms.JMSException {
        return this._createAndAddBrowser("createBrowser(Queue)", queue, null);
    }

    public QueueBrowser createBrowser(Queue queue, String selector) throws jakarta.jms.JMSException {
        return this._createAndAddBrowser("createBrowser(Queue, Selector)", queue, selector);
    }

    public BytesMessage createBytesMessage() throws jakarta.jms.JMSException {
        String methodName = "createBytesMessage()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        return new DirectBytesPacket(this);
    }

    public MessageConsumer createConsumer(jakarta.jms.Destination destination) throws jakarta.jms.JMSException {
        return this._createAndAddConsumer("createConsumer(Destination)", destination, null, false);
    }

    public MessageConsumer createConsumer(jakarta.jms.Destination destination, String selector) throws jakarta.jms.JMSException {
        return this._createAndAddConsumer("createConsumer(Destination, selector)", destination, selector, false);
    }

    public MessageConsumer createConsumer(jakarta.jms.Destination destination, String selector, boolean noLocal) throws jakarta.jms.JMSException {
        return this._createAndAddConsumer("createConsumer(Destination, selector, noLocal)", destination, selector, noLocal);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws jakarta.jms.JMSException {
        return this._createAndAddConsumer("createDurableSubscriber(Topic, name)", (jakarta.jms.Destination)topic, null, name, true, false, false, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws jakarta.jms.JMSException {
        return this._createAndAddConsumer("createDurableSubscriber(Topic, name, selector, noLocal)", (jakarta.jms.Destination)topic, selector, name, true, false, false, noLocal);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws jakarta.jms.JMSException {
        return this.createDurableSubscriber(topic, name);
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws jakarta.jms.JMSException {
        return this.createDurableSubscriber(topic, name, messageSelector, noLocal);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws jakarta.jms.JMSException {
        return this.createSharedConsumer(topic, sharedSubscriptionName, null);
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws jakarta.jms.JMSException {
        boolean noLocal = false;
        return this._createAndAddConsumer("createSharedConsumer(Topic, sharedSubscriptionName, messageSelector)", (jakarta.jms.Destination)topic, messageSelector, sharedSubscriptionName, false, true, true, noLocal);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws jakarta.jms.JMSException {
        return this.createSharedDurableConsumer(topic, name, null);
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws jakarta.jms.JMSException {
        boolean noLocal = false;
        return this._createAndAddConsumer("createSharedDurableConsumer(Topic, name, messageSelector)", (jakarta.jms.Destination)topic, messageSelector, name, true, true, true, noLocal);
    }

    public MapMessage createMapMessage() throws jakarta.jms.JMSException {
        String methodName = "createMapMessage()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        return new DirectMapPacket(this);
    }

    public Message createMessage() throws jakarta.jms.JMSException {
        String methodName = "createMessage()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        return new DirectPacket(this);
    }

    public ObjectMessage createObjectMessage() throws jakarta.jms.JMSException {
        String methodName = "createObjectMessage()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        return new DirectObjectPacket(this, null);
    }

    public ObjectMessage createObjectMessage(Serializable object) throws jakarta.jms.JMSException {
        String methodName = "createObjectMessage(object)";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        return new DirectObjectPacket(this, object);
    }

    public MessageProducer createProducer(jakarta.jms.Destination destination) throws jakarta.jms.JMSException {
        return this._createAndAddProducer("createProducer()", destination);
    }

    public Queue createQueue(String queueName) throws jakarta.jms.JMSException {
        String methodName = "createQueue(queueName)";
        _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName + "=" + queueName);
        this._checkIfClosed(methodName);
        return new BasicQueue(queueName);
    }

    public StreamMessage createStreamMessage() throws jakarta.jms.JMSException {
        String methodName = "createStreamMessage()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        return new DirectStreamPacket(this);
    }

    public jakarta.jms.TemporaryQueue createTemporaryQueue() throws jakarta.jms.JMSException {
        String methodName = "createTemporaryQueue()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        TemporaryQueue tq = new TemporaryQueue(this.dc);
        this.dc._createDestination(tq._getDestination());
        this.dc.addTemporaryDestination(tq);
        return tq;
    }

    public jakarta.jms.TemporaryTopic createTemporaryTopic() throws jakarta.jms.JMSException {
        String methodName = "createTemporaryTopic()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        TemporaryTopic tt = new TemporaryTopic(this.dc);
        this.dc._createDestination(tt._getDestination());
        this.dc.addTemporaryDestination(tt);
        return tt;
    }

    public TextMessage createTextMessage() throws jakarta.jms.JMSException {
        String methodName = "createTextMessage()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        return new DirectTextPacket(this, null);
    }

    public TextMessage createTextMessage(String text) throws jakarta.jms.JMSException {
        String methodName = "createTextMessage(text)";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        return new DirectTextPacket(this, text);
    }

    public Topic createTopic(String topicName) throws jakarta.jms.JMSException {
        String methodName = "createTopic(topicName)";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName + "=" + topicName);
        }
        this._checkIfClosed(methodName);
        return new BasicTopic(topicName);
    }

    public int getAcknowledgeMode() throws jakarta.jms.JMSException {
        String methodName = "getAcknowledgeMode()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        switch (this.ackMode) {
            case AUTO_ACKNOWLEDGE: {
                return 1;
            }
            case CLIENT_ACKNOWLEDGE: {
                return 2;
            }
            case DUPS_OK_ACKNOWLEDGE: {
                return 3;
            }
            case TRANSACTED: {
                return 0;
            }
            case NO_ACKNOWLEDGE: {
                return 32768;
            }
        }
        throw new jakarta.jms.JMSException(methodName + ":Unknown aknowledge mode");
    }

    public MessageListener getMessageListener() throws jakarta.jms.JMSException {
        String methodName = "getMessageListener()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        return null;
    }

    public boolean getTransacted() throws jakarta.jms.JMSException {
        String methodName = "getTransacted()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        return this.getTransactedNoCheck();
    }

    protected boolean getTransactedNoCheck() {
        return this.ackMode == JMSService.SessionAckMode.TRANSACTED;
    }

    public void recover() throws jakarta.jms.JMSException {
        String methodName = "recover()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        this._checkTransactedState(methodName, false);
        if (this._isMDBSession() || this.ackMode != JMSService.SessionAckMode.CLIENT_ACKNOWLEDGE) {
            return;
        }
        try {
            this.jmsservice.redeliverMessages(this.connectionId, this.sessionId, this.unackedMessageIDs.toArray(new SysMessageID[0]), this.unackedConsumerIDs.toArray(new Long[0]), this.transactionId, true);
        }
        catch (JMSServiceException jmsse) {
            jmsse.getJMSServiceReply().getStatus();
            String failure_cause = "unknown JMSService error";
            String exerrmsg = "redeliverMessage on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and sessionId:" + this.sessionId + " due to " + failure_cause;
            _loggerJS.severe(exerrmsg);
            jakarta.jms.JMSException jmse = new jakarta.jms.JMSException(exerrmsg);
            jmse.initCause((Throwable)jmsse);
            throw jmse;
        }
        finally {
            this.unackedMessageIDs.clear();
            this.unackedConsumerIDs.clear();
        }
    }

    public void rollback() throws jakarta.jms.JMSException {
        String methodName = "rollback()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        this._checkTransactedState(methodName, true);
        this._rollback(methodName);
        this._startTransaction(methodName);
    }

    public void run() {
        String methodName = "run()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName);
        }
        try {
            this._checkIfClosed(methodName);
            this._checkTransactedState(methodName, false);
            this._unsupported("Session.recover()");
        }
        catch (jakarta.jms.JMSException ex) {
            _loggerJS.severe(_lgrMID_EXC + "sessionId=" + this.sessionId + ":" + methodName + ex.getMessage());
            throw new RuntimeException(ex);
        }
    }

    public void setMessageListener(jakarta.jms.MessageListener listener) throws jakarta.jms.JMSException {
        String methodName = "setMessageListener()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName);
        }
        this._unsupported("Session.setMessageListener()");
        this._checkIfClosed(methodName);
    }

    public void unsubscribe(String name) throws jakarta.jms.JMSException {
        String methodName = "unsubscribe()";
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        if (name == null || "".equals(name)) {
            throw new InvalidDestinationException("NULL or empty name for unsubscribe");
        }
        DirectConsumer dc2 = null;
        for (DirectConsumer dc2 : this.dc._getDurableConsumers()) {
            if (!name.equals(dc2.getDurableName())) continue;
            String exErrMsg = "MQJMSRA_DS2001: sessionId=" + this.sessionId + ":" + methodName + ":name:" + name + ":Is in use";
            _loggerJS.warning(exErrMsg);
            jakarta.jms.JMSException jmse = new jakarta.jms.JMSException(exErrMsg);
            throw jmse;
        }
        try {
            this.jmsservice.deleteConsumer(this.connectionId, this.sessionId, 0L, null, false, name, this.dc._getClientID());
        }
        catch (JMSServiceException jmsse) {
            String exErrMsg = "MQJMSRA_DS4001: sessionId=" + this.sessionId + ":" + methodName + ":name:" + name + ":error=" + jmsse.getMessage();
            _loggerJS.warning(exErrMsg);
            InvalidDestinationException jmse = new InvalidDestinationException(exErrMsg);
            jmse.initCause((Throwable)jmsse);
            throw jmse;
        }
    }

    public QueueReceiver createReceiver(Queue queue) throws jakarta.jms.JMSException {
        return this._createAndAddConsumer("createReceiver(Queue)", (jakarta.jms.Destination)queue, null, false);
    }

    public QueueReceiver createReceiver(Queue queue, String selector) throws jakarta.jms.JMSException {
        return this._createAndAddConsumer("createReceiver(Queue, selector)", (jakarta.jms.Destination)queue, selector, false);
    }

    public QueueSender createSender(Queue queue) throws jakarta.jms.JMSException {
        return this._createAndAddProducer("createSender(Queue)", (jakarta.jms.Destination)queue);
    }

    public TopicPublisher createPublisher(Topic topic) throws jakarta.jms.JMSException {
        return this._createAndAddProducer("createPublisher()", (jakarta.jms.Destination)topic);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws jakarta.jms.JMSException {
        return this._createAndAddConsumer("createSubscriber(Topic)", (jakarta.jms.Destination)topic, null, false);
    }

    public TopicSubscriber createSubscriber(Topic topic, String selector, boolean noLocal) throws jakarta.jms.JMSException {
        return this._createAndAddConsumer("createSubscriber(Topic, selector, noLocal)", (jakarta.jms.Destination)topic, selector, noLocal);
    }

    protected void _initSession() throws jakarta.jms.JMSException {
        String methodName = "_initSession()";
        _loggerOC.entering(_className, methodName);
        this.isAsync = false;
        this.inDeliver = false;
        this.isClosed = false;
        this.isClosing = false;
        this.isStopped = true;
        boolean bl = this.ackOnFetch = this.ackMode == JMSService.SessionAckMode.AUTO_ACKNOWLEDGE || this.ackMode == JMSService.SessionAckMode.TRANSACTED || this.ackMode == JMSService.SessionAckMode.DUPS_OK_ACKNOWLEDGE;
        if (this.isTransacted() && !this.dc.isManaged()) {
            this._startTransaction(methodName);
        }
        if (!this.dc.isStopped()) {
            this._start();
        }
    }

    protected void _start() {
        this.isStopped = false;
        try {
            this.jmsservice.startSession(this.connectionId, this.sessionId);
        }
        catch (JMSServiceException jmsse) {
            _loggerJS.warning("MQJMSRA_DS2001: sessionId=" + this.sessionId + ":_start():JMSService.startSession():JMSServiceException=" + jmsse.getMessage());
        }
    }

    protected void _startTransaction(String fromMethod) throws jakarta.jms.JMSException {
        JMSServiceReply reply = null;
        try {
            reply = this.jmsservice.startTransaction(this.connectionId, this.sessionId, null, 0, JMSService.TransactionAutoRollback.UNSPECIFIED, 0L);
            try {
                this.transactionId = reply.getJMQTransactionID();
            }
            catch (NoSuchFieldException nsfe) {
                String exerrmsg = "MQJMSRA_DS4001: sessionId=" + this.sessionId + ":_startTransaction from " + fromMethod + ":JMSServiceException:Missing JMQTransactionID";
                jakarta.jms.JMSException jmse = new jakarta.jms.JMSException(exerrmsg);
                jmse.initCause((Throwable)nsfe);
                _loggerJS.severe(exerrmsg);
                throw jmse;
            }
        }
        catch (JMSServiceException jmsse) {
            _loggerJS.severe("MQJMSRA_DS4001: sessionId=" + this.sessionId + ":_startTransaction from " + fromMethod + "JMSServiceException=" + jmsse.getMessage());
        }
    }

    protected void _rollback(String methodName) throws jakarta.jms.JMSException {
        try {
            this.jmsservice.rollbackTransaction(this.connectionId, this.transactionId, null, true, true);
        }
        catch (JMSServiceException jmsse) {
            _loggerJS.warning("MQJMSRA_DS2001: sessionId=" + this.sessionId + ":" + methodName + ":JMSServiceException=" + jmsse.getMessage());
        }
    }

    protected void _stop() {
        try {
            this.jmsservice.stopSession(this.connectionId, this.sessionId, true);
        }
        catch (JMSServiceException jmsse) {
            _loggerJS.warning("MQJMSRA_DS2001: sessionId=" + this.sessionId + ":_stop():JMSService.stopSession():JMSServiceException=" + jmsse.getMessage());
        }
    }

    public final DirectConnection getConnection() {
        return this.dc;
    }

    public final long getConnectionId() {
        return this.connectionId;
    }

    public final long getSessionId() {
        return this.sessionId;
    }

    protected long _getTransactionId() {
        return this.transactionId;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized boolean isAsync() {
        return this.isAsync;
    }

    protected synchronized void _setAsync(boolean isAsync) {
        this.isAsync = isAsync;
    }

    protected final synchronized boolean inDeliver() {
        return this.inDeliver;
    }

    public synchronized boolean isXATransacted() {
        return this.isXATransacted;
    }

    public boolean isTransacted() {
        return this.ackMode == JMSService.SessionAckMode.TRANSACTED;
    }

    private void _checkIfClosed(String methodname) throws jakarta.jms.JMSException {
        if (this.isClosed()) {
            String closedmsg = _lgrMID_EXC + methodname + "Session is closed:Id=" + this.sessionId;
            _loggerJS.warning(closedmsg);
            throw new jakarta.jms.IllegalStateException(closedmsg);
        }
    }

    private void _checkTransactedState(String methodName, boolean allowIfTransacted) throws jakarta.jms.JMSException {
        String illegalStateMsg = null;
        if (this.isTransacted() && !allowIfTransacted) {
            illegalStateMsg = _lgrMID_EXC + methodName + ":Illegal for a transacted Session:sessionId=" + this.sessionId;
        } else if (!this.isTransacted() && allowIfTransacted) {
            illegalStateMsg = _lgrMID_EXC + methodName + ":Illegal for a non-transacted Session:sessionId=" + this.sessionId;
        }
        if (illegalStateMsg != null) {
            _loggerJS.warning(illegalStateMsg);
            throw new jakarta.jms.IllegalStateException(illegalStateMsg);
        }
    }

    protected synchronized void _close() throws jakarta.jms.JMSException {
        if (this.isClosed) {
            return;
        }
        this.isClosing = true;
        if (this.isTransacted() && !this.dc.isManaged()) {
            this._rollback("_close()");
        }
        this._closeAndClearProducers();
        this._stop();
        this._closeAndClearConsumers();
        this._closeAndClearBrowsers();
        try {
            this.jmsservice.destroySession(this.connectionId, this.sessionId);
        }
        catch (JMSServiceException jmsse) {
            _loggerJS.warning("MQJMSRA_DS2001: sessionId=" + this.sessionId + ":close():JMSService.destroySession():JMSServiceException=" + jmsse.getMessage());
        }
        this.isClosed = true;
        this.isClosing = false;
    }

    private Destination _checkDestinationForConsumer(jakarta.jms.Destination destination) throws jakarta.jms.JMSException {
        Destination _destination = null;
        if (destination == null) {
            String jmserrmsg = "MQJMSRA_DS4001: _checkDestination:Destination is null";
            InvalidDestinationException jmse = new InvalidDestinationException(jmserrmsg);
            _loggerJS.severe(jmserrmsg);
            throw jmse;
        }
        String _name = null;
        Destination.Type _type = Destination.Type.QUEUE;
        Destination.Life _life = Destination.Life.STANDARD;
        if (destination instanceof TemporaryDestination) {
            if (!this.dc._hasTemporaryDestination((TemporaryDestination)destination)) {
                String jmserrmsg = "MQJMSRA_DS4001: _checkDestination:Temporary Destination not owned by  parent connectionId=" + this.dc.getConnectionId();
                jakarta.jms.JMSException jmse = new jakarta.jms.JMSException(jmserrmsg);
                _loggerJS.severe(jmserrmsg);
                throw jmse;
            }
            _life = Destination.Life.TEMPORARY;
        }
        if (destination instanceof Queue) {
            _name = ((Queue)destination).getQueueName();
            _type = Destination.Type.QUEUE;
        }
        if (destination instanceof Topic) {
            _name = ((Topic)destination).getTopicName();
            _type = Destination.Type.TOPIC;
        }
        _destination = new Destination(_name, _type, _life);
        this.dc._createDestination(_destination);
        return _destination;
    }

    private void _unsupported(String methodname) throws jakarta.jms.JMSException {
        String unsupported = "MQJMSRA_DS2001: sessionId=" + this.sessionId + ":" + methodname;
        _loggerJS.warning(unsupported);
        throw new jakarta.jms.JMSException(unsupported);
    }

    protected void addConsumer(DirectConsumer consumer) {
        this.consumers.add(consumer);
    }

    protected void removeConsumer(DirectConsumer consumer) {
        boolean result = this.consumers.remove(consumer);
        assert (result);
    }

    protected void addProducer(DirectProducer producer) {
        this.producers.add(producer);
    }

    protected void removeProducer(DirectProducer producer) {
        boolean result = this.producers.remove(producer);
        assert (result);
    }

    protected void addBrowser(DirectQueueBrowser browser) {
        this.browsers.add(browser);
    }

    protected void removeBrowser(DirectQueueBrowser browser) {
        boolean result = this.browsers.remove(browser);
        assert (result);
    }

    protected long _createProducerId(Destination destination) throws jakarta.jms.JMSException {
        long producerId = 0L;
        try {
            JMSServiceReply reply = this.jmsservice.addProducer(this.connectionId, this.sessionId, destination);
            try {
                producerId = reply.getJMQProducerID();
            }
            catch (NoSuchFieldException nsfe) {
                String exerrmsg = "MQJMSRA_DS4001: JMSServiceException:Missing JMQProducerID";
                jakarta.jms.JMSException jmse = new jakarta.jms.JMSException(exerrmsg);
                jmse.initCause((Throwable)nsfe);
                _loggerJS.severe(exerrmsg);
                throw jmse;
            }
        }
        catch (JMSServiceException jse) {
            String failure_cause;
            JMSServiceReply.Status status = jse.getJMSServiceReply().getStatus();
            String exerrmsg = "createProducer on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and sessionId:" + this.sessionId + " due to ";
            Throwable jmsse = null;
            switch (status) {
                case FORBIDDEN: {
                    failure_cause = "client forbidden to send messages to this destination.";
                    exerrmsg = exerrmsg + failure_cause;
                    jmsse = new JMSSecurityException(exerrmsg, jse.getJMSServiceReply().getErrorCode());
                    break;
                }
                case NOT_FOUND: {
                    failure_cause = "destination not found and cannot be auto-created.";
                    break;
                }
                case CONFLICT: {
                    failure_cause = "destination limit for number of producers exceeded.";
                    break;
                }
                default: {
                    failure_cause = "unkown JMSService server error.";
                }
            }
            _loggerJS.severe(exerrmsg);
            if (jmsse == null) {
                jmsse = new jakarta.jms.JMSException(exerrmsg + failure_cause);
            }
            jmsse.initCause((Throwable)jse);
            throw jmsse;
        }
        return producerId;
    }

    private DirectProducer _createAndAddProducer(String methodName, jakarta.jms.Destination destination) throws jakarta.jms.JMSException {
        long producerId = 0L;
        Destination jmsservice_dest = null;
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName + ":Destination=" + destination);
        }
        this._checkIfClosed(methodName);
        if (destination != null) {
            String _name = null;
            Destination.Type _type = Destination.Type.QUEUE;
            Destination.Life _life = Destination.Life.STANDARD;
            if (destination instanceof Queue) {
                _name = ((Queue)destination).getQueueName();
                _type = Destination.Type.QUEUE;
                if (destination instanceof jakarta.jms.TemporaryQueue) {
                    _life = Destination.Life.TEMPORARY;
                }
            }
            if (destination instanceof Topic) {
                _name = ((Topic)destination).getTopicName();
                _type = Destination.Type.TOPIC;
                if (destination instanceof jakarta.jms.TemporaryTopic) {
                    _life = Destination.Life.TEMPORARY;
                }
            }
            jmsservice_dest = new Destination(_name, _type, _life);
            this.dc._createDestination(jmsservice_dest);
            producerId = this._createProducerId(jmsservice_dest);
        }
        DirectProducer dp = new DirectProducer(this, this.jmsservice, producerId, destination, jmsservice_dest);
        this.addProducer(dp);
        return dp;
    }

    private DirectConsumer _createAndAddConsumer(String methodName, jakarta.jms.Destination destination, String selector, boolean noLocal) throws jakarta.jms.JMSException {
        return this._createAndAddConsumer(methodName, destination, selector, null, false, false, false, noLocal);
    }

    private DirectConsumer _createAndAddConsumer(String methodName, jakarta.jms.Destination destination, String selector, String subscriptionName, boolean durable, boolean share, boolean jmsshare, boolean noLocal) throws jakarta.jms.JMSException {
        long consumerId = 0L;
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName + ":Destination=" + destination + ":Selector=" + selector + ":subscriptionName=" + subscriptionName + ":durable=" + durable + ":share=" + share + ":jmsshare=" + jmsshare + ":noLocal=" + noLocal);
        }
        this._checkIfClosed(methodName);
        Destination jmsservice_dest = this._checkDestinationForConsumer(destination);
        String duraname = durable ? subscriptionName : null;
        DirectConsumer consumer = new DirectConsumer(this, this.jmsservice, destination, jmsservice_dest, noLocal, selector, duraname);
        try {
            JMSServiceReply reply = this.jmsservice.addConsumer(this.connectionId, this.sessionId, jmsservice_dest, selector, subscriptionName, durable, share, jmsshare, this.getConnection()._getClientID(), noLocal);
            try {
                consumerId = reply.getJMQConsumerID();
                consumer._setConsumerId(consumerId);
            }
            catch (NoSuchFieldException nsfe) {
                String exerrmsg = "MQJMSRA_DS4001: JMSServiceException:Missing JMQConsumerID";
                jakarta.jms.JMSException jmse = new jakarta.jms.JMSException(exerrmsg);
                jmse.initCause((Throwable)nsfe);
                _loggerJS.severe(exerrmsg);
                throw jmse;
            }
        }
        catch (JMSServiceException jse) {
            Object failure_cause;
            JMSServiceReply.Status status = jse.getJMSServiceReply().getStatus();
            Object jmsse = null;
            String exerrmsg = "createConsumer on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and sessionId:" + this.sessionId + " due to ";
            switch (status) {
                case FORBIDDEN: {
                    failure_cause = "client forbidden to receive messages from this destination.";
                    exerrmsg = exerrmsg + (String)failure_cause;
                    jmsse = new JMSSecurityException(exerrmsg, jse.getJMSServiceReply().getErrorCode());
                    break;
                }
                case NOT_FOUND: {
                    failure_cause = "destination not found and cannot be auto-created.";
                    break;
                }
                case CONFLICT: {
                    failure_cause = "destination limit for number of consumers exceeded.";
                    break;
                }
                case BAD_REQUEST: {
                    failure_cause = "invalid selector=" + selector;
                    exerrmsg = exerrmsg + (String)failure_cause;
                    jmsse = new InvalidSelectorException(exerrmsg);
                    break;
                }
                case PRECONDITION_FAILED: {
                    if (jse.getCause() != null && jse.getCause() instanceof BrokerException) {
                        failure_cause = jse.getCause().getMessage();
                        exerrmsg = exerrmsg + (String)failure_cause;
                        jmsse = new IllegalStateException(exerrmsg, ((BrokerException)jse.getCause()).getErrorCode());
                        break;
                    }
                }
                default: {
                    failure_cause = "unknown JMSService server error.";
                }
            }
            _loggerJS.severe(exerrmsg);
            if (jmsse == null) {
                exerrmsg = exerrmsg + (String)failure_cause;
                jmsse = new jakarta.jms.JMSException(exerrmsg);
            }
            jmsse.initCause((Throwable)jse);
            throw jmsse;
        }
        this.addConsumer(consumer);
        if (subscriptionName != null && durable) {
            this.dc.addDurableConsumer(consumer);
        }
        if (destination instanceof TemporaryDestination) {
            this.dc._incrementTemporaryDestinationUsage((TemporaryDestination)destination);
        }
        return consumer;
    }

    private DirectQueueBrowser _createAndAddBrowser(String methodName, Queue destination, String selector) throws jakarta.jms.JMSException {
        long consumerId = 0L;
        DirectQueueBrowser browser = null;
        if (_logFINE) {
            _loggerJS.fine("MQJMSRA_DS1101: sessionId=" + this.sessionId + ":" + methodName + ":Destination=" + destination + ":selector=" + selector);
        }
        this._checkIfClosed(methodName);
        Destination jmsservice_dest = this._checkDestinationForConsumer((jakarta.jms.Destination)destination);
        try {
            JMSServiceReply reply = this.jmsservice.addBrowser(this.connectionId, this.sessionId, jmsservice_dest, selector);
            try {
                consumerId = reply.getJMQConsumerID();
            }
            catch (NoSuchFieldException nsfe) {
                String exerrmsg = _lgrMID_EXC + methodName + "JMSServiceException:Missing JMQConsumerID";
                jakarta.jms.JMSException jmse = new jakarta.jms.JMSException(exerrmsg);
                jmse.initCause((Throwable)nsfe);
                _loggerJS.severe(exerrmsg);
                throw jmse;
            }
            browser = new DirectQueueBrowser(this, this.jmsservice, consumerId, destination, jmsservice_dest, selector);
        }
        catch (JMSServiceException jse) {
            Object failure_cause;
            JMSServiceReply.Status status = jse.getJMSServiceReply().getStatus();
            Throwable jmsse = null;
            String exerrmsg = "createBrowser on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and sessionId:" + this.sessionId + " due to ";
            switch (status) {
                case FORBIDDEN: {
                    failure_cause = "client forbidden to browse messages from this destination.";
                    exerrmsg = exerrmsg + (String)failure_cause;
                    jmsse = new JMSSecurityException(exerrmsg, jse.getJMSServiceReply().getErrorCode());
                    break;
                }
                case NOT_FOUND: {
                    failure_cause = "destination not found and cannot be auto-created.";
                    break;
                }
                case CONFLICT: {
                    failure_cause = "destination limit for number of consumers exceeded.";
                    break;
                }
                case BAD_REQUEST: {
                    failure_cause = "invalid selector=" + selector;
                    exerrmsg = exerrmsg + (String)failure_cause;
                    jmsse = new InvalidSelectorException(exerrmsg);
                    break;
                }
                default: {
                    failure_cause = "unkown JMSService server error.";
                }
            }
            _loggerJS.severe(exerrmsg);
            if (jmsse == null) {
                exerrmsg = exerrmsg + (String)failure_cause;
                jmsse = new jakarta.jms.JMSException(exerrmsg);
            }
            jmsse.initCause((Throwable)jse);
            throw jmsse;
        }
        this.addBrowser(browser);
        return browser;
    }

    private void _closeAndClearProducers() {
        DirectProducer dp = null;
        Iterator<DirectProducer> k = this.producers.iterator();
        while (k.hasNext()) {
            dp = k.next();
            try {
                dp._close();
                k.remove();
            }
            catch (jakarta.jms.JMSException jmsedpc) {
                _loggerJS.warning("MQJMSRA_DS2001: sessionId=" + this.sessionId + ":close_producer:producerId:" + dp.getProducerId() + ":JMSException=" + jmsedpc.getMessage());
            }
        }
        this.producers.clear();
    }

    private void _closeAndClearConsumers() {
        DirectConsumer dc = null;
        Iterator<DirectConsumer> k = this.consumers.iterator();
        while (k.hasNext()) {
            dc = k.next();
            try {
                dc._close();
                k.remove();
            }
            catch (jakarta.jms.JMSException jmsedcc) {
                _loggerJS.warning("MQJMSRA_DS2001: sessionId=" + this.sessionId + ":close_consumer:consumerId:" + dc.getConsumerId() + ":JMSException=" + jmsedcc.getMessage());
            }
        }
        this.consumers.clear();
    }

    private void _closeAndClearBrowsers() {
        DirectQueueBrowser dqb = null;
        Iterator<DirectQueueBrowser> k = this.browsers.iterator();
        while (k.hasNext()) {
            dqb = k.next();
            try {
                dqb._close();
                k.remove();
            }
            catch (jakarta.jms.JMSException jmsedpc) {
                _loggerJS.warning("MQJMSRA_DS2001: sessionId=" + this.sessionId + ":close_producer:consumerId:" + dqb.getConsumerId() + ":JMSException=" + jmsedpc.getMessage());
            }
        }
        this.browsers.clear();
    }

    protected synchronized void _sendMessage(JMSPacket msgPkt) throws jakarta.jms.JMSException {
        if (ResourceAdapter._isFixBUGDB18849350()) {
            if (this.dc.isManaged() && this.dc.isEnlisted()) {
                msgPkt.getPacket().setTransactionID(this.dc._getXAResource()._getTransactionId());
            } else if (this.transactionId != 0L) {
                msgPkt.getPacket().setTransactionID(this.transactionId);
            } else {
                msgPkt.getPacket().setTransactionID(0L);
                msgPkt.getPacket().setIsTransacted(false);
            }
        } else if (this.transactionId != 0L) {
            msgPkt.getPacket().setTransactionID(this.transactionId);
        } else if (this.dc.isManaged() && this.dc.isEnlisted()) {
            msgPkt.getPacket().setTransactionID(this.dc._getXAResource()._getTransactionId());
        } else {
            msgPkt.getPacket().setTransactionID(0L);
            msgPkt.getPacket().setIsTransacted(false);
        }
        try {
            this.jmsservice.sendMessage(this.connectionId, msgPkt);
        }
        catch (JMSServiceException jmsse) {
            String exerrmsg = "MQJMSRA_DS4001: JMSServiceException on send message:" + jmsse.getMessage();
            jakarta.jms.JMSException jmse = new jakarta.jms.JMSException(exerrmsg);
            jmse.initCause((Throwable)jmsse);
            _loggerJS.severe(exerrmsg);
            throw jmse;
        }
    }

    protected synchronized JMSAck _deliverMessage(jakarta.jms.MessageListener msgListener, JMSPacket jmsPacket, long consumerId) throws ConsumerClosedNoDeliveryException {
        DirectAck jmsAck = null;
        SysMessageID messageID = null;
        if (this.enableThreadCheck) {
            long tId = Thread.currentThread().getId();
            if (this.deliverThreadId == 0L) {
                this.deliverThreadId = tId;
            } else if (this.deliverThreadId != tId) {
                throw new RuntimeException("Invalid to call deliver from two different threads!");
            }
        }
        Message jmsMsg = null;
        if (msgListener == null) {
            throw new RuntimeException("DirectConsumer:MessageListener not set!");
        }
        if (jmsPacket == null) {
            throw new RuntimeException("DirectConsumer:JMSPacket is null!");
        }
        try {
            jmsMsg = DirectPacket.constructMessage(jmsPacket, consumerId, this, this.jmsservice, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jmsMsg == null) {
            throw new RuntimeException("DirectConsumer:JMS Message in Packet is null!");
        }
        try {
            this.inDeliver = true;
            msgListener.onMessage(jmsMsg);
            this.inDeliver = false;
            messageID = ((DirectPacket)jmsMsg).getReceivedSysMessageID();
            if (this.ackMode != JMSService.SessionAckMode.CLIENT_ACKNOWLEDGE) {
                jmsAck = new DirectAck(this.connectionId, this.sessionId, consumerId, messageID, JMSService.MessageAckType.ACKNOWLEDGE);
            } else if (!this._isMDBSession()) {
                this.unackedMessageIDs.add(messageID);
                this.unackedConsumerIDs.add(consumerId);
            }
        }
        catch (ConsumerClosedNoDeliveryException e) {
            throw e;
        }
        catch (Exception e) {
            System.out.println("DirectConsumer:Caught Exception delivering message" + e.getMessage());
        }
        return jmsAck;
    }

    protected synchronized Message _fetchMessage(DirectConsumer consumer, long consumerId, long timeout, String methodName) throws jakarta.jms.JMSException {
        JMSPacket jmsPacket = null;
        Message jmsMsg = null;
        SysMessageID messageID = null;
        long xaTxnId = 0L;
        xaTxnId = this.dc.isManaged() && this.dc.isEnlisted() ? this.dc._getXAResource()._getTransactionId() : this._getTransactionId();
        try {
            jmsPacket = this.jmsservice.fetchMessage(this.connectionId, this.sessionId, consumerId, timeout, this.ackOnFetch, xaTxnId);
        }
        catch (JMSServiceException jMSServiceException) {
            // empty catch block
        }
        if (jmsPacket == null) {
            return null;
        }
        try {
            jmsMsg = DirectPacket.constructMessage(jmsPacket, consumerId, this, this.jmsservice, false);
            consumer.setLastMessageSeen(((DirectPacket)jmsMsg).getReceivedSysMessageID());
            if (this.ackMode == JMSService.SessionAckMode.CLIENT_ACKNOWLEDGE) {
                messageID = ((DirectPacket)jmsMsg).getReceivedSysMessageID();
                this.unackedMessageIDs.add(messageID);
                this.unackedConsumerIDs.add(consumerId);
            }
            return jmsMsg;
        }
        catch (Exception e) {
            String exerrmsg = "MQJMSRA_DS4001: receive:Exception constructing message:" + e.getMessage();
            jakarta.jms.JMSException jmse = new jakarta.jms.JMSException(exerrmsg);
            jmse.initCause((Throwable)e);
            _loggerJS.warning(exerrmsg);
            throw jmse;
        }
    }

    protected synchronized <T> T _fetchMessageBody(DirectConsumer consumer, long consumerId, long timeout, Class<T> c, String methodName) throws jakarta.jms.JMSException {
        T body = null;
        MessageFormatException savedMFE = null;
        JMSPacket jmsPacket = null;
        Message jmsMsg = null;
        SysMessageID messageID = null;
        long xaTxnId = 0L;
        xaTxnId = this.dc.isManaged() && this.dc.isEnlisted() ? this.dc._getXAResource()._getTransactionId() : this._getTransactionId();
        try {
            boolean autoAcknowledge = false;
            jmsPacket = this.jmsservice.fetchMessage(this.connectionId, this.sessionId, consumerId, timeout, autoAcknowledge, xaTxnId);
        }
        catch (JMSServiceException jmsse) {
            throw new JMSException(jmsse.getMessage(), null, jmsse);
        }
        if (jmsPacket != null) {
            try {
                jmsMsg = DirectPacket.constructMessage(jmsPacket, consumerId, this, this.jmsservice, false);
                if (this.ackMode == JMSService.SessionAckMode.CLIENT_ACKNOWLEDGE) {
                    messageID = ((DirectPacket)jmsMsg).getReceivedSysMessageID();
                    this.unackedMessageIDs.add(messageID);
                    this.unackedConsumerIDs.add(consumerId);
                }
            }
            catch (Exception e) {
                String exerrmsg = "MQJMSRA_DS4001: receive:Exception constructing message:" + e.getMessage();
                jakarta.jms.JMSException jmse = new jakarta.jms.JMSException(exerrmsg);
                jmse.initCause((Throwable)e);
                _loggerJS.warning(exerrmsg);
                throw jmse;
            }
            try {
                body = this.returnPayload(jmsMsg, c);
                consumer.setLastMessageSeen(((DirectPacket)jmsMsg).getReceivedSysMessageID());
            }
            catch (MessageFormatException mfe) {
                if (xaTxnId == 0L && (this.getAcknowledgeMode() == 1 || this.getAcknowledgeMode() == 3)) {
                    try {
                        SysMessageID[] messageIDs = new SysMessageID[]{jmsPacket.getPacket().getSysMessageID()};
                        Long[] consumerIDs = new Long[]{consumerId};
                        boolean setRedelivered = false;
                        this.jmsservice.redeliverMessages(this.connectionId, this.sessionId, messageIDs, consumerIDs, xaTxnId, setRedelivered);
                    }
                    catch (JMSServiceException jmsse) {
                        throw new JMSException(jmsse.getMessage(), null, jmsse);
                    }
                    throw mfe;
                }
                consumer.setLastMessageSeen(((DirectPacket)jmsMsg).getReceivedSysMessageID());
                savedMFE = mfe;
            }
            if (this.ackOnFetch) {
                try {
                    SysMessageID sysMessageID = jmsPacket.getPacket().getSysMessageID();
                    this.jmsservice.acknowledgeMessage(this.connectionId, this.sessionId, consumerId, sysMessageID, xaTxnId, JMSService.MessageAckType.ACKNOWLEDGE);
                }
                catch (JMSServiceException jMSServiceException) {
                    // empty catch block
                }
            }
        }
        if (savedMFE != null) {
            throw savedMFE;
        }
        return body;
    }

    private <T> T returnPayload(Message message, Class<T> c) throws jakarta.jms.JMSException {
        Object body = message.getBody(c);
        if (body == null) {
            String errorString = AdministeredObject.cr.getKString("C4320");
            MessageFormatException jmse = new MessageFormatException(errorString, "C4320");
            ExceptionHandler.throwJMSException((jakarta.jms.JMSException)((Object)jmse));
        }
        return (T)body;
    }

    protected void _acknowledgeThisMessage(DirectPacket msgPkt, long consumerId, JMSService.MessageAckType ackType) throws jakarta.jms.JMSException {
        long transactionId = 0L;
        if (this.dc.isManaged()) {
            DirectXAResource dxar = this.dc._getXAResource();
            if (dxar != null && dxar.isEnlisted()) {
                transactionId = dxar._getTransactionId();
            }
        } else {
            transactionId = this.transactionId;
        }
        this._acknowledgeMessage(msgPkt, consumerId, transactionId, ackType, -1);
        SysMessageID _sysMsgID = msgPkt.getReceivedSysMessageID();
        int index = this.unackedMessageIDs.indexOf(_sysMsgID);
        this.unackedMessageIDs.remove(index);
        this.unackedConsumerIDs.remove(index);
    }

    protected void _acknowledgeThisMessageForMDB(DirectPacket msgPkt, long consumerId, JMSService.MessageAckType ackType, DirectXAResource dxar, int retryCount) throws jakarta.jms.JMSException {
        long transactionId = 0L;
        if (dxar != null && dxar.isEnlisted()) {
            transactionId = dxar._getTransactionId();
        }
        this._acknowledgeMessage(msgPkt, consumerId, transactionId, ackType, retryCount);
    }

    protected void _acknowledgeMessage(DirectPacket msgPkt, long consumerId, long transactionId, JMSService.MessageAckType ackType, int retryCount) throws jakarta.jms.JMSException {
        try {
            if (retryCount > 0) {
                this.jmsservice.acknowledgeMessage(this.connectionId, this.sessionId, consumerId, msgPkt.getReceivedSysMessageID(), transactionId, ackType, retryCount);
            } else {
                this.jmsservice.acknowledgeMessage(this.connectionId, this.sessionId, consumerId, msgPkt.getReceivedSysMessageID(), transactionId, ackType);
            }
        }
        catch (JMSServiceException jmsse) {
            String failure_cause;
            JMSServiceReply.Status status = jmsse.getJMSServiceReply().getStatus();
            switch (status) {
                case NOT_FOUND: {
                    failure_cause = "message not found and cannot be acknowledged";
                    break;
                }
                default: {
                    failure_cause = "unkown JMSService server error.";
                }
            }
            String exerrmsg = "acknowledgeMessage on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + " and sessionId:" + this.sessionId + " and consumerId:" + consumerId + " due to " + failure_cause;
            _loggerJS.severe(exerrmsg);
            jakarta.jms.JMSException jmse = new jakarta.jms.JMSException(exerrmsg);
            jmse.initCause((Throwable)jmsse);
            throw jmse;
        }
    }

    protected void _setMDBSession(boolean isMDBSession) {
        this.isMDBSession = isMDBSession;
    }

    protected boolean _isMDBSession() {
        return this.isMDBSession;
    }

    static {
        int tmplevel = Level.INFO.intValue();
        boolean tmplogfine = false;
        Level _level = _loggerJS.getLevel();
        if (_level != null && (tmplevel = _level.intValue()) <= Level.FINE.intValue()) {
            tmplogfine = true;
        }
        _logLevel = tmplevel;
        _logFINE = tmplogfine;
    }
}

