/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra.util;

import jakarta.resource.spi.InvalidPropertyException;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;

public class CustomTokenizer {
    private static final char ESCAPE_CHAR = '\\';
    private static final String QUOTE_STRING = "\"";
    private int size = 0;
    private ListIterator tokenIterator = null;

    public CustomTokenizer(String stringToken, String delimiter) throws InvalidPropertyException {
        if (!this.checkForMatchingQuotes(stringToken)) {
            throw new InvalidPropertyException("UnclosedString");
        }
        if (stringToken == null || delimiter == null) {
            throw new InvalidPropertyException("CouldNotCreateCliTokenizer");
        }
        this.tokenIterator = this.populateList(stringToken, delimiter);
    }

    public int countTokens() {
        return this.size;
    }

    public boolean hasMoreTokens() {
        return this.tokenIterator.hasNext();
    }

    public String nextTokenWithoutEscapeAndQuoteChars() throws InvalidPropertyException {
        String strWOEscape = this.removeEscapeChars((String)this.tokenIterator.next());
        String strWOQuotes = this.removeQuoteChars(strWOEscape);
        return this.removeEscapeCharsFromQuotes(strWOQuotes);
    }

    public String nextToken() throws InvalidPropertyException {
        return (String)this.tokenIterator.next();
    }

    private boolean checkForMatchingQuotes(String str) throws InvalidPropertyException {
        int beginQuote = this.getStringDelimiterIndex(str, QUOTE_STRING, 0);
        while (beginQuote != -1) {
            int endQuote = this.getStringDelimiterIndex(str, QUOTE_STRING, beginQuote + 1);
            if (endQuote == -1) {
                return false;
            }
            beginQuote = this.getStringDelimiterIndex(str, QUOTE_STRING, endQuote + 1);
        }
        return true;
    }

    private ListIterator populateList(String strToken, String delimiter) throws InvalidPropertyException {
        Vector<String> tokenList = new Vector<String>();
        int endIndex = this.getStringDelimiterIndex(strToken, delimiter, 0);
        if (endIndex == -1) {
            tokenList.add(strToken);
        } else {
            int beginIndex = 0;
            while (endIndex > -1) {
                if (beginIndex != endIndex) {
                    tokenList.add(strToken.substring(beginIndex, endIndex));
                }
                beginIndex = endIndex + 1;
                endIndex = this.getStringDelimiterIndex(strToken, delimiter, beginIndex);
            }
            if (beginIndex != strToken.length()) {
                tokenList.add(strToken.substring(beginIndex));
            }
        }
        this.size = tokenList.size();
        try {
            return tokenList.listIterator();
        }
        catch (IndexOutOfBoundsException ioe) {
            throw new InvalidPropertyException((Throwable)ioe);
        }
    }

    private String removeEscapeChars(String strValue) throws InvalidPropertyException {
        int prefixIndex = 0;
        StringBuilder strbuff = new StringBuilder();
        while (prefixIndex < strValue.length()) {
            int delimeterIndex = this.getStringDelimiterIndex(strValue, String.valueOf('\\'), prefixIndex);
            if (delimeterIndex == -1) {
                strbuff.append(strValue.substring(prefixIndex));
                break;
            }
            if (delimeterIndex + 1 < strValue.length() && String.valueOf(strValue.charAt(delimeterIndex + 1)).equals(QUOTE_STRING)) {
                strbuff.append(strValue.substring(prefixIndex, delimeterIndex + 1));
            } else {
                strbuff.append(strValue.substring(prefixIndex, delimeterIndex));
            }
            prefixIndex = delimeterIndex + 1;
        }
        return strbuff.toString();
    }

    private String removeEscapeCharsFromQuotes(String strValue) {
        int prefixIndex = 0;
        StringBuilder strbuff = new StringBuilder();
        while (prefixIndex < strValue.length()) {
            int delimeterIndex = strValue.indexOf(String.valueOf('\\'), prefixIndex);
            if (delimeterIndex == -1) {
                strbuff.append(strValue.substring(prefixIndex));
                break;
            }
            if (String.valueOf(strValue.charAt(delimeterIndex + 1)).equals(QUOTE_STRING)) {
                strbuff.append(strValue.substring(prefixIndex, delimeterIndex));
            } else {
                strbuff.append(strValue.substring(prefixIndex, delimeterIndex + 1));
            }
            prefixIndex = delimeterIndex + 1;
        }
        return strbuff.toString();
    }

    private String removeQuoteChars(String strValue) throws InvalidPropertyException {
        int prefixIndex = 0;
        StringBuilder strbuff = new StringBuilder();
        while (prefixIndex < strValue.length()) {
            int delimeterIndex = this.getStringDelimiterIndex(strValue, QUOTE_STRING, prefixIndex);
            if (delimeterIndex == -1) {
                strbuff.append(strValue.substring(prefixIndex));
                break;
            }
            strbuff.append(strValue.substring(prefixIndex, delimeterIndex));
            prefixIndex = delimeterIndex + 1;
        }
        return strbuff.toString();
    }

    private int getStringDelimiterIndex(String strToken, String delimiter, int fromIndex) throws InvalidPropertyException {
        if (fromIndex > strToken.length() - 1) {
            return -1;
        }
        int hasDelimiter = strToken.indexOf(delimiter, fromIndex);
        int quoteBeginIndex = strToken.indexOf(QUOTE_STRING, fromIndex);
        if (quoteBeginIndex != -1 && hasDelimiter != -1 && quoteBeginIndex < hasDelimiter) {
            int quoteEndIndex = strToken.indexOf(QUOTE_STRING, quoteBeginIndex + 1);
            if (quoteEndIndex == -1) {
                throw new InvalidPropertyException("UnclosedString");
            }
            if (quoteEndIndex != strToken.length() - 1) {
                return this.getStringDelimiterIndex(strToken, delimiter, quoteEndIndex + 1);
            }
            return -1;
        }
        if (hasDelimiter > 0 && strToken.charAt(hasDelimiter - 1) == '\\') {
            return this.getStringDelimiterIndex(strToken, delimiter, hasDelimiter + 1);
        }
        return hasDelimiter;
    }

    public static void main(String[] args) throws Exception {
        String str = "imqConsumerFlowThreshold=78,imqAddressList=tcp://localhost:7676\\,tcp://localhost:7677";
        System.out.println("Parsing " + str);
        String separator = "=";
        String delimiter = ",";
        CustomTokenizer tokenList = new CustomTokenizer(str, delimiter);
        while (tokenList.hasMoreTokens()) {
            String propValuePair = tokenList.nextTokenWithoutEscapeAndQuoteChars();
            int loc = propValuePair.indexOf(separator);
            String propName = propValuePair.substring(0, loc);
            String propValue = propValuePair.substring(loc + separator.length());
            System.out.println("name=" + propName);
            System.out.println("value=" + propValue);
        }
    }

    public static Hashtable<String, String> parseToProperties(String prop) throws InvalidPropertyException {
        String separator = "=";
        String delimiter = ",";
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (prop == null || prop.trim().equals("")) {
            return result;
        }
        CustomTokenizer tokenList = new CustomTokenizer(prop, delimiter);
        while (tokenList.hasMoreTokens()) {
            String propValuePair = tokenList.nextTokenWithoutEscapeAndQuoteChars();
            int loc = propValuePair.indexOf(separator);
            String propName = propValuePair.substring(0, loc);
            String propValue = propValuePair.substring(loc + separator.length());
            result.put(propName, propValue);
        }
        return result;
    }
}

