/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.jline.reader.EndOfFileException;
import org.jline.reader.UserInterruptException;
import org.jvnet.hk2.annotations.Service;

@Service(name="setup-local-dcom")
@PerLookup
public final class SetupLocalDcom
extends CLICommand {
    @Param(name="verbose", shortName="v", primary=false, optional=true)
    boolean verbose;
    @Param(name="force", shortName="f", primary=false, optional=true)
    boolean force;
    private static final String[] DEPENDENCIES = new String[]{"advapi32.dll", "kernel32.dll"};
    private static final String CPP_APP_FILENAME = "DcomConfigurator.exe";
    private static final File TMPDIR = new File(System.getProperty("java.io.tmpdir"));
    private static final File CPP_APP = new File(TMPDIR, "DcomConfigurator.exe");

    protected void validate() throws CommandException {
        super.validate();
        if (!OS.isWindowsForSure()) {
            throw new CommandException(Strings.get("vld.windows.only"));
        }
        try {
            this.buildTerminal();
            this.buildLineReader();
            if (this.lineReader == null) {
                throw new CommandException(Strings.get("vld.noconsole"));
            }
        }
        finally {
            this.closeTerminal();
        }
        if (!this.force) {
            this.areYouSure();
        }
        this.checkPath();
        this.prepareCppApp();
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        try {
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add(CPP_APP.getAbsolutePath());
            if (this.verbose) {
                cmds.add("--verbose");
            }
            ProcessManager pm = new ProcessManager(cmds);
            pm.execute();
            int ret = pm.getExitValue();
            if (this.verbose || ret != 0) {
                logger.log(Level.INFO, "{0}{1}", new Object[]{pm.getStdout(), pm.getStderr()});
            }
            return ret;
        }
        catch (ProcessManagerException ex) {
            throw new CommandException((Throwable)ex);
        }
    }

    private void checkPath() throws CommandException {
        ArrayList<String> notFound = new ArrayList<String>();
        for (String dll : DEPENDENCIES) {
            File f = ProcessUtils.getExe((String)dll);
            if (f == null) {
                notFound.add(dll);
                continue;
            }
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.finer("Required DLL Located: " + f);
        }
        if (!notFound.isEmpty()) {
            throw SetupLocalDcom.prepareMissingDllMessage(notFound);
        }
    }

    private static CommandException prepareMissingDllMessage(List<String> notFound) {
        StringBuilder sb = new StringBuilder();
        for (String dll : notFound) {
            sb.append('\t').append(dll).append('\n');
        }
        String msg = Strings.get("vld.missing.dlls", sb.toString());
        return new CommandException(msg);
    }

    private void prepareCppApp() throws CommandException {
        if (!TMPDIR.isDirectory()) {
            throw this.exceptionMaker("internal.error", Strings.get("vld.badtempdir", TMPDIR));
        }
        if (!FileUtils.deleteFileMaybe((File)CPP_APP)) {
            throw this.exceptionMaker("vld.app.exists", CPP_APP);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(Strings.get("vld.app.deleted", CPP_APP));
        }
        FileUtils.deleteOnExit((File)CPP_APP);
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = ((Object)((Object)this)).getClass().getResourceAsStream("/lib/DcomConfigurator.exe");
            out = new FileOutputStream(CPP_APP);
            SetupLocalDcom.copyStream(in, out);
        }
        catch (IOException ex) {
            throw this.exceptionMaker("vld.error.extracting.ex", CPP_APP, ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (!CPP_APP.canExecute()) {
            throw this.exceptionMaker("vld.error.extracting", CPP_APP);
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        if (in == null || out == null) {
            throw new NullPointerException("internal error: null arguments");
        }
        byte[] buf = new byte[16384];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }

    private CommandException exceptionMaker(String key, Object ... args) {
        if (args == null || args.length == 0) {
            return new CommandException(Strings.get(key));
        }
        return new CommandException(Strings.get(key, args));
    }

    private void areYouSure() throws CommandException {
        if (!this.programOpts.isInteractive()) {
            throw new CommandException(Strings.get("vld.not.interactive"));
        }
        try {
            String answer = this.lineReader.readLine(String.format("%s:  ", Strings.get("vld.areyousure")));
            if (!"yes".equalsIgnoreCase(answer)) {
                throw new CommandException(Strings.get("vld.no"));
            }
        }
        catch (EndOfFileException | UserInterruptException throwable) {
            // empty catch block
        }
    }
}

