/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.monitoring.alert;

import fish.payara.monitoring.alert.Alert;
import fish.payara.monitoring.alert.Circumstance;
import fish.payara.monitoring.alert.Condition;
import fish.payara.monitoring.collect.MonitoringWatchCollector;
import fish.payara.monitoring.model.Metric;
import fish.payara.monitoring.model.Series;
import fish.payara.monitoring.model.SeriesDataset;
import fish.payara.monitoring.model.SeriesLookup;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public final class Watch
implements MonitoringWatchCollector.WatchBuilder,
Iterable<State>,
Serializable {
    private static final String GREEN_PROPERTY = "green";
    private static final String AMBER_PROPERTY = "amber";
    private static final String RED_PROPERTY = "red";
    public final String name;
    public final Metric watched;
    public final Circumstance red;
    public final Circumstance amber;
    public final Circumstance green;
    private final Metric[] captured;
    private final transient Map<String, State> statesByInstanceSeries;
    private final transient AtomicBoolean stopped = new AtomicBoolean(false);
    private final transient AtomicBoolean disabled;
    private final boolean programmatic;

    public Watch(String name, Metric watched) {
        this(name, watched, false, Circumstance.UNSPECIFIED, Circumstance.UNSPECIFIED, Circumstance.UNSPECIFIED, new Metric[0]);
    }

    public Watch(String name, Metric watched, boolean programmatic, Circumstance red, Circumstance amber, Circumstance green, Metric ... captured) {
        this(name, watched, programmatic, red, amber, green, captured, new AtomicBoolean(false), new ConcurrentHashMap<String, State>());
    }

    private Watch(String name, Metric watched, boolean programmatic, Circumstance red, Circumstance amber, Circumstance green, Metric[] captured, AtomicBoolean disabled, Map<String, State> statesByInstanceSeries) {
        this.name = name;
        this.watched = watched;
        this.programmatic = programmatic;
        this.red = red;
        this.amber = amber;
        this.green = green;
        this.captured = captured;
        this.disabled = disabled;
        this.statesByInstanceSeries = statesByInstanceSeries;
    }

    @Override
    public Iterator<State> iterator() {
        return this.statesByInstanceSeries.values().iterator();
    }

    public State state(SeriesDataset data) {
        return this.statesByInstanceSeries.computeIfAbsent(Watch.key(data), key -> new State(data));
    }

    public void stop() {
        if (this.stopped.compareAndSet(false, true)) {
            this.stopAlertsOfThisWatch();
        }
    }

    private void stopAlertsOfThisWatch() {
        for (State s : this.statesByInstanceSeries.values()) {
            if (s.ongoing == null) continue;
            long now = System.currentTimeMillis();
            s.ongoing.stop(Alert.Level.WHITE, now / 1000L * 1000L);
            s.ongoing = null;
            if (s.level != Alert.Level.WHITE) {
                s.levelSince = now;
            }
            s.level = Alert.Level.WHITE;
        }
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    public boolean isDisabled() {
        return this.disabled.get();
    }

    public void disable() {
        if (this.disabled.compareAndSet(false, true)) {
            this.stopAlertsOfThisWatch();
        }
    }

    public void enable() {
        this.disabled.set(false);
    }

    public boolean isProgrammatic() {
        return this.programmatic;
    }

    public Watch programmatic() {
        return new Watch(this.name, this.watched, true, this.red, this.amber, this.green, this.captured, this.disabled, this.statesByInstanceSeries);
    }

    public List<Alert> check(SeriesLookup lookup) {
        if (this.isStopped() || this.isDisabled()) {
            return Collections.emptyList();
        }
        ArrayList<Alert> raised = new ArrayList<Alert>();
        for (SeriesDataset data : lookup.selectSeries(this.watched.series, new String[0])) {
            Alert alert = this.check(lookup, data);
            if (alert == null) continue;
            raised.add(alert);
        }
        return raised;
    }

    private static String key(SeriesDataset data) {
        return data.getSeries().toString() + '#' + data.getInstance();
    }

    private Alert check(SeriesLookup lookup, SeriesDataset data) {
        State state = this.state(data);
        switch (state.level) {
            default: {
                return this.checkWhite(lookup, data, state);
            }
            case GREEN: {
                return this.checkGreen(lookup, data, state);
            }
            case AMBER: {
                return this.checkAmber(lookup, data, state);
            }
            case RED: 
        }
        return this.checkRed(lookup, data, state);
    }

    private Alert checkWhite(SeriesLookup lookup, SeriesDataset data, State state) {
        if (this.red.starts(data, lookup)) {
            return this.transitionTo(Alert.Level.RED, lookup, data, state);
        }
        if (this.amber.starts(data, lookup)) {
            return this.transitionTo(Alert.Level.AMBER, lookup, data, state);
        }
        if (this.green.starts(data, lookup)) {
            return this.transitionTo(Alert.Level.GREEN, lookup, data, state);
        }
        return null;
    }

    private Alert checkGreen(SeriesLookup lookup, SeriesDataset data, State state) {
        if (this.red.starts(data, lookup)) {
            return this.transitionTo(Alert.Level.RED, lookup, data, state);
        }
        if (this.amber.starts(data, lookup)) {
            return this.transitionTo(Alert.Level.AMBER, lookup, data, state);
        }
        if (!this.green.stops(data) || this.green.starts(data, lookup)) {
            return null;
        }
        return this.transitionTo(Alert.Level.WHITE, lookup, data, state);
    }

    private Alert checkAmber(SeriesLookup lookup, SeriesDataset data, State state) {
        if (this.red.starts(data, lookup)) {
            return this.transitionTo(Alert.Level.RED, lookup, data, state);
        }
        if (!this.amber.stops(data) || this.amber.starts(data, lookup)) {
            return null;
        }
        if (this.green.starts(data, lookup)) {
            return this.transitionTo(Alert.Level.GREEN, lookup, data, state);
        }
        return this.transitionTo(Alert.Level.WHITE, lookup, data, state);
    }

    private Alert checkRed(SeriesLookup lookup, SeriesDataset data, State state) {
        if (!this.red.stops(data) || this.red.starts(data, lookup)) {
            return null;
        }
        if (this.amber.starts(data, lookup)) {
            return this.transitionTo(Alert.Level.AMBER, lookup, data, state);
        }
        if (this.green.starts(data, lookup)) {
            return this.transitionTo(Alert.Level.GREEN, lookup, data, state);
        }
        return this.transitionTo(Alert.Level.WHITE, lookup, data, state);
    }

    private Alert transitionTo(Alert.Level to, SeriesLookup lookup, SeriesDataset data, State state) {
        if (state.level != to) {
            state.levelSince = System.currentTimeMillis();
        }
        state.level = to;
        Alert alert = state.ongoing;
        if (to == Alert.Level.WHITE || to == Alert.Level.GREEN) {
            if (alert != null) {
                alert.stop(to, data.lastTime());
            }
            state.ongoing = null;
            return null;
        }
        Alert raised = null;
        if (alert == null) {
            state.ongoing = raised = new Alert(this);
        }
        state.ongoing.addTransition(to, data, this.capturedData(lookup, data));
        return raised;
    }

    private List<SeriesDataset> capturedData(SeriesLookup lookup, SeriesDataset data) {
        ArrayList<SeriesDataset> res = new ArrayList<SeriesDataset>();
        for (int i = 0; i < this.captured.length; ++i) {
            res.addAll(lookup.selectSeries(this.captured[i].series, data.getInstance()));
        }
        return res;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Watch && this.equalTo((Watch)obj);
    }

    public boolean equalTo(Watch other) {
        return this.name.equals(other.name);
    }

    public boolean equalsFunctionally(Watch other) {
        return this.name.equals(other.name) && this.programmatic == other.programmatic && this.watched.equalTo(other.watched) && this.red.equalTo(other.red) && this.amber.equalTo(other.amber) && this.green.equalTo(other.green) && Arrays.equals(this.captured, other.captured);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.name).append(" ~ ").append(this.watched).append('\n');
        if (!this.red.isUnspecified()) {
            str.append('\t').append(this.red).append('\n');
        }
        if (!this.amber.isUnspecified()) {
            str.append('\t').append(this.amber).append('\n');
        }
        if (!this.green.isUnspecified()) {
            str.append('\t').append(this.green).append('\n');
        }
        if (this.captured.length > 0) {
            str.append('\t').append(Arrays.toString(this.captured)).append('\n');
        }
        str.append("State:\n");
        for (State s : this.statesByInstanceSeries.values()) {
            str.append("\t\t").append(s).append('\n');
        }
        return str.toString();
    }

    public Watch with(String level, long startThreshold, Number startForLast, boolean startOnAverage, Long stopTheshold, Number stopForLast, boolean stopOnAverage) {
        switch (level) {
            case "red": {
                return Watch.isEqual(this.red, startThreshold, startForLast, startOnAverage, stopTheshold, stopForLast, stopOnAverage) ? this : this.with(Watch.create(Alert.Level.RED, startThreshold, startForLast, startOnAverage, stopTheshold, stopForLast, stopOnAverage), this.amber, this.green);
            }
            case "amber": {
                return Watch.isEqual(this.amber, startThreshold, startForLast, startOnAverage, stopTheshold, stopForLast, stopOnAverage) ? this : this.with(this.red, Watch.create(Alert.Level.AMBER, startThreshold, startForLast, startOnAverage, stopTheshold, stopForLast, stopOnAverage), this.green);
            }
            case "green": {
                return Watch.isEqual(this.green, startThreshold, startForLast, startOnAverage, stopTheshold, stopForLast, stopOnAverage) ? this : this.with(this.red, this.amber, Watch.create(Alert.Level.GREEN, startThreshold, startForLast, startOnAverage, stopTheshold, stopForLast, startOnAverage));
            }
        }
        throw new IllegalArgumentException("No such alert level: " + level);
    }

    private Watch with(Circumstance red, Circumstance amber, Circumstance green) {
        return new Watch(this.name, this.watched, this.programmatic, red, amber, green, this.captured, this.disabled, this.statesByInstanceSeries);
    }

    public Watch red(long startThreshold, Number startFor, boolean startOnAverage, Long stopTheshold, Number stopFor, boolean stopOnAverage) {
        return this.with(RED_PROPERTY, startThreshold, startFor, startOnAverage, stopTheshold, stopFor, stopOnAverage);
    }

    public Watch amber(long startThreshold, Number startFor, boolean startOnAverage, Long stopTheshold, Number stopFor, boolean stopOnAverage) {
        return this.with(AMBER_PROPERTY, startThreshold, startFor, startOnAverage, stopTheshold, stopFor, stopOnAverage);
    }

    public Watch green(long startThreshold, Number startFor, boolean startOnAverage, Long stopTheshold, Number stopFor, boolean stopOnAverage) {
        return this.with(GREEN_PROPERTY, startThreshold, startFor, startOnAverage, stopTheshold, stopFor, stopOnAverage);
    }

    private static boolean isEqual(Circumstance sample, long startThreshold, Number startForLast, boolean startOnAverage, Long stopTheshold, Number stopForLast, boolean stopOnAverage) {
        return Watch.isEqual(sample.start, startThreshold, startForLast, startOnAverage) && Watch.isEqual(sample.stop, stopTheshold, stopForLast, stopOnAverage);
    }

    private static boolean isEqual(Condition sample, Long threshold, Number forLast, boolean onAverage) {
        if (threshold == null) {
            return sample.isNone();
        }
        if (!onAverage && forLast instanceof Integer && forLast.intValue() == 1) {
            forLast = null;
        }
        return !sample.isNone() && sample.threshold == Math.abs(threshold) && Objects.equals(sample.forLast, forLast) && sample.onAverage == onAverage;
    }

    private static Circumstance create(Alert.Level level, long startThreshold, Number startForLast, boolean startOnAverage, Long stopTheshold, Number stopForLast, boolean stopOnAverage) {
        Condition.Operator startComparison = startThreshold < 0L ? (level == Alert.Level.GREEN ? Condition.Operator.LE : Condition.Operator.LT) : (level == Alert.Level.GREEN ? Condition.Operator.GE : Condition.Operator.GT);
        Condition.Operator stopOperator = stopTheshold != null && stopTheshold < 0L ? Condition.Operator.GT : Condition.Operator.LT;
        Condition start = new Condition(startComparison, Math.abs(startThreshold), startForLast, startOnAverage);
        Condition stop = stopTheshold == null ? Condition.NONE : new Condition(stopOperator, Math.abs(stopTheshold), stopForLast, stopOnAverage);
        return new Circumstance(level, start, stop);
    }

    public JsonObject toJSON() {
        JsonArrayBuilder capturedArray = Json.createArrayBuilder();
        for (Metric m : this.captured) {
            capturedArray.add((JsonValue)m.toJSON());
        }
        return Json.createObjectBuilder().add("name", this.name).add("watched", (JsonValue)this.watched.toJSON()).add("programmatic", this.programmatic).add("disabled", this.isDisabled()).add("stopped", this.isStopped()).add(RED_PROPERTY, this.red.toJSON()).add(AMBER_PROPERTY, this.amber.toJSON()).add(GREEN_PROPERTY, this.green.toJSON()).add("captured", (JsonValue)capturedArray.build()).build();
    }

    public static Watch fromJSON(String json) {
        JsonValue value = null;
        try (JsonParser parser = Json.createParser((Reader)new StringReader(json));){
            if (!parser.hasNext()) {
                Watch watch = null;
                return watch;
            }
            parser.next();
            value = parser.getValue();
        }
        if (value == null || value == JsonValue.NULL) {
            return null;
        }
        JsonObject obj = value.asJsonObject();
        JsonArray array = obj.getJsonArray("captured");
        Metric[] captured = array == null ? new Metric[]{} : (Metric[])array.stream().map(Metric::fromJSON).toArray(Metric[]::new);
        Watch out = new Watch(obj.getString("name"), Metric.fromJSON((JsonValue)obj.get((Object)"watched")), obj.getBoolean("programmatic", false), Circumstance.fromJson((JsonValue)obj.get((Object)RED_PROPERTY)), Circumstance.fromJson((JsonValue)obj.get((Object)AMBER_PROPERTY)), Circumstance.fromJson((JsonValue)obj.get((Object)GREEN_PROPERTY)), captured);
        if (obj.getBoolean("disabled", false)) {
            out.disable();
        }
        if (obj.getBoolean("stopped", false)) {
            out.stop();
        }
        return out;
    }

    public static Watch fromRemote(Watch watch) {
        return new Watch(watch.name, watch.watched, watch.programmatic, watch.red, watch.amber, watch.green, watch.captured);
    }

    public static final class State {
        final SeriesDataset watchingSince;
        volatile Alert.Level level = Alert.Level.WHITE;
        volatile Alert ongoing;
        volatile Long levelSince;

        State(SeriesDataset watched) {
            this.watchingSince = watched;
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append((Object)this.level).append(" ").append(this.getSeries()).append(" ").append(this.getInstance());
            if (this.ongoing != null) {
                str.append(this.ongoing.toString());
            }
            return str.toString();
        }

        public String getInstance() {
            return this.watchingSince.getInstance();
        }

        public Series getSeries() {
            return this.watchingSince.getSeries();
        }

        public Long getSince() {
            return this.levelSince;
        }

        public Alert.Level getLevel() {
            return this.level;
        }
    }
}

