/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.jaspic;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.security.auth.message.module.ServerAuthModule;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

class SimpleSAMAuthContext
implements ServerAuthContext {
    ServerAuthModule sam;
    CallbackHandler handler;
    Map<String, Object> options;

    SimpleSAMAuthContext(String authContextID, Subject serviceSubject, Map<String, Object> properties, CallbackHandler handler, ServerAuthModule sam) throws AuthException {
        this.sam = sam;
        this.handler = handler;
        this.options = properties;
    }

    @Override
    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        MessagePolicy requestPolicy = new MessagePolicy(new MessagePolicy.TargetPolicy[]{new MessagePolicy.TargetPolicy(null, new MessagePolicy.ProtectionPolicy(){

            @Override
            public String getID() {
                return "#authenticateSender";
            }
        })}, true);
        this.sam.initialize(requestPolicy, null, this.handler, this.options);
        return this.sam.validateRequest(messageInfo, clientSubject, serviceSubject);
    }

    @Override
    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        return this.sam.secureResponse(messageInfo, serviceSubject);
    }

    @Override
    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        this.sam.cleanSubject(messageInfo, subject);
    }
}

