/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.jaspic;

import fish.payara.security.jaspic.SimpleSAMAuthContext;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.security.auth.message.module.ServerAuthModule;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public class SimpleSAMConfig
implements ServerAuthConfig {
    private final String layer;
    private final String appContext;
    private final CallbackHandler handler;
    private final Map<String, Object> constructedProperties;
    private volatile ServerAuthModule sam;
    private Class samClass;

    SimpleSAMConfig(String layer, String appContext, CallbackHandler handler, Map<String, Object> properties, Class samClass) {
        this.layer = layer;
        this.appContext = appContext;
        this.handler = handler;
        this.constructedProperties = properties;
        this.samClass = samClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerAuthContext getAuthContext(String authContextID, Subject serviceSubject, Map properties) throws AuthException {
        ServerAuthModule sam;
        ServerAuthModule localSam;
        if (this.constructedProperties != null) {
            properties.putAll(this.constructedProperties);
        }
        if ((localSam = this.sam) == null || properties.containsKey("fish.payara.security.jaspic.SAMPerRequest")) {
            try {
                localSam = (ServerAuthModule)this.samClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Logger.getLogger(SimpleSAMConfig.class.getName()).log(Level.SEVERE, null, ex);
                AuthException ae = new AuthException("Unable to instantiate an instance of the provided SAM class");
                ae.initCause(ex);
                throw ae;
            }
        }
        if ((sam = this.sam) == null) {
            SimpleSAMConfig simpleSAMConfig = this;
            synchronized (simpleSAMConfig) {
                this.sam = localSam;
            }
        }
        return new SimpleSAMAuthContext(authContextID, serviceSubject, properties, this.handler, localSam);
    }

    @Override
    public String getMessageLayer() {
        return this.layer;
    }

    @Override
    public String getAppContext() {
        return this.appContext;
    }

    @Override
    public String getAuthContextID(MessageInfo messageInfo) {
        return null;
    }

    @Override
    public void refresh() {
    }

    @Override
    public boolean isProtected() {
        return false;
    }
}

